/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.cclcorej.util.CCLResourceCounterSet;
import com.cognos.indications.ILogPerfIndication;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogPerfRenderer;
import com.cognos.indications.LogResourceCounterSet;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LogPerfIndication
extends LogIndication
implements ILogPerfIndication {
    public static final int LogPerfComponentLevel = 50000;
    public static final int LogPerfSubComponentLevel = 40000;
    public static final int LogPerfMethodLevel = 10000;
    public static final String LogPerfIndication_START = "START";
    public static final String LogPerfIndication_FINISH = "FINISH";
    public static final String LogPerfIndication_EXIT = "EXIT";
    public static final String LogPerfIndication_ENTER = "ENTER";
    public static final String LogPerfIndication_CALL = "CALL";
    public static final String LogPerfIndication_RETURN = "RETURN";
    public static final String LogPerfIndication_BEGIN = "BEGIN";
    public static final String LogPerfIndication_LOG = "LOG";
    private static final long serialVersionUID = 6595467847869210720L;
    protected CCLResourceCounterSet m_rcs = null;
    protected String m_logData;
    protected String m_classId;
    protected String m_methodId;
    protected String m_sequenceId;
    protected String m_executionId;
    protected String m_status;

    @Override
    public LogResourceCounterSet getRCS() {
        return (LogResourceCounterSet)this.m_rcs;
    }

    @Override
    public CCLResourceCounterSet getCCLRCS() {
        return this.m_rcs;
    }

    @Override
    public void setLogData(String lgdata) {
        if (null == lgdata) {
            lgdata = "";
        }
        this.m_logData = lgdata;
    }

    @Override
    public String getLogData() {
        return this.m_logData;
    }

    @Override
    public void setClassId(String clsId) {
        if (null == clsId) {
            clsId = "";
        }
        this.m_classId = clsId;
    }

    @Override
    public String getClassId() {
        return this.m_classId;
    }

    @Override
    public void setMethodId(String mthdId) {
        if (null == mthdId) {
            mthdId = "";
        }
        this.m_methodId = mthdId;
    }

    @Override
    public String getMethodId() {
        return this.m_methodId;
    }

    @Override
    public void setSequenceId(String stpId) {
        if (null == stpId) {
            stpId = "";
        }
        this.m_sequenceId = stpId;
    }

    @Override
    public String getSequenceId() {
        return this.m_sequenceId;
    }

    @Override
    public String getExecutionId() {
        return this.m_executionId;
    }

    @Override
    public void setStatus(String sts) {
        if (null == sts) {
            sts = "";
        }
        this.m_status = sts;
    }

    @Override
    public String getStatus() {
        return this.m_status;
    }

    public LogPerfIndication(String component, int buildnum, CCLResourceCounterSet rcs) {
        super(component, buildnum);
        this.m_group = (byte)2;
        this.m_rcs = rcs;
        this.m_level = 50000;
        this.m_logData = "";
        this.m_classId = "";
        this.m_methodId = "";
        this.m_sequenceId = "";
        this.m_executionId = System.currentTimeMillis() + "_" + Integer.toHexString(this.hashCode());
        this.m_status = LogPerfIndication_START;
    }

    public LogPerfIndication(String component, int buildnum, LogResourceCounterSet rcs) {
        super(component, buildnum);
        this.m_group = (byte)2;
        this.m_rcs = rcs;
        this.m_level = 50000;
        this.m_logData = "";
        this.m_classId = "";
        this.m_methodId = "";
        this.m_sequenceId = "";
        this.m_executionId = System.currentTimeMillis() + "_" + Integer.toHexString(this.hashCode());
        this.m_status = LogPerfIndication_START;
    }

    public LogPerfIndication() {
        this("", 0, new CCLResourceCounterSet());
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        try {
            out.writeUTF(this.m_classId);
            out.writeUTF(this.m_methodId);
            out.writeUTF(this.m_sequenceId);
            out.writeUTF(this.m_executionId);
            out.writeUTF(this.m_status);
            int logDataUTF8ByteSize = this.getUTF8ByteSize(this.m_logData);
            if (65535 >= logDataUTF8ByteSize) {
                out.writeInt(1);
                out.writeUTF(this.m_logData);
            } else {
                int logDataChunks = this.m_logData.length() / 40000 + 1;
                out.writeInt(logDataChunks);
                int ii = 0;
                for (ii = 0; ii < logDataChunks - 1; ++ii) {
                    out.writeUTF(this.m_logData.substring(ii * 40000, (ii + 1) * 40000));
                }
                out.writeUTF(this.m_logData.substring(ii * 40000));
            }
            this.m_rcs.writeExternal(out);
            super.writeExternal(out);
        }
        catch (Exception e) {
            LogIPFLog.warn("Indication could not be sent to the log server.", e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) {
        try {
            this.m_classId = in.readUTF();
            this.m_methodId = in.readUTF();
            this.m_sequenceId = in.readUTF();
            this.m_executionId = in.readUTF();
            this.m_status = in.readUTF();
            int logDataChunks = in.readInt();
            if (1 == logDataChunks) {
                this.m_logData = in.readUTF();
            } else {
                StringBuilder tmpLogData = new StringBuilder(65535);
                for (int ii = 0; ii < logDataChunks; ++ii) {
                    tmpLogData.append(in.readUTF());
                }
                this.m_logData = tmpLogData.toString();
            }
            this.m_rcs.readExternal(in);
            super.readExternal(in);
        }
        catch (Exception e) {
            LogIPFLog.warn("Received a corrupted indication.", e);
        }
    }

    public String toString() {
        StringBuilder msg = new StringBuilder(512);
        LogPerfRenderer.render(msg, this);
        return msg.toString();
    }
}

