/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.indications.ILogIndication;
import com.cognos.indications.ILogTraceIndication;
import com.cognos.indications.internal.AuditLoggerNameResolver;
import com.cognos.indications.internal.LevelConverter;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.logging.log4j.LogManager;

public class LogTypedLoggerLegacy
extends Logger {
    protected final Class<?> baseMessageType;
    private final org.apache.logging.log4j.Logger log4jLogger;
    private final String loggerName;

    protected LogTypedLoggerLegacy(String name, org.apache.logging.log4j.Logger logger, Class<?> base) {
        super(name);
        this.loggerName = name;
        this.log4jLogger = logger;
        this.baseMessageType = base;
    }

    protected static Class<?> getFirstDeclaredInterface(Class<?> indClass) {
        Class<?> firstInterface = null;
        Class<?>[] allInterfaces = indClass.getInterfaces();
        if (null != allInterfaces && 0 != allInterfaces.length) {
            firstInterface = allInterfaces[0];
        }
        return firstInterface;
    }

    protected static boolean isValidILogIndicationInterface(Class<?> iLogInterface, Class<?> testInterface) {
        boolean isInterface = null != testInterface;
        boolean isNotObjectClass = Object.class != testInterface;
        boolean isNotILogInterface = iLogInterface != testInterface;
        return isInterface && isNotObjectClass && isNotILogInterface;
    }

    protected static Class<?> getILogInterface(Class<?> iLogInd) {
        Class<?> indClass = iLogInd;
        Class<?> indInterface = LogTypedLoggerLegacy.getFirstDeclaredInterface(indClass);
        while (LogTypedLoggerLegacy.isValidILogIndicationInterface(ILogIndication.class, indInterface)) {
            indClass = indClass.getSuperclass();
            indInterface = LogTypedLoggerLegacy.getFirstDeclaredInterface(indClass);
        }
        return indInterface;
    }

    public static LogTypedLoggerLegacy getInstance(String name, Class<?> base) {
        return LogTypedLoggerLegacy.getInstance(name, base, LogTypedLoggerLegacy::new);
    }

    protected static LogTypedLoggerLegacy getInstance(String name, Class<?> base, LoggerCtor ctor) {
        Class<?> baseInterface = LogTypedLoggerLegacy.getILogInterface(base);
        if (null == baseInterface) {
            return null;
        }
        AuditLoggerNameResolver.ServiceLoggerName sln = AuditLoggerNameResolver.resolveName(name);
        org.apache.logging.log4j.Logger logger = LogManager.getLogger((String)sln.getLoggerName());
        return ctor.make(sln.getLoggerName(), logger, baseInterface);
    }

    public static LogTypedLoggerLegacy getInstance(String name) {
        AuditLoggerNameResolver.ServiceLoggerName sln = AuditLoggerNameResolver.resolveName(name);
        org.apache.logging.log4j.Logger logger = LogManager.getLogger((String)sln.getLoggerName());
        return new LogTypedLoggerLegacy(sln.getLoggerName(), logger, null);
    }

    public boolean isEnabled(Object obj) {
        if (this.baseMessageType.isInstance(obj)) {
            ILogIndication ind = (ILogIndication)obj;
            return this.log4jLogger.isEnabled(LevelConverter.toLog4j2Level(ind.getLevel()));
        }
        return false;
    }

    public boolean isEnabled(int detail) {
        return this.log4jLogger.isEnabled(LevelConverter.toLog4j2Level(detail));
    }

    public boolean isDebugEnabled() {
        return this.log4jLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log4jLogger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log4jLogger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log4jLogger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log4jLogger.isErrorEnabled();
    }

    public Level getEffectiveLevel() {
        throw new UnsupportedOperationException();
    }

    public boolean isEnabledFor(Priority p) {
        return this.log4jLogger.isEnabled(LevelConverter.toLog4j2Level(p));
    }

    public void fatal(Object message) {
        this.log4jLogger.fatal(message);
    }

    public void log(String FQCN, Priority p, Object msg, Throwable t) {
    }

    public void log(Priority p, Object msg, Throwable t) {
        this.log4jLogger.log(LevelConverter.toLog4j2Level(p), msg, t);
    }

    public void log(Priority p, Object msg) {
        this.log4jLogger.log(LevelConverter.toLog4j2Level(p), msg);
    }

    public void setAdditivity(boolean additive) {
    }

    public void addAppender(Appender newAppender) {
    }

    public void setLevel(Level level) {
    }

    public boolean getAdditivity() {
        return false;
    }

    public void assertLog(boolean assertion, String msg) {
        this.log4jLogger.fatal(msg);
    }

    public void log(Object p0) {
        if (this.baseMessageType.isInstance(p0)) {
            ILogIndication ind = (ILogIndication)p0;
            if (ind.isTimeStampedControlledByIPF()) {
                ind.setTime();
            } else {
                ind.setTimeStampedControlledByIPF(true);
            }
            ind.setLoggerName(this.loggerName);
            this.log4jLogger.log(LevelConverter.toLog4j2Level(ind.getLevel()), (Object)ind);
        }
    }

    public void log(Level level, Object msg) {
        this.log4jLogger.log(LevelConverter.toLog4j2Level((Priority)level), msg);
    }

    public void log(Level level, Object msg, Throwable t) {
        this.log4jLogger.log(LevelConverter.toLog4j2Level((Priority)level), msg, t);
    }

    public void logTrace(ILogTraceIndication ind, Throwable throwable) {
        if (this.baseMessageType.isInstance(ind)) {
            if (ind.isTimeStampedControlledByIPF()) {
                ind.setTime();
            } else {
                ind.setTimeStampedControlledByIPF(true);
            }
            ind.setLoggerName(this.loggerName);
            this.log4jLogger.log(LevelConverter.toLog4j2Level(ind.getLevel()), (Object)ind, throwable);
        }
    }

    public void trace(Object o, Throwable t) {
        this.log4jLogger.trace(o, t);
    }

    public void trace(Object o) {
        this.log4jLogger.trace(o);
    }

    public void debug(Object o) {
        this.log4jLogger.debug(o);
    }

    public void debug(Object o, Throwable t) {
        this.log4jLogger.debug(o, t);
    }

    public void info(Object o) {
        this.log4jLogger.info(o);
    }

    public void info(Object o, Throwable t) {
        this.log4jLogger.info(o, t);
    }

    public void warn(Object o) {
        this.log4jLogger.warn(o);
    }

    public void warn(Object o, Throwable t) {
        this.log4jLogger.warn(o, t);
    }

    public void error(Object o) {
        this.log4jLogger.error(o);
    }

    public void error(Object o, Throwable t) {
        this.log4jLogger.error(o, t);
    }

    public void fatal(Object msg, Throwable t) {
        this.log4jLogger.fatal(msg, t);
    }

    @FunctionalInterface
    protected static interface LoggerCtor {
        public LogTypedLoggerLegacy make(String var1, org.apache.logging.log4j.Logger var2, Class<?> var3);
    }
}

