/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications.convert;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogValueTraceIndication;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConvertUtils {
    public static Level getLevel(Logger logger) {
        if (logger.isDebugEnabled()) {
            return Level.DEBUG;
        }
        if (logger.isInfoEnabled()) {
            return Level.INFO;
        }
        if (logger.isWarnEnabled()) {
            return Level.WARN;
        }
        if (logger.isErrorEnabled()) {
            return Level.ERROR;
        }
        return Level.OFF;
    }

    public static boolean isEnabled(int detail, Logger logger) {
        switch (detail) {
            case 10000: {
                return logger.isDebugEnabled();
            }
            case 20000: {
                return logger.isInfoEnabled();
            }
            case 30000: {
                return logger.isWarnEnabled();
            }
            case -2147483648: 
            case 40000: 
            case 50000: {
                return logger.isErrorEnabled();
            }
        }
        return false;
    }

    public static void log(int detail, Object msg, Logger logger) {
        switch (detail) {
            case 5000: 
            case 10000: {
                logger.debug(LogConvertUtils.extractMessage(msg));
                break;
            }
            case 20000: {
                logger.info(LogConvertUtils.extractMessage(msg));
                break;
            }
            case 30000: {
                logger.warn(LogConvertUtils.extractMessage(msg));
                break;
            }
            case 40000: {
                logger.error(LogConvertUtils.extractMessage(msg));
                break;
            }
            case 50000: {
                LoggerFactory.getLogger((String)("startup." + logger.getName())).info(LogConvertUtils.extractMessage(msg));
            }
        }
    }

    public static void log(int detail, Object msg, Throwable tt, Logger logger) {
        switch (detail) {
            case 5000: 
            case 10000: {
                logger.debug(LogConvertUtils.extractMessage(msg), tt);
                break;
            }
            case 20000: {
                logger.info(LogConvertUtils.extractMessage(msg), tt);
                break;
            }
            case 30000: {
                logger.warn(LogConvertUtils.extractMessage(msg), tt);
                break;
            }
            case 40000: {
                logger.error(LogConvertUtils.extractMessage(msg), tt);
                break;
            }
            case 50000: {
                LoggerFactory.getLogger((String)("startup." + logger.getName())).info(LogConvertUtils.extractMessage(msg), tt);
            }
        }
    }

    public static String makeRequestName(String delim, Object message) {
        if (message == null || delim == null) {
            return "";
        }
        LogIndication ind = (LogIndication)message;
        return ind.getRequestID() + delim + ind.getSubRequestID() + delim + ind.getStepID();
    }

    public static String extractMessage(Object message) {
        String result = null;
        if (message == null) {
            return "";
        }
        if (message.getClass() == LogAuditIndication.class) {
            LogAuditIndication ind = (LogAuditIndication)message;
            result = ind.getOperation() + '\t' + ind.getLogData();
        } else if (message.getClass() == LogAuditAccessIndication.class) {
            LogAuditAccessIndication ind = (LogAuditAccessIndication)message;
            result = ind.getOperation() + '\t' + ind.getLogData() + '\t' + ind.getStatus() + '\t' + ind.getObjectType() + '\t' + ind.getObjectPath() + '\t' + ind.getErrorMessage();
        } else if (message.getClass() == LogPerfIndication.class) {
            LogPerfIndication ind = (LogPerfIndication)message;
            result = ind.toString();
        } else if (message.getClass() == LogTraceIndication.class) {
            LogTraceIndication ind = (LogTraceIndication)message;
            result = ind.toString();
        } else if (message.getClass() == LogValueTraceIndication.class) {
            LogValueTraceIndication ind = (LogValueTraceIndication)message;
            result = ind.toString();
        } else {
            result = "";
        }
        return result;
    }
}

