/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.nt;

import com.cognos.indications.LogIPFLog;

public class NTEventLogAppender {
    private int _handle = 0;
    private String source = null;
    private String server = null;

    public NTEventLogAppender() {
    }

    public NTEventLogAppender(String server, String source) {
        if (source == null) {
            source = "IBM Cognos";
        }
        try {
            this._handle = this.registerEventSource(server, source);
        }
        catch (Exception e) {
            e.printStackTrace();
            this._handle = 0;
        }
    }

    public void close() {
    }

    public void activateOptions() {
        if (this.source != null) {
            try {
                this._handle = this.registerEventSource(this.server, this.source);
            }
            catch (Exception e) {
                LogIPFLog.error("Could not register event source.", e);
                this._handle = 0;
            }
        }
    }

    public void append(String message, int catepory) {
        this.reportEvent(this._handle, message, catepory);
    }

    public void finalize() {
        this.deregisterEventSource(this._handle);
        this._handle = 0;
    }

    public void setSource(String source) {
        this.source = source.trim();
    }

    public String getSource() {
        return this.source;
    }

    public boolean requiresLayout() {
        return true;
    }

    private native int registerEventSource(String var1, String var2);

    private native void reportEvent(int var1, String var2, int var3);

    private native void deregisterEventSource(int var1);

    static {
        String[] archs;
        try {
            archs = new String[]{System.getProperty("os.arch")};
        }
        catch (SecurityException e) {
            archs = new String[]{"amd64", "ia64", "x86"};
        }
        boolean loaded = false;
        for (int i = 0; i < archs.length; ++i) {
            try {
                System.loadLibrary("NTEventLogAppender." + archs[i]);
                loaded = true;
                break;
            }
            catch (UnsatisfiedLinkError e) {
                loaded = false;
                continue;
            }
        }
        if (!loaded) {
            System.loadLibrary("NTEventLogAppender");
        }
    }
}

