/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.exceptions;

import com.ibm.bi.admin.core.MessageKeys;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.messages.CommonsException;
import com.ibm.bi.platform.commons.messages.CommonsRuntimeException;
import com.ibm.bi.platform.commons.messages.HttpException;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.platform.commons.messages.MessageUtil;
import com.ibm.bi.soap.services.SoapException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class AdminExceptionMapper
implements ExceptionMapper<Exception> {
    @Context
    private HttpServletRequest request;
    private static boolean writeStackTrace = false;
    private static Logger LOGGER = LoggerFactory.getLogger(AdminExceptionMapper.class);
    private static final String PROP_ERRORS = "errors";
    private static ExceptionFormatter[] formatters = new ExceptionFormatter[]{new HttpExceptionFormatter(), new CommonsExceptionFormatter(), new CommonsRuntimeExceptionFormatter(), new SoapExceptionFormatter(), new ThrowableFormatter()};

    public Response toResponse(Exception exception) {
        ExceptionFormatter formatter = null;
        if (exception instanceof WebApplicationException) {
            Throwable cause = exception.getCause();
            formatter = this.getExceptionFormatter(cause);
            if (formatter instanceof ThrowableFormatter) {
                return ((WebApplicationException)exception).getResponse();
            }
            exception = (Exception)cause;
        } else {
            formatter = this.getExceptionFormatter(exception);
        }
        if (formatter instanceof ThrowableFormatter) {
            exception = new HttpException(500, (Throwable)exception, new Message(MessageKeys.INTERNAL_ERROR));
        }
        JsonObject entity = new JsonObject();
        JsonArray errors = new JsonArray();
        entity.put(PROP_ERRORS, (Object)errors);
        int status = formatter.getStatusCode(exception);
        Locale locale = this.request.getLocale();
        for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
            this.format(errors, throwable, locale);
        }
        if (writeStackTrace || LOGGER.isDebugEnabled()) {
            this.addStackTrace(exception, errors);
        }
        if (LOGGER.isErrorEnabled()) {
            this.logError(status, entity);
        }
        return Response.status((int)status).entity((Object)entity).type("application/json").build();
    }

    private void addStackTrace(Throwable e, JsonArray errors) {
        try {
            JsonObject error = errors.getObject(0);
            if (!error.containsKey((Object)"details")) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                error.put("details", (Object)stringWriter.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logError(int status, JsonObject entity) {
        StringBuilder buf = new StringBuilder();
        buf.append("Request URL: ").append(this.request.getRequestURI());
        String queryString = this.request.getQueryString();
        if (queryString != null) {
            buf.append(queryString);
        }
        buf.append("\nResponse status: ").append(status);
        buf.append("\nDetails: ").append(entity.toString());
        LOGGER.error(buf.toString());
    }

    private void format(JsonArray errors, Throwable e, Locale locale) {
        this.getExceptionFormatter(e).formatException(errors, e, locale);
    }

    private ExceptionFormatter getExceptionFormatter(Throwable e) {
        for (ExceptionFormatter formatter : formatters) {
            if (!formatter.canHandleException(e)) continue;
            return formatter;
        }
        return null;
    }

    static class ThrowableFormatter
    extends ExceptionFormatter {
        ThrowableFormatter() {
            super(Throwable.class);
        }

        @Override
        public void formatException(JsonArray errors, Throwable e, Locale locale) {
            String msg = this.getExceptionMessage(e);
            if (msg == null && e.getCause() == null) {
                msg = e.getClass().getCanonicalName();
            }
            if (msg != null) {
                errors.add((Object)this.createErrorObject(null, msg));
            }
        }
    }

    static class SoapExceptionFormatter
    extends ExceptionFormatter {
        SoapExceptionFormatter() {
            super(SoapException.class);
        }

        @Override
        public void formatException(JsonArray errors, Throwable e, Locale locale) {
            SoapException se = (SoapException)e;
            Object details = se.getErrorDetails();
            if (details instanceof JsonObject) {
                String message = "";
                try {
                    JsonObject obj = (JsonObject)details;
                    message = obj.getArray("messages").getString(0);
                }
                catch (Exception obj) {
                    // empty catch block
                }
                JsonObject error = this.createErrorObject(se.getErrorCode(), message);
                error.putAll((Map)((JsonObject)details));
                details = error;
            }
            errors.add(details);
        }

        @Override
        public int getStatusCode(Throwable e) {
            return ((SoapException)e).getStatusCode();
        }
    }

    static class HttpExceptionFormatter
    extends CommonsRuntimeExceptionFormatter {
        HttpExceptionFormatter() {
            super((Class<? extends CommonsRuntimeException>)HttpException.class);
        }

        @Override
        public int getStatusCode(Throwable e) {
            return ((HttpException)e).getStatusCode();
        }
    }

    static class CommonsRuntimeExceptionFormatter
    extends ExceptionFormatter {
        CommonsRuntimeExceptionFormatter() {
            super(CommonsRuntimeException.class);
        }

        CommonsRuntimeExceptionFormatter(Class<? extends CommonsRuntimeException> exceptionClass) {
            super(exceptionClass);
        }

        @Override
        public void formatException(JsonArray errors, Throwable e, Locale locale) {
            CommonsRuntimeException ce = (CommonsRuntimeException)e;
            String[] parts = this.splitErrorCodeAndMessage(ce.getErrorCode(), ce.getLocalizedMessage(locale));
            errors.add((Object)this.createErrorObject(parts[0], parts[1]));
        }
    }

    static class CommonsExceptionFormatter
    extends ExceptionFormatter {
        CommonsExceptionFormatter() {
            super(CommonsException.class);
        }

        @Override
        public void formatException(JsonArray errors, Throwable e, Locale locale) {
            CommonsException ce = (CommonsException)e;
            String[] parts = this.splitErrorCodeAndMessage(ce.getErrorCode(), ce.getLocalizedMessage(locale));
            errors.add((Object)this.createErrorObject(parts[0], parts[1]));
        }
    }

    static abstract class ExceptionFormatter {
        static final String PROP_CODE = "code";
        static final String PROP_MESSAGE = "message";
        static final String PROP_DESCRIPTION = "description";
        static final String PROP_LEVEL = "level";
        static final String PROP_MORE_INFO = "more_info";
        static final String PROP_DETAILS = "details";
        private static final String LEVEL_ERROR = "error";
        private Class<? extends Throwable> exceptionClass;

        protected ExceptionFormatter(Class<? extends Throwable> exceptionClass) {
            this.exceptionClass = exceptionClass;
        }

        public boolean canHandleException(Throwable e) {
            return this.exceptionClass.isAssignableFrom(e.getClass());
        }

        public int getStatusCode(Throwable e) {
            return 500;
        }

        public JsonObject createErrorObject(String code, String message) {
            JsonObject result = new JsonObject();
            result.put(PROP_LEVEL, (Object)LEVEL_ERROR);
            if (code != null) {
                result.put(PROP_CODE, (Object)code);
            }
            result.put(PROP_MESSAGE, (Object)message);
            return result;
        }

        protected String getExceptionMessage(Throwable e) {
            String msg = e.getMessage();
            if (e.getCause() != null && e.getCause().toString().equals(msg)) {
                return null;
            }
            return msg;
        }

        protected String[] splitErrorCodeAndMessage(String errorCode, String message) {
            if (errorCode != null) {
                String[] result = new String[]{errorCode, message};
                if (message.startsWith(errorCode)) {
                    result[1] = message.substring(errorCode.length()).trim();
                }
                return result;
            }
            return MessageUtil.splitErrorCodeAndMessage((String)message);
        }

        public abstract void formatException(JsonArray var1, Throwable var2, Locale var3);
    }
}

