/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.resources;

import com.ibm.bi.admin.commons.utilities.EndpointProperty;
import com.ibm.bi.admin.core.MessageKeys;
import com.ibm.bi.admin.core.exceptions.AdminException;
import com.ibm.bi.admin.core.utils.CmRest;
import com.ibm.bi.admin.core.utils.FieldsQueryParam;
import com.ibm.bi.admin.core.utils.PathBuilder;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.messages.HttpException;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.soap.services.BiBus;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentManager {
    public static final String CACHE_VALIDATOR = "cacheValidator";
    public static final String PUBLIC_OBJECTS = "public objects";
    public static final String RESOURCE_FOLDER = "resourceFolder";
    public static final String DEFAULTNAME = "defaultName";
    private static final Logger logger = LoggerFactory.getLogger(ContentManager.class);
    protected HttpServletRequest servletRequest;
    protected BiBus biBus;

    public ContentManager(HttpServletRequest request, BiBus bus) {
        this.servletRequest = request;
        this.biBus = bus;
    }

    protected ContentManager() throws Exception {
    }

    public JsonObject query(String path, JsonArray props, JsonObject options, boolean cache, EndpointProperty endPoint) throws Exception {
        if (cache) {
            JsonObject result = this.queryCached(path, props, options);
            endPoint.setCMAction("CACHED QUERY");
            this.CMResponseDebugLogger(result, endPoint);
            return result;
        }
        JsonObject result = this.queryNoCache(path, props, options);
        endPoint.setCMAction("UNCACHED QUERY");
        this.CMResponseDebugLogger(result, endPoint);
        return result;
    }

    private void CMResponseDebugLogger(JsonObject data, EndpointProperty endPoint) {
        try {
            if (EndpointProperty.isValidEndpoint((EndpointProperty)endPoint)) {
                String ResourceName = endPoint.getMethodType() + "_" + endPoint.getPath() + " -- " + endPoint.getCMAction();
                logger.debug("\n\n***ADMIN-SERVICE-LOGGING:: CM RESPONSE FOR: " + ResourceName + "--> \n " + data.toString() + " \n ***END OF LOG\n\n");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public JsonObject query(String path, FieldsQueryParam fields, boolean schemaInfo, boolean cache, EndpointProperty endPoint) throws Exception {
        return this.query(path, fields.getProperties(), this.buildQueryOptions(fields, schemaInfo), cache, endPoint);
    }

    public JsonObject queryCMObjects(String path, JsonArray props, Map options, List sortBy) throws Exception {
        JsonArray data = (JsonArray)this.biBus.contentManager.query(path, (List)props, sortBy, options);
        JsonObject result = new JsonObject();
        result.put("objects", (Object)data);
        result.put(CACHE_VALIDATOR, null);
        return result;
    }

    public JsonObject add(String parentPath, String type, JsonObject data, String updateAction, EndpointProperty endPoint) throws Exception {
        this.verifyType(data, type);
        JsonArray anArray = new JsonArray();
        anArray.add((Object)data);
        JsonArray objects = (JsonArray)this.biBus.contentManager.add(parentPath, (List)anArray, (Map)this.buildAddOptions(updateAction));
        JsonObject logData = new JsonObject();
        logData.put("objects", (Object)objects);
        endPoint.setCMAction("ADD");
        this.CMResponseDebugLogger(logData, endPoint);
        return objects.getObject(0);
    }

    public JsonArray add(String parentPath, JsonArray objects, String updateAction, EndpointProperty endPoint) throws Exception {
        JsonObject logData = new JsonObject();
        logData.put("objects", (Object)objects);
        endPoint.setCMAction("BULK ADD");
        this.CMResponseDebugLogger(logData, endPoint);
        return (JsonArray)this.biBus.contentManager.add(parentPath, (List)objects, (Map)this.buildAddOptions(updateAction));
    }

    public JsonArray copy(String searchPath, String targetPath, Map options, EndpointProperty endPoint) throws Exception {
        JsonArray searchPaths = new JsonArray();
        searchPaths.add((Object)searchPath);
        JsonObject logData = new JsonObject();
        logData.put("searchPaths", (Object)searchPaths);
        endPoint.setCMAction("COPY");
        this.CMResponseDebugLogger(logData, endPoint);
        return (JsonArray)this.biBus.contentManager.copy((List)searchPaths, targetPath, options);
    }

    public JsonArray copyRename(String searchPath, String targetPath, String newName, Map options, EndpointProperty endPoint) throws Exception {
        JsonArray searchPaths = new JsonArray(new Object[]{searchPath});
        JsonArray newNames = new JsonArray(new Object[]{newName});
        JsonObject logData = new JsonObject();
        logData.put("searchPaths", (Object)searchPaths);
        logData.put("newNames", (Object)newNames);
        endPoint.setCMAction("COPY RENAME");
        this.CMResponseDebugLogger(logData, endPoint);
        return (JsonArray)this.biBus.contentManager.copyRename((List)searchPaths, targetPath, (List)newNames, options);
    }

    public void copyAccountProfile(String sourceAccountPath, String targetAccountPath, Map options, EndpointProperty endPoint) throws Exception {
        JsonObject logData = new JsonObject();
        logData.put("sourceAccountPath", (Object)sourceAccountPath);
        logData.put("targetAccountPath", (Object)targetAccountPath);
        endPoint.setCMAction("COPY ACCOUNT PROFILE");
        this.CMResponseDebugLogger(logData, endPoint);
        this.biBus.contentManager.copyAccount(sourceAccountPath, targetAccountPath, options);
    }

    public JsonObject update(String id, String type, JsonObject data, EndpointProperty endPoint) throws Exception {
        this.verifyType(data, type);
        data.put("searchPath", (Object)PathBuilder.fromId(id));
        JsonArray anArray = new JsonArray();
        anArray.add((Object)data);
        JsonObject logData = new JsonObject();
        logData.put("objectToUpdate", (Object)anArray);
        endPoint.setCMAction("UPDATE");
        this.CMResponseDebugLogger(logData, endPoint);
        return ((JsonArray)this.biBus.contentManager.update((List)anArray, null)).getObject(0);
    }

    public JsonArray update(JsonArray objects, EndpointProperty endPoint) throws Exception {
        JsonObject logData = new JsonObject();
        logData.put("objectsToUpdate", (Object)objects);
        endPoint.setCMAction("BULK UPDATE");
        this.CMResponseDebugLogger(logData, endPoint);
        return (JsonArray)this.biBus.contentManager.update((List)objects, null);
    }

    public Long delete(String path, boolean recursive, boolean force, EndpointProperty endPoint) throws Exception {
        JsonObject options = new JsonObject();
        options.put("force", (Object)force);
        options.put("recursive", (Object)recursive);
        JsonArray objects = new JsonArray(new Object[]{path});
        JsonObject logData = new JsonObject();
        logData.put("objectsToDelete", (Object)objects);
        endPoint.setCMAction("DELETE");
        this.CMResponseDebugLogger(logData, endPoint);
        return (Long)this.biBus.contentManager.delete((List)objects, (Map)options);
    }

    public Long delete(String id, JsonObject options, EndpointProperty endPoint) throws Exception {
        JsonArray objects = new JsonArray(new Object[]{PathBuilder.fromId(id)});
        JsonObject logData = new JsonObject();
        logData.put("objectToDelete", (Object)objects);
        endPoint.setCMAction("DELETE WITH ID");
        this.CMResponseDebugLogger(logData, endPoint);
        return (Long)this.biBus.contentManager.delete((List)objects, (Map)options);
    }

    public Long delete(List<String> paths, boolean recursive, boolean force, EndpointProperty endPoint) throws Exception {
        JsonObject options = new JsonObject();
        options.put("force", (Object)force);
        options.put("recursive", (Object)recursive);
        JsonObject logData = new JsonObject();
        logData.put("searchPathsToDelete", paths);
        logData.put("options", (Object)options);
        endPoint.setCMAction("BULK DELETE");
        this.CMResponseDebugLogger(logData, endPoint);
        return (Long)this.biBus.contentManager.delete(paths, (Map)options);
    }

    public void deleteTenants(List<String> tenantIDs, EndpointProperty endPoint) throws Exception {
        JsonObject logData = new JsonObject();
        logData.put("tenantIDs", tenantIDs);
        endPoint.setCMAction("DELETE TENANTS");
        this.CMResponseDebugLogger(logData, endPoint);
        this.biBus.contentManager.deleteTenants(tenantIDs);
    }

    public void deleteAccountProfile(String objSearchPath, EndpointProperty endPoint) throws Exception {
        JsonObject logData = new JsonObject();
        logData.put("userSearchPath", (Object)objSearchPath);
        endPoint.setCMAction("DELETE USER'S PROFILE");
        this.CMResponseDebugLogger(logData, endPoint);
        this.biBus.contentManager.deleteAccount(objSearchPath);
    }

    public boolean validateResourceFolder(EndpointProperty endPoint, String tenantID, String feature, String resourceFolderSuffix) throws Exception {
        boolean operationResult = false;
        String folder = tenantID.isEmpty() ? PUBLIC_OBJECTS : tenantID;
        try {
            JsonArray data = this.checkIfResourceFolderExists(endPoint, tenantID, feature, resourceFolderSuffix);
            if (data.size() > 0) {
                logger.info("Resource folder type {} exists for {}", (Object)resourceFolderSuffix, (Object)folder);
            } else {
                logger.info("Resource folder type {} does not exist for {}, creating one", (Object)resourceFolderSuffix, (Object)folder);
                this.createResourceFolder(endPoint, tenantID, feature, resourceFolderSuffix);
                operationResult = true;
            }
        }
        catch (Exception e) {
            logger.error("cm operation failed with error: ", (Throwable)e);
            throw new AdminException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return operationResult;
    }

    private JsonArray checkIfResourceFolderExists(EndpointProperty endPoint, String tenantID, String feature, String resourceFolderSuffix) throws Exception {
        String subResourceFolder = tenantID + StringUtils.capitalize((String)resourceFolderSuffix);
        String folderToSearch = !tenantID.isEmpty() ? subResourceFolder : resourceFolderSuffix;
        JsonArray cmOptions = new JsonArray();
        cmOptions.add((Object)DEFAULTNAME);
        String pathForSearch = this.getFeatureResourceFolder(folderToSearch, feature + StringUtils.capitalize((String)resourceFolderSuffix));
        JsonObject existingItems = this.query(pathForSearch, cmOptions, null, false, endPoint);
        return (JsonArray)existingItems.get("objects");
    }

    private void createResourceFolder(EndpointProperty endpoint, String tenantID, String feature, String resourceFolderSuffix) throws Exception {
        String resourceFolder = feature + StringUtils.capitalize((String)resourceFolderSuffix);
        String parentPath = "/resourceFolder/resourceFolder[@name='" + resourceFolder + "']";
        JsonObject data = new JsonObject();
        data.put("hidden", (Object)"false");
        data.put("disabled", (Object)"false");
        data.put("type", (Object)RESOURCE_FOLDER);
        if (tenantID.isEmpty()) {
            data.put(DEFAULTNAME, (Object)resourceFolderSuffix);
        } else {
            data.put(DEFAULTNAME, (Object)(tenantID + StringUtils.capitalize((String)resourceFolderSuffix)));
            data.put("tenantID", (Object)tenantID);
        }
        this.add(parentPath, RESOURCE_FOLDER, data, "fail", endpoint);
    }

    public String getFeatureResourceFolder(String targetFolder, String parentResourceFolder) {
        PathBuilder pb = new PathBuilder("/resourceFolder/resourceFolder[@name='" + parentResourceFolder + "']");
        pb.children(RESOURCE_FOLDER).equalsTo("@name", targetFolder);
        return pb.toString();
    }

    protected JsonObject buildQueryOptions(FieldsQueryParam fields, boolean schemaInfo) {
        if (fields.getRefProps() == null && !schemaInfo) {
            return null;
        }
        JsonObject result = new JsonObject();
        if (fields.getRefProps() != null) {
            result.put("refProps", (Object)fields.getRefProps());
        }
        if (schemaInfo) {
            result.put("schemaInfo", (Object)schemaInfo);
        }
        return result;
    }

    protected JsonObject buildAddOptions(String updateAction) {
        JsonObject options = null;
        if (updateAction != null) {
            options = new JsonObject();
            options.put("updateAction", (Object)updateAction);
        }
        return options;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void verifyType(JsonObject data, String type) {
        String dataType = data.getString("type");
        if (dataType == null) {
            if (type == null) throw new HttpException(400, new Message(MessageKeys.MISSING_FIELD, (Object)"type"));
            data.put("type", (Object)type);
            return;
        } else {
            if (type == null || type.equals(dataType)) return;
            throw new HttpException(400, new Message(MessageKeys.INVALID_FIELD_VALUE, (Object)"type"));
        }
    }

    protected JsonObject queryNoCache(String path, JsonArray props, JsonObject options) throws Exception {
        JsonArray sortBy = this.extractSortBy(options);
        JsonArray data = (JsonArray)this.biBus.contentManager.query(path, (List)props, (List)sortBy, (Map)options);
        JsonObject result = new JsonObject();
        result.put("objects", (Object)data);
        result.put(CACHE_VALIDATOR, null);
        return result;
    }

    protected JsonObject queryCached(String path, JsonArray props, JsonObject options) throws Exception {
        JsonObject result;
        JsonArray items = new JsonArray();
        String etag = this.getRequestEtag();
        String cacheValidator = this.revalidateEtag(path, etag);
        if (cacheValidator != null) {
            result = new JsonObject();
            result.put(CACHE_VALIDATOR, (Object)cacheValidator);
        } else {
            if (etag.startsWith("42-")) {
                etag = null;
            }
            JsonArray sortBy = this.extractSortBy(options);
            Map queryRequest = this.biBus.contentManager.queryRequest(path, (List)props, (List)sortBy, (Map)options);
            JsonArray queries = new JsonArray();
            queries.add((Object)queryRequest);
            result = (JsonObject)this.biBus.contentManager.queryMultipleCache((List)queries, etag == null ? "" : etag);
            JsonArray replies = (JsonArray)result.remove((Object)"replies");
            if (replies != null) {
                for (Object reply : replies) {
                    items.addAll((Collection)((JsonObject)reply).getArray("queryResult"));
                }
            }
        }
        result.put("objects", (Object)items);
        return result;
    }

    private JsonArray extractSortBy(JsonObject options) {
        if (options != null) {
            return (JsonArray)options.remove((Object)"sortBy");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int validateETag(String path, String etag) {
        try (CmRest cmRest = new CmRest(this.servletRequest);){
            int n = cmRest.validateEtag(path, etag);
            return n;
        }
        catch (AdminException ce) {
            logger.warn("Error calling CM REST API, will not use fast Etag validation", (Throwable)ce);
            return 205;
        }
    }

    protected String revalidateEtag(String path, String etag) {
        if (!etag.startsWith("42-")) {
            return null;
        }
        int status = this.validateETag(path, etag);
        String cacheValidator = null;
        if (status == 410) {
            cacheValidator = "GONE";
        } else if (status == 304) {
            cacheValidator = etag;
        } else if (status != 205) {
            logger.warn("validateETag returned unexpected result: " + status);
        }
        return cacheValidator;
    }

    protected String getRequestEtag() {
        String s = this.servletRequest.getHeader("If-None-Match");
        if (s == null) {
            return "";
        }
        if (s.charAt(0) == '\"' && s.length() > 2) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }
}

