/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.utils;

import com.ibm.bi.admin.commons.utilities.EndpointProperty;
import com.ibm.bi.admin.core.resources.ContentManager;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;

public class Identity {
    private static final String SYSADMIN_ID = "xOjpTeXN0ZW0gQWRtaW5pc3RyYXRvcnM_";
    private static final String TENANTADMIN_ID = "xOjpUZW5hbnQgQWRtaW5pc3RyYXRvcnM_";
    private static final String CAN_USE_USERS_GROUPS_AND_ROLES_CAPABILITY = "canUseUsersGroupsAndRolesTool";
    private JsonArray identity;
    private JsonArray capabilities;
    private String tenantID;

    public Identity(ContentManager cm, EndpointProperty endPoint) throws Exception {
        JsonObject results = cm.query("~~", new JsonArray(new Object[]{"identity", "tenantID", "userCapabilities"}), null, false, endPoint);
        JsonObject session = results.getArray("objects").getObject(0);
        this.identity = session.getArray("identity");
        this.capabilities = session.getArray("userCapabilities");
        this.tenantID = session.getString("tenantID");
    }

    public boolean isSysAdmin() {
        for (Object item : this.identity) {
            if (!SYSADMIN_ID.equals(((JsonObject)item).getString("id"))) continue;
            return true;
        }
        return false;
    }

    public boolean isSysOrTenantAdmin() {
        for (Object item : this.identity) {
            if (!SYSADMIN_ID.equals(((JsonObject)item).getString("id")) && !TENANTADMIN_ID.equals(((JsonObject)item).getString("id"))) continue;
            return true;
        }
        return false;
    }

    public boolean hasCanUseUsersGroupsAndRolesToolCapbility() {
        for (Object item : this.capabilities) {
            if (!CAN_USE_USERS_GROUPS_AND_ROLES_CAPABILITY.equals(item)) continue;
            return true;
        }
        return false;
    }

    public String getTenantID() {
        return this.tenantID;
    }
}

