/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.utils;

import com.ibm.bi.admin.core.MessageKeys;
import com.ibm.bi.platform.commons.messages.HttpException;
import com.ibm.bi.platform.commons.messages.Message;
import java.util.HashMap;

public class PathBuilder {
    private static final HashMap<String, String> aliases = new HashMap();
    private StringBuilder buf = new StringBuilder();
    private boolean inGroup;
    private boolean firstOperand = true;
    private String groupOperator;

    public PathBuilder() {
    }

    public PathBuilder(String prefix) {
        this.buf.append(prefix);
    }

    public static String fromId(String id) {
        return new PathBuilder().id(id).toString();
    }

    public PathBuilder camid(String value) {
        this.buf.append("CAMID(");
        this.quote(value);
        this.buf.append(")");
        return this;
    }

    public PathBuilder id(String id) {
        if (id.charAt(0) == '.') {
            String alias = aliases.get(id);
            if (alias == null) {
                throw new HttpException(400, new Message(MessageKeys.INVALID_OBJECT_ID, (Object)id));
            }
            this.buf.append(alias);
        } else {
            this.buf.append("storeID(\"").append(id).append("\")");
        }
        return this;
    }

    public PathBuilder children(String type) {
        this.buf.append('/').append(type == null ? "*" : type);
        return this;
    }

    public PathBuilder descendants(String type) {
        this.buf.append("/descendant::").append(type == null ? "*" : type);
        return this;
    }

    public PathBuilder last() {
        this.startPredicate();
        this.buf.append("last()");
        this.endPredicate();
        return this;
    }

    public PathBuilder equalsTo(String property, String value) {
        this.startPredicate();
        this.buf.append(property).append('=');
        this.quote(value);
        this.endPredicate();
        return this;
    }

    private void startPredicate() {
        if (this.firstOperand) {
            this.buf.append('[');
            this.firstOperand = false;
        } else if (this.inGroup) {
            this.buf.append(this.groupOperator);
        }
    }

    private void endPredicate() {
        if (!this.inGroup) {
            this.buf.append(']');
        }
    }

    public PathBuilder notEqualsTo(String property, String value) {
        this.startPredicate();
        this.buf.append(property).append("!=");
        this.quote(value);
        this.endPredicate();
        return this;
    }

    public PathBuilder isNotNull(String prop) {
        this.startPredicate();
        this.buf.append("not(isNull('").append(prop).append("'))");
        this.endPredicate();
        return this;
    }

    public PathBuilder isNull(String prop) {
        this.startPredicate();
        this.buf.append("isNull('").append(prop).append("')");
        this.endPredicate();
        return this;
    }

    public PathBuilder contains(String property, String value) {
        this.startPredicate();
        this.buf.append("contains(").append(property).append(',');
        this.quote(value);
        this.buf.append(')');
        this.endPredicate();
        return this;
    }

    public PathBuilder startsWith(String property, String value) {
        this.startPredicate();
        this.buf.append("starts-with(").append(property).append(',');
        this.quote(value);
        this.buf.append(')');
        this.endPredicate();
        return this;
    }

    public PathBuilder oneOf(String property, String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String value : values) {
            this.buf.append(sep).append(property).append('=');
            this.quote(value);
            sep = " or ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder noneOf(String property, String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String value : values) {
            this.buf.append(sep).append(property).append("!=");
            this.quote(value);
            sep = " and ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder anyPermission(String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String permission : values) {
            this.buf.append(sep).append("permission('").append(permission).append("')");
            sep = " or ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder allPermissions(String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String permission : values) {
            this.buf.append(sep).append("permission('").append(permission).append("')");
            sep = " and ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder navigationFilter() {
        this.buf.append("[@shown='true']");
        this.anyPermission("read", "write", "execute", "traverse", "setPolicy");
        return this;
    }

    public PathBuilder beginOrGroup() {
        this.groupOperator = " or ";
        this.inGroup = true;
        this.firstOperand = true;
        return this;
    }

    public PathBuilder endGroup() {
        this.inGroup = false;
        this.firstOperand = true;
        this.buf.append(']');
        return this;
    }

    public String toString() {
        String result = this.buf.toString();
        this.buf.setLength(0);
        return result;
    }

    public int length() {
        return this.buf.length();
    }

    public void setLength(int len) {
        if (len > this.buf.length()) {
            throw new IllegalArgumentException("invalid length: " + len + " > " + this.buf.length());
        }
        this.buf.setLength(len);
    }

    public PathBuilder addAccount() {
        this.buf.append("//account");
        return this;
    }

    public PathBuilder addIDSearchFilter(String idSearchFilter) {
        String[] searchFilters = null;
        if (idSearchFilter == null) {
            return this;
        }
        searchFilters = idSearchFilter.split(",");
        this.buf.append("[");
        boolean hasEntries = false;
        for (int i = 0; i < searchFilters.length; ++i) {
            if (searchFilters[i].isEmpty()) continue;
            if (hasEntries) {
                this.buf.append(" and ");
            }
            this.buf.append("contains(@id,'" + searchFilters[i] + "')");
            hasEntries = true;
        }
        this.buf.append("]");
        return this;
    }

    private void quote(String value) {
        int n = value.indexOf(34);
        if (n == -1) {
            this.buf.append('\"').append(value).append('\"');
        } else if (value.indexOf(39) == -1) {
            this.buf.append('\'').append(value).append('\'');
        } else {
            this.buf.append('\"');
            int start = 0;
            while (n != -1) {
                this.buf.append(value.substring(start, n)).append('\"');
                start = n + 1;
                n = value.indexOf(34, start);
            }
            this.buf.append(value.substring(start)).append('\"');
        }
    }

    static {
        aliases.put(".public_folders", "/content");
        aliases.put(".my_folders", "~/folder");
    }
}

