/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.utils;

import com.ibm.bi.soap.xml.XMLWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleJsonToXmlWriter {
    private static boolean bSortKeys;
    private XMLWriter out;

    public static void sortKeys(boolean value) {
        bSortKeys = value;
    }

    public static String write(Object value, String root) {
        StringBuilder buf = new StringBuilder();
        if (root == null) {
            if (value instanceof Map && ((Map)value).size() == 1) {
                Iterator iterator = ((Map)value).entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    root = (String)entry.getKey();
                    value = entry.getValue();
                }
            } else {
                throw new IllegalArgumentException("xml root is missing");
            }
        }
        if (value instanceof List) {
            throw new IllegalArgumentException("obj can't be an array");
        }
        new SimpleJsonToXmlWriter(buf).writeAny(root, value);
        return buf.toString();
    }

    private SimpleJsonToXmlWriter(StringBuilder output) {
        this.out = new XMLWriter(output);
        this.out.setTrackNamespaces(false);
    }

    private void writeArray(String tag, List<Object> array) {
        for (Object o : array) {
            this.writeAny(tag, o);
        }
    }

    private void writeObject(String tag, Map<String, Object> o) {
        this.out.element(tag);
        if (bSortKeys) {
            ArrayList<String> keys = new ArrayList<String>(o.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                this.writeAny(key, o.get(key));
            }
        } else {
            for (Map.Entry<String, Object> entry : o.entrySet()) {
                this.writeAny(entry.getKey(), entry.getValue());
            }
        }
        this.out.end();
    }

    private void writeAny(String tag, Object o) {
        if (o instanceof Map) {
            this.writeObject(tag, (Map)o);
        } else if (o instanceof List) {
            this.writeArray(tag, (List)o);
        } else {
            this.out.element(tag);
            if (o != null) {
                this.out.text(o.toString());
            }
            this.out.end();
        }
    }
}

