/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.utils;

import com.ibm.bi.admin.core.exceptions.AdminException;
import com.ibm.bi.admin.core.utils.JsonTimeComparator;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.services.CAMCookie;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class Utils {
    private static final long DEFAULT_PAGESIZE = 1000L;
    public static final String dateTimePattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String dateTimePattern2 = "yyyy-MM-dd'T'HH:mm:ss";

    private Utils() {
    }

    public static String convertToXml(Object obj) {
        return Utils.convertToXml(obj, "UTF-8");
    }

    public static String convertToXml(Object obj, String encoding) {
        String result = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)false);
            marshaller.setProperty("jaxb.encoding", (Object)encoding);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.marshal(obj, (Writer)writer);
            result = writer.toString();
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        return result;
    }

    public static String getPassport(HttpServletRequest request) {
        Cookie[] cookies;
        String passportCookie = null;
        for (Cookie cookie : cookies = request.getCookies()) {
            if (!"cam_passport".equalsIgnoreCase(cookie.getName())) continue;
            passportCookie = cookie.getValue();
            break;
        }
        return CAMCookie.createCookie(passportCookie).getPassportID();
    }

    public static String getItemDisplayPath(JsonArray ancestors) {
        StringBuilder path = new StringBuilder();
        if (ancestors != null) {
            for (int j = 0; j < ancestors.size(); ++j) {
                path.append(ancestors.getObject(j).getString("defaultName"));
                if (j == ancestors.size() - 1) continue;
                path.append(" > ");
            }
        }
        return path.toString();
    }

    public static String getSubscriptionsPath() {
        return "/bi/v1/subscriptions/";
    }

    public static String getSearchPath(String indexId, String filter, List<String> properties, long pageSize) {
        return Utils.getSearchPath(indexId, filter, properties, pageSize, "none");
    }

    public static String getSearchPath(String indexId, String filter, List<String> properties, long pageSize, String scope) {
        StringBuilder path = new StringBuilder();
        path.append("/bi/v1/search/").append(indexId).append("?filter=").append(filter);
        if (properties != null && !properties.isEmpty()) {
            StringBuilder propQueryStr = new StringBuilder();
            propQueryStr.append("&fields=");
            boolean flag = true;
            for (String property : properties) {
                if (flag) {
                    propQueryStr.append(property);
                    flag = false;
                    continue;
                }
                propQueryStr.append("|");
                propQueryStr.append(property);
            }
            path.append(propQueryStr.toString());
        }
        path.append("&results=").append(pageSize);
        path.append("&hide_internal=");
        path.append(scope);
        path.append("&ignoreHiddenAncestor=true");
        return path.toString();
    }

    public static Date parseDateTime(String sDate) {
        SimpleDateFormat informat = new SimpleDateFormat(dateTimePattern);
        SimpleDateFormat informat2 = new SimpleDateFormat(dateTimePattern2);
        Date retDate = null;
        try {
            retDate = informat.parse(sDate);
        }
        catch (Exception ex) {
            try {
                retDate = informat2.parse(sDate);
            }
            catch (ParseException e) {
                throw new AdminException(ex);
            }
        }
        return retDate;
    }

    public static JsonArray sortJsonArrayByDate(JsonArray arrayToBeSorted, String jsonFieldName) throws IOException {
        JsonArray sorted = arrayToBeSorted;
        JsonTimeComparator pComparator = new JsonTimeComparator(jsonFieldName);
        Collections.sort(sorted, pComparator);
        return sorted;
    }

    public static Long getPageSize(JsonObject requestObject) {
        Long pageSize = 1000L;
        if (requestObject.containsKey((Object)"pageSize")) {
            pageSize = requestObject.getLong("pageSize");
        }
        return pageSize;
    }
}

