/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.json;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONString;
import org.apache.commons.json.internal.BeanSerializer;
import org.apache.commons.json.internal.Null;
import org.apache.commons.json.internal.Parser;
import org.apache.commons.json.internal.Serializer;
import org.apache.commons.json.internal.SerializerVerbose;

public class JSONObject
extends HashMap
implements JSONArtifact {
    private static final long serialVersionUID = -3269263069889337298L;
    public static final Object NULL = new Null();

    public static boolean isValidObject(Object object) {
        if (null == object) {
            return true;
        }
        return JSONObject.isValidType(object.getClass());
    }

    public static boolean isValidType(Class clazz) {
        if (null == clazz) {
            throw new IllegalArgumentException();
        }
        if (String.class == clazz) {
            return true;
        }
        if (Boolean.class == clazz) {
            return true;
        }
        if (JSONObject.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (JSONArray.class == clazz) {
            return true;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        return JSONString.class.isAssignableFrom(clazz);
    }

    public JSONObject() {
    }

    public JSONObject(JSONObject jSONObject, String[] stringArray) throws JSONException {
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.containsKey(stringArray[i])) {
                    throw new JSONException("Duplicate key: " + stringArray[i]);
                }
                try {
                    this.put(stringArray[i], jSONObject.get(stringArray[i]));
                    Object object = jSONObject.opt(stringArray[i]);
                    if (object == null) continue;
                    this.put(stringArray[i], object);
                    continue;
                }
                catch (Exception exception) {
                    JSONException jSONException = new JSONException("Error occurred during JSONObject creation");
                    jSONException.initCause(exception);
                    throw jSONException;
                }
            }
        }
    }

    public JSONObject(String string) throws JSONException {
        StringReader stringReader = new StringReader(string);
        new Parser(stringReader).parse(this);
    }

    public JSONObject(String string, boolean bl) throws JSONException {
        StringReader stringReader = new StringReader(string);
        new Parser(stringReader, bl).parse(this);
    }

    public JSONObject(Reader reader) throws JSONException {
        new Parser(reader).parse(this);
    }

    public JSONObject(Reader reader, boolean bl) throws JSONException {
        new Parser(reader, bl).parse(this);
    }

    public JSONObject(InputStream inputStream) throws JSONException {
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (Exception exception) {
                inputStreamReader = new InputStreamReader(inputStream);
            }
        } else {
            throw new JSONException("InputStream cannot be null");
        }
        new Parser(inputStreamReader).parse(true, this);
    }

    public JSONObject(InputStream inputStream, boolean bl) throws JSONException {
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (Exception exception) {
                inputStreamReader = new InputStreamReader(inputStream);
            }
        } else {
            throw new JSONException("InputStream cannot be null");
        }
        new Parser(inputStreamReader, bl).parse(true, this);
    }

    public JSONObject(Map map) {
        Iterator iterator;
        Set set = map.keySet();
        if (set != null && (iterator = set.iterator()) != null) {
            while (iterator.hasNext()) {
                Object k = iterator.next();
                String string = k.toString();
                try {
                    this.put(string, map.get(k));
                }
                catch (Exception exception) {}
            }
        }
    }

    public JSONObject(Object object) throws JSONException {
        if (object != null) {
            JSONObject jSONObject = (JSONObject)BeanSerializer.toJson(object, true);
            this.putAll(jSONObject);
        }
    }

    public JSONObject(Object object, boolean bl) throws JSONException {
        if (object != null) {
            JSONObject jSONObject = (JSONObject)BeanSerializer.toJson(object, bl);
            this.putAll(jSONObject);
        }
    }

    public JSONObject(Map map, boolean bl) throws JSONException {
        Iterator iterator;
        Set set = map.keySet();
        if (set != null && (iterator = set.iterator()) != null) {
            while (iterator.hasNext()) {
                Object k = iterator.next();
                String string = k.toString();
                this.put((Object)string, map.get(k), bl);
            }
        }
    }

    public OutputStream write(OutputStream outputStream) throws JSONException {
        this.write(outputStream, false);
        return outputStream;
    }

    public OutputStream write(OutputStream outputStream, boolean bl) throws JSONException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JSONException jSONException = new JSONException(unsupportedEncodingException.toString());
            jSONException.initCause(unsupportedEncodingException);
            throw jSONException;
        }
        this.write((Writer)bufferedWriter, bl);
        try {
            ((Writer)bufferedWriter).flush();
        }
        catch (Exception exception) {
            JSONException jSONException = new JSONException("Error during buffer flush");
            jSONException.initCause(exception);
            throw jSONException;
        }
        return outputStream;
    }

    public OutputStream write(OutputStream outputStream, int n) throws JSONException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JSONException jSONException = new JSONException(unsupportedEncodingException.toString());
            jSONException.initCause(unsupportedEncodingException);
            throw jSONException;
        }
        this.write((Writer)bufferedWriter, n);
        try {
            ((Writer)bufferedWriter).flush();
        }
        catch (Exception exception) {
            JSONException jSONException = new JSONException("Error during buffer flush");
            jSONException.initCause(exception);
            throw jSONException;
        }
        return outputStream;
    }

    public Writer write(Writer writer) throws JSONException {
        this.write(writer, false);
        return writer;
    }

    public Writer write(Writer writer, boolean bl) throws JSONException {
        Class<?> clazz = writer.getClass();
        boolean bl2 = false;
        if (!(StringWriter.class.isAssignableFrom(clazz) || CharArrayWriter.class.isAssignableFrom(clazz) || BufferedWriter.class.isAssignableFrom(clazz))) {
            writer = new BufferedWriter(writer);
            bl2 = true;
        }
        Serializer serializer = bl ? new SerializerVerbose(writer) : new Serializer(writer);
        try {
            serializer.writeObject(this);
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        if (bl2) {
            try {
                writer.flush();
            }
            catch (Exception exception) {
                JSONException jSONException = new JSONException("Error during buffer flush");
                jSONException.initCause(exception);
                throw jSONException;
            }
        }
        return writer;
    }

    public Writer write(Writer writer, int n) throws JSONException {
        if (n < 1) {
            n = 0;
        } else if (n > 8) {
            n = 9;
        }
        Class<?> clazz = writer.getClass();
        boolean bl = false;
        if (!(StringWriter.class.isAssignableFrom(clazz) || CharArrayWriter.class.isAssignableFrom(clazz) || BufferedWriter.class.isAssignableFrom(clazz))) {
            writer = new BufferedWriter(writer);
            bl = true;
        }
        Serializer serializer = n > 0 ? new SerializerVerbose(writer, n) : new Serializer(writer);
        try {
            serializer.writeObject(this);
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        if (bl) {
            try {
                writer.flush();
            }
            catch (Exception exception) {
                JSONException jSONException = new JSONException("Error during buffer flush");
                jSONException.initCause(exception);
                throw jSONException;
            }
        }
        return writer;
    }

    public String write(int n) throws JSONException {
        StringWriter stringWriter = new StringWriter();
        if (n < 1) {
            n = 0;
        } else if (n > 8) {
            n = 9;
        }
        Serializer serializer = n > 0 ? new SerializerVerbose(stringWriter, n) : new Serializer(stringWriter);
        try {
            serializer.writeObject(this).flush();
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during write.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        return stringWriter.toString();
    }

    public String write(boolean bl) throws JSONException {
        StringWriter stringWriter = new StringWriter();
        Serializer serializer = bl ? new SerializerVerbose(stringWriter) : new Serializer(stringWriter);
        try {
            serializer.writeObject(this).flush();
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during write.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        return stringWriter.toString();
    }

    public String write() throws JSONException {
        return this.write(false);
    }

    public Object get(String string) throws JSONException {
        Object v = this.get((Object)string);
        if (v == null && !this.containsKey(string)) {
            throw new JSONException("The key [" + string + "] was not in the map");
        }
        return v;
    }

    public Object opt(String string) {
        return this.get((Object)string);
    }

    public Object put(Object object, Object object2, boolean bl) throws JSONException {
        if (null == object) {
            throw new JSONException("key must not be null");
        }
        if (!(object instanceof String)) {
            throw new JSONException("key must be a String");
        }
        if (!JSONObject.isValidObject(object2) && object2 != null) {
            try {
                object2 = BeanSerializer.toJson(object2, bl);
            }
            catch (Exception exception) {
                throw new JSONException("Invalid type of value.  Could not convert type: [" + object2.getClass().getName() + "]");
            }
        }
        return super.put(object, object2);
    }

    public Object put(Object object, Object object2) {
        try {
            return this.put(object, object2, true);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error occurred during JSON conversion");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public JSONObject put(String string, Object object) throws JSONException {
        this.put((Object)string, object);
        return this;
    }

    public JSONObject put(String string, boolean bl) throws JSONException {
        this.put(string, (Object)new Boolean(bl));
        return this;
    }

    public JSONObject put(String string, double d) throws JSONException {
        this.put(string, (Object)new Double(d));
        return this;
    }

    public JSONObject put(String string, int n) throws JSONException {
        this.put(string, (Object)new Integer(n));
        return this;
    }

    public JSONObject put(String string, short s) throws JSONException {
        this.put(string, (Object)new Short(s));
        return this;
    }

    public JSONObject put(String string, long l) throws JSONException {
        this.put(string, (Object)new Long(l));
        return this;
    }

    public JSONObject put(String string, Map map, boolean bl) throws JSONException {
        if (map == null) {
            this.put(string, (Object)null);
        } else if (JSONObject.class.isAssignableFrom(map.getClass())) {
            this.put(string, (Object)map);
        } else {
            this.put(string, new JSONObject(map, bl));
        }
        return this;
    }

    public JSONObject put(String string, Map map) throws JSONException {
        return this.put(string, map, true);
    }

    public JSONObject put(String string, Collection collection, boolean bl) throws JSONException {
        if (collection == null) {
            this.put(string, (Object)null);
        } else if (JSONArray.class.isAssignableFrom(collection.getClass())) {
            this.put(string, (Object)collection);
        } else {
            this.put(string, new JSONArray(collection, bl));
        }
        return this;
    }

    public JSONObject put(String string, Collection collection) throws JSONException {
        return this.put(string, collection, true);
    }

    public JSONObject put(String string, Object[] objectArray) throws JSONException {
        return this.put(string, new JSONArray(objectArray), true);
    }

    public JSONObject put(String string, Object[] objectArray, boolean bl) throws JSONException {
        return this.put(string, new JSONArray(objectArray), bl);
    }

    public boolean getBoolean(String string) throws JSONException {
        Object object = this.opt(string);
        if (object != null) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (Number.class.isAssignableFrom(object.getClass())) {
                throw new JSONException("Value at key: [" + string + "] was not a boolean or string value of 'true' or 'false'.");
            }
            if (String.class.isAssignableFrom(object.getClass())) {
                String string2 = (String)object;
                if (string2.equals("true")) {
                    return true;
                }
                if (string2.equals("false")) {
                    return false;
                }
                throw new JSONException("The value for key: [" + string + "]: [" + string2 + "] was not 'true' or 'false'");
            }
            throw new JSONException("The value for key: [" + string + "] was not a type that can be converted to boolean");
        }
        throw new JSONException("The value for key: [" + string + "] was null");
    }

    public boolean optBoolean(String string) {
        Object object = this.opt(string);
        if (object != null) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (Number.class.isAssignableFrom(object.getClass())) {
                return false;
            }
            if (String.class.isAssignableFrom(object.getClass())) {
                String string2 = (String)object;
                return string2.equals("true");
            }
            return false;
        }
        return false;
    }

    public boolean optBoolean(String string, boolean bl) {
        Object object = this.opt(string);
        if (object != null) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (Number.class.isAssignableFrom(object.getClass())) {
                return false;
            }
            if (String.class.isAssignableFrom(object.getClass())) {
                String string2 = (String)object;
                if (string2.equals("true")) {
                    return true;
                }
                if (string2.equals("false")) {
                    return false;
                }
                return bl;
            }
            return bl;
        }
        return bl;
    }

    public double getDouble(String string) throws JSONException {
        Object object = this.opt(string);
        if (object != null) {
            if (Number.class.isAssignableFrom(object.getClass())) {
                return ((Number)object).doubleValue();
            }
            throw new JSONException("The value for key: [" + string + "] was not a type that can be converted to double");
        }
        throw new JSONException("The value for key: [" + string + "] was null.  Number required.");
    }

    public double optDouble(String string) {
        Object object = this.opt(string);
        if (object != null && Number.class.isAssignableFrom(object.getClass())) {
            return ((Number)object).doubleValue();
        }
        return Double.NaN;
    }

    public double optDouble(String string, double d) {
        Object object = this.opt(string);
        if (object != null && Number.class.isAssignableFrom(object.getClass())) {
            return ((Number)object).doubleValue();
        }
        return d;
    }

    public short getShort(String string) throws JSONException {
        Object object = this.opt(string);
        if (object != null) {
            if (Number.class.isAssignableFrom(object.getClass())) {
                return ((Number)object).shortValue();
            }
            throw new JSONException("The value for key: [" + string + "] was not a type that can be converted to short");
        }
        throw new JSONException("The value for key: [" + string + "] was null.  Number required.");
    }

    public short optShort(String string) {
        Object object = this.opt(string);
        if (object != null && Number.class.isAssignableFrom(object.getClass())) {
            return ((Number)object).shortValue();
        }
        return 0;
    }

    public short optShort(String string, short s) {
        Object object = this.opt(string);
        if (object != null && Number.class.isAssignableFrom(object.getClass())) {
            return ((Number)object).shortValue();
        }
        return s;
    }

    public int getInt(String string) throws JSONException {
        Object object = this.opt(string);
        if (object != null) {
            if (Number.class.isAssignableFrom(object.getClass())) {
                return ((Number)object).intValue();
            }
            throw new JSONException("The value for key: [" + string + "] was not a type that can be converted to integer");
        }
        throw new JSONException("The value for key: [" + string + "] was null.  Number required.");
    }

    public int optInt(String string) {
        Object object = this.opt(string);
        if (object != null && Number.class.isAssignableFrom(object.getClass())) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public int optInt(String string, int n) {
        Object object = this.opt(string);
        if (object != null && Number.class.isAssignableFrom(object.getClass())) {
            return ((Number)object).intValue();
        }
        return n;
    }

    public long getLong(String string) throws JSONException {
        Object object = this.opt(string);
        if (object != null) {
            if (Number.class.isAssignableFrom(object.getClass())) {
                return ((Number)object).longValue();
            }
            throw new JSONException("The value for key: [" + string + "] was not a type that can be converted to long");
        }
        throw new JSONException("The value for key: [" + string + "] was null.  Number required.");
    }

    public long optLong(String string) throws JSONException {
        Object object = this.opt(string);
        if (object != null && Number.class.isAssignableFrom(object.getClass())) {
            return ((Number)object).longValue();
        }
        return 0L;
    }

    public long optLong(String string, long l) throws JSONException {
        Object object = this.opt(string);
        if (object != null && Number.class.isAssignableFrom(object.getClass())) {
            return ((Number)object).intValue();
        }
        return l;
    }

    public String getString(String string) throws JSONException {
        Object object = this.opt(string);
        if (object != null) {
            return object.toString();
        }
        throw new JSONException("The value for key: [" + string + "] was null.  Object required.");
    }

    public String optString(String string) {
        Object object = this.opt(string);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public String optString(String string, String string2) {
        Object object = this.opt(string);
        if (object != null) {
            return object.toString();
        }
        return string2;
    }

    public JSONObject getJSONObject(String string) throws JSONException {
        Object object = this.opt(string);
        if (object != null) {
            if (JSONObject.class.isAssignableFrom(object.getClass())) {
                return (JSONObject)object;
            }
            throw new JSONException("The value for key: [" + string + "] was not a JSONObject");
        }
        throw new JSONException("The value for key: [" + string + "] was null.  Object required.");
    }

    public JSONObject optJSONObject(String string) {
        Object object = this.opt(string);
        if (object != null && JSONObject.class.isAssignableFrom(object.getClass())) {
            return (JSONObject)object;
        }
        return null;
    }

    public JSONObject optJSONObject(String string, JSONObject jSONObject) {
        Object object = this.opt(string);
        if (object != null && JSONObject.class.isAssignableFrom(object.getClass())) {
            return (JSONObject)object;
        }
        return jSONObject;
    }

    public JSONArray getJSONArray(String string) throws JSONException {
        Object object = this.opt(string);
        if (object != null) {
            if (JSONArray.class.isAssignableFrom(object.getClass())) {
                return (JSONArray)object;
            }
            throw new JSONException("The value for key: [" + string + "] was not a JSONObject");
        }
        throw new JSONException("The value for key: [" + string + "] was null.  Object required.");
    }

    public JSONArray optJSONArray(String string) throws JSONException {
        Object object = this.opt(string);
        if (object != null && JSONArray.class.isAssignableFrom(object.getClass())) {
            return (JSONArray)object;
        }
        return null;
    }

    public JSONArray optJSONArray(String string, JSONArray jSONArray) throws JSONException {
        Object object = this.opt(string);
        if (object != null && JSONArray.class.isAssignableFrom(object.getClass())) {
            return (JSONArray)object;
        }
        return jSONArray;
    }

    public JSONObject putOnce(String string, Object object) throws JSONException {
        if (string == null) {
            throw new JSONException("Key cannot be null");
        }
        if (object == null) {
            throw new JSONException("Value cannot be null");
        }
        if (this.containsKey(string)) {
            throw new JSONException("Key [" + string + "] already exists in the map");
        }
        this.put(string, object);
        return this;
    }

    public JSONObject putOpt(String string, Object object) throws JSONException {
        if (string == null) {
            throw new JSONException("Key cannot be null");
        }
        if (object == null) {
            throw new JSONException("Value cannot be null");
        }
        this.put(string, object);
        return this;
    }

    public int length() {
        return this.size();
    }

    public JSONObject append(String string, Object object) throws JSONException {
        JSONArray jSONArray = null;
        if (!this.has(string)) {
            jSONArray = new JSONArray();
        } else {
            Object object2 = this.get(string);
            jSONArray = new JSONArray();
            if (object2 == null) {
                jSONArray.add((Object)null);
            } else if (JSONArray.class.isAssignableFrom(object2.getClass())) {
                jSONArray = (JSONArray)object2;
            } else {
                jSONArray = new JSONArray();
                jSONArray.add(object2);
            }
        }
        jSONArray.add(object);
        return this.put(string, jSONArray);
    }

    public JSONArray toJSONArray(JSONArray jSONArray) throws JSONException {
        Iterator iterator = jSONArray.iterator();
        JSONArray jSONArray2 = new JSONArray();
        if (iterator != null && iterator.hasNext()) {
            jSONArray2.put(this.get(iterator.next()));
        }
        return jSONArray2;
    }

    public boolean has(String string) {
        if (string != null) {
            return this.containsKey(string);
        }
        return false;
    }

    public boolean isNull(String string) {
        return this.opt(string) == null || NULL == this.opt(string);
    }

    public Iterator keys() {
        Set set = this.keySet();
        if (set != null) {
            return set.iterator();
        }
        return null;
    }

    public JSONArray names() {
        Iterator iterator = this.keys();
        if (iterator != null) {
            JSONArray jSONArray = new JSONArray();
            while (iterator.hasNext()) {
                jSONArray.add(iterator.next());
            }
            return jSONArray;
        }
        return null;
    }

    public static String[] getNames(JSONObject jSONObject) {
        String[] stringArray = null;
        if (jSONObject != null && jSONObject.size() > 0) {
            stringArray = new String[jSONObject.size()];
            int n = 0;
            Iterator iterator = jSONObject.keys();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    stringArray[n] = (String)iterator.next();
                    ++n;
                }
            }
        }
        return stringArray;
    }

    public Iterator sortedKeys() {
        Iterator iterator = this.keys();
        if (iterator != null && iterator.hasNext()) {
            Vector<Object> vector = new Vector<Object>();
            while (iterator.hasNext()) {
                vector.add(iterator.next());
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            Arrays.sort(objectArray);
            vector.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                vector.add(objectArray[i]);
            }
            return vector.iterator();
        }
        return null;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        String string = null;
        try {
            string = this.write(bl);
        }
        catch (JSONException jSONException) {
            string = "JSON Generation Error: [" + jSONException.toString() + "]";
        }
        return string;
    }

    public String toString(int n) throws JSONException {
        return this.write(n);
    }
}

