/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.json.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.utils.internal.JSONSAXHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XML {
    private static String className = "org.apache.commons.json.xml.transform.XML";
    private static Logger logger = Logger.getLogger(className, null);
    private static final String styleSheet = " <xsl:stylesheet version=\"1.0\"                                   \n     xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">           \n   <xsl:output method=\"xml\"/>                                    \n   <xsl:param name=\"indent-increment\" select=\"'   '\" />        \n   <xsl:template match=\"*\">                                      \n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>              \n      <xsl:value-of select=\"$indent\"/>                           \n      <xsl:copy>                                                   \n        <xsl:copy-of select=\"@*\" />                              \n        <xsl:apply-templates>                                      \n          <xsl:with-param name=\"indent\"                          \n               select=\"concat($indent, $indent-increment)\"/>     \n        </xsl:apply-templates>                                     \n        <xsl:if test=\"*\">                                        \n          <xsl:value-of select=\"$indent\"/>                       \n        </xsl:if>                                                  \n      </xsl:copy>                                                  \n   </xsl:template>                                                 \n   <xsl:template match=\"comment()|processing-instruction()\">     \n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>              \n      <xsl:value-of select=\"$indent\"/>                           \n      <xsl:copy>                                                   \n        <xsl:copy-of select=\"@*\" />                              \n        <xsl:apply-templates>                                      \n          <xsl:with-param name=\"indent\"                          \n               select=\"concat($indent, $indent-increment)\"/>     \n        </xsl:apply-templates>                                     \n        <xsl:if test=\"*\">                                        \n          <xsl:value-of select=\"$indent\"/>                       \n        </xsl:if>                                                  \n      </xsl:copy>                                                  \n   </xsl:template>                                                 \n   <xsl:template match=\"text()[normalize-space(.)='']\"/>         \n </xsl:stylesheet>                                                 \n";

    public static void toJson(InputStream inputStream, OutputStream outputStream) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toJson(InputStream, OutputStream)");
        }
        XML.toJson(inputStream, outputStream, false);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toJson(InputStream, OutputStream)");
        }
    }

    public static void toJson(InputStream inputStream, OutputStream outputStream, boolean bl) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toJson(InputStream, OutputStream)");
        }
        if (inputStream == null) {
            throw new NullPointerException("XMLStream cannot be null");
        }
        if (outputStream == null) {
            throw new NullPointerException("JSONStream cannot be null");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "transform", "Fetching a SAX parser for use with JSONSAXHandler");
        }
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            JSONSAXHandler jSONSAXHandler = new JSONSAXHandler(outputStream, bl);
            xMLReader.setContentHandler(jSONSAXHandler);
            xMLReader.setErrorHandler(jSONSAXHandler);
            InputSource inputSource = new InputSource(new BufferedInputStream(inputStream));
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "transform", "Parsing the XML content to JSON");
            }
            inputSource.setEncoding("UTF-8");
            xMLReader.parse(inputSource);
            jSONSAXHandler.flushBuffer();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Could not get a parser: " + parserConfigurationException.toString());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toJson(InputStream, OutputStream)");
        }
    }

    public static String toJson(InputStream inputStream) throws SAXException, IOException {
        return XML.toJson(inputStream, false);
    }

    public static String toJson(InputStream inputStream, boolean bl) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toJson(InputStream, boolean)");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = null;
        try {
            XML.toJson(inputStream, byteArrayOutputStream, bl);
            string = byteArrayOutputStream.toString("UTF-8");
            byteArrayOutputStream.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IOException iOException = new IOException(unsupportedEncodingException.toString());
            iOException.initCause(unsupportedEncodingException);
            throw iOException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toJson(InputStream, boolean)");
        }
        return string;
    }

    public static String toJson(File file, boolean bl) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toJson(InputStream, boolean)");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = null;
        string = XML.toJson((InputStream)fileInputStream, bl);
        fileInputStream.close();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toJson(InputStream, boolean)");
        }
        return string;
    }

    public static String toJson(File file) throws SAXException, IOException {
        return XML.toJson(file, false);
    }

    public static void toXml(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toXml(InputStream, OutputStream)");
        }
        XML.toXml(inputStream, outputStream, false);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toXml(InputStream, OutputStream)");
        }
    }

    public static void toXml(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toXml(InputStream, OutputStream)");
        }
        if (outputStream == null) {
            throw new NullPointerException("XMLStream cannot be null");
        }
        if (inputStream == null) {
            throw new NullPointerException("JSONStream cannot be null");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "transform", "Parsing the JSON and a DOM builder.");
        }
        try {
            JSONObject jSONObject = new JSONObject(inputStream);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "transform", "Parsing the JSON content to XML");
            }
            XML.convertJSONObject(document, document.getDocumentElement(), jSONObject, "jsonObject");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            transformer = bl ? transformerFactory.newTransformer(new StreamSource(new StringReader(styleSheet))) : transformerFactory.newTransformer();
            Properties properties = new Properties();
            properties.put("method", "xml");
            properties.put("omit-xml-declaration", "yes");
            properties.put("version", "1.0");
            properties.put("indent", "true");
            transformer.setOutputProperties(properties);
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Problem during conversion");
            iOException.initCause(exception);
            throw iOException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toXml(InputStream, OutputStream)");
        }
    }

    public static String toXml(InputStream inputStream) throws IOException {
        return XML.toXml(inputStream, false);
    }

    public static String toXml(InputStream inputStream, boolean bl) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toXml(InputStream, boolean)");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = null;
        try {
            XML.toXml(inputStream, byteArrayOutputStream, bl);
            string = byteArrayOutputStream.toString("UTF-8");
            byteArrayOutputStream.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IOException iOException = new IOException(unsupportedEncodingException.toString());
            iOException.initCause(unsupportedEncodingException);
            throw iOException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toXml(InputStream, boolean)");
        }
        return string;
    }

    public static String toXml(File file, boolean bl) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toXml(InputStream, boolean)");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = null;
        string = XML.toXml((InputStream)fileInputStream, bl);
        fileInputStream.close();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toXml(InputStream, boolean)");
        }
        return string;
    }

    public static String toXml(File file) throws IOException {
        return XML.toXml(file, false);
    }

    private static void convertJSONObject(Document document, Element element, JSONObject jSONObject, String string) {
        Set set = jSONObject.keySet();
        Iterator iterator = set.iterator();
        Element element2 = document.createElement(XML.removeProblemCharacters(string));
        if (element != null) {
            element.appendChild(element2);
        } else {
            document.appendChild(element2);
        }
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object object = jSONObject.opt(string2);
            if (object instanceof Number) {
                element2.setAttribute(string2, object.toString());
                continue;
            }
            if (object instanceof Boolean) {
                element2.setAttribute(string2, object.toString());
                continue;
            }
            if (object instanceof String) {
                element2.setAttribute(string2, XML.escapeEntityCharacters(object.toString()));
                continue;
            }
            if (object == null) {
                element2.setAttribute(string2, "");
                continue;
            }
            if (object instanceof JSONObject) {
                XML.convertJSONObject(document, element2, (JSONObject)object, string2);
                continue;
            }
            if (!(object instanceof JSONArray)) continue;
            XML.convertJSONArray(document, element2, (JSONArray)object, string2);
        }
    }

    private static void convertJSONArray(Document document, Element element, JSONArray jSONArray, String string) {
        string = XML.removeProblemCharacters(string);
        for (int i = 0; i < jSONArray.size(); ++i) {
            Text text;
            Element element2 = document.createElement(string);
            if (element != null) {
                element.appendChild(element2);
            } else {
                document.appendChild(element2);
            }
            Object e = jSONArray.get(i);
            if (e instanceof Number) {
                text = document.createTextNode(e.toString());
                element2.appendChild(text);
                continue;
            }
            if (e instanceof Boolean) {
                text = document.createTextNode(e.toString());
                element2.appendChild(text);
                continue;
            }
            if (e instanceof String) {
                text = document.createTextNode(XML.escapeEntityCharacters(e.toString()));
                element2.appendChild(text);
                continue;
            }
            if (e instanceof JSONObject) {
                XML.convertJSONObject(document, element2, (JSONObject)e, "jsonObject");
                continue;
            }
            if (!(e instanceof JSONArray)) continue;
            XML.convertJSONArray(document, element2, (JSONArray)e, "jsonArray");
        }
    }

    private static String escapeEntityCharacters(String string) {
        String string2 = null;
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer("");
            block7: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block7;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        continue block7;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block7;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        stringBuffer.append("&apos;");
                        continue block7;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private static String removeProblemCharacters(String string) {
        String string2 = null;
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer("");
            block3: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case ' ': 
                    case '!': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '&': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        stringBuffer.append("_");
                        continue block3;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }
}

