/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.autoca;

import com.cognos.accman.autoca.RequestHandler;
import com.cognos.accman.autoca.RequestHandlerFactory;
import com.cognos.accman.res.MessageSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;

public class CaServerThread
extends Thread {
    private Socket socket;

    public CaServerThread(Socket socket) {
        super("CaServerThread");
        this.socket = socket;
        try {
            socket.setSoTimeout(60000);
        }
        catch (SocketException se) {
            System.err.println(MessageSet.getMessage("CAM_CRP_cant_set_SO_TIMEOUT"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader in;
        PrintWriter out;
        try {
            out = new PrintWriter(this.socket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (IOException e) {
            return;
        }
        try {
            String connectStr = in.readLine();
            if (connectStr.length() > "CAM-CA REQUEST/".length() && connectStr.substring(0, "CAM-CA REQUEST/".length()).compareTo("CAM-CA REQUEST/") == 0) {
                String num = connectStr.substring("CAM-CA REQUEST/".length() + 1);
                if (connectStr.substring("CAM-CA REQUEST/".length()).compareTo("1.0") == 0) {
                    String sockLine;
                    boolean badHeader = false;
                    int contentLength = 0;
                    while ((sockLine = in.readLine()) != null && sockLine.length() != 0) {
                        if (sockLine.length() <= "Content-length: ".length() || sockLine.substring(0, "Content-length: ".length()).compareTo("Content-length: ") != 0) continue;
                        if (contentLength != 0) {
                            badHeader = true;
                            break;
                        }
                        try {
                            contentLength = Integer.parseInt(sockLine.substring("Content-length: ".length()));
                        }
                        catch (NumberFormatException numberformatexception) {
                            badHeader = true;
                            break;
                        }
                    }
                    if (sockLine != null) {
                        if (contentLength == 0) {
                            badHeader = true;
                        }
                        if (!badHeader) {
                            if ((long)contentLength <= 65535L) {
                                RequestHandler reqhdlr;
                                int charsRead;
                                int result;
                                String requestXML = "";
                                char[] cbuf = new char[contentLength];
                                for (charsRead = 0; charsRead < contentLength && (result = in.read(cbuf, charsRead, contentLength - charsRead)) != -1; charsRead += result) {
                                }
                                boolean bOK = false;
                                if (charsRead == contentLength && !in.ready() && (reqhdlr = RequestHandlerFactory.create(requestXML = String.copyValueOf(cbuf))) != null) {
                                    String responseXML = reqhdlr.process();
                                    out.println("CAM-CA/1.0 200 OK");
                                    out.println("Content-length: " + responseXML.length());
                                    out.println("");
                                    out.print(responseXML);
                                    out.flush();
                                    bOK = true;
                                    reqhdlr.postprocess();
                                }
                                if (!bOK) {
                                    out.println("CAM-CA/1.0 400 Bad Request");
                                }
                            } else {
                                out.println("CAM-CA/1.0 413 Request Entity Too Large");
                            }
                        } else {
                            out.println("CAM-CA/1.0 400 Bad Request");
                        }
                    }
                } else {
                    out.println("CAM-CA/1.0 505 Version Not Supported");
                }
            } else {
                out.println("CAM-CA/1.0 400 Bad Request");
            }
        }
        catch (InterruptedIOException iioe) {
            out.println("CAM-CA/1.0 408 Request Timeout");
        }
        catch (IOException e) {
            out.println("CAM-CA/1.0 408 Request Timeout");
            System.err.println(MessageSet.getMessage("CAM_CRP_autoca_comms_error"));
            System.err.println(e.getLocalizedMessage());
        }
        finally {
            try {
                out.close();
                in.close();
                this.socket.close();
            }
            catch (IOException iioe) {}
        }
    }
}

