/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.autoca;

import com.cognos.accman.autoca.CaServer;
import com.cognos.accman.autoca.RequestHandler;
import com.cognos.accman.autoca.XmlCaError;
import com.cognos.accman.autoca.XmlCaResponse;
import com.cognos.accman.autoca.XmlStopRequest;
import com.cognos.accman.autoca.XmlStopResponse;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapperException;
import java.util.Date;

public class StopRequestHandler
implements RequestHandler {
    private static final int TIMESTAMP_VALIDITY_INTERVAL = 20000;
    private XmlStopRequest stopRequest;
    private boolean shutdownServerDuringPostProcess = false;

    public StopRequestHandler(XmlStopRequest newStopRequest) {
        this.stopRequest = newStopRequest;
    }

    @Override
    public String process() {
        Configuration config = Configuration.getInstance();
        XmlCaResponse caResponse = new XmlCaResponse();
        String timestampStr = new String();
        timestampStr = timestampStr + this.stopRequest.timestamp;
        boolean bCompareHMAC = false;
        try {
            byte[] properHMAC;
            String base64properHMAC;
            byte[] properShaHMAC;
            String base64properShaHMAC;
            String hmacAlgorithm = this.stopRequest.hmacAlgorithm;
            bCompareHMAC = hmacAlgorithm == null || hmacAlgorithm.length() == 0 ? this.stopRequest.shaHMAC.compareTo(base64properShaHMAC = new String(CryptoWrapper.encodeBase64(properShaHMAC = CryptoWrapper.calculateHMAC(timestampStr.getBytes(), config.getCAPassword())))) == 0 : this.stopRequest.hmac.compareTo(base64properHMAC = new String(CryptoWrapper.encodeBase64(properHMAC = CryptoWrapper.calculateHMAC(timestampStr.getBytes(), config.getCAPassword(), hmacAlgorithm)))) == 0;
        }
        catch (CryptoWrapperException cge) {
            XmlCaError caError = new XmlCaError();
            caError.addError(cge.toString());
            caResponse.setResponse(caError);
            return caResponse.toString();
        }
        catch (CAMCryptoException cce) {
            XmlCaError caError = new XmlCaError();
            caError.addError(cce.toString());
            caResponse.setResponse(caError);
            return caResponse.toString();
        }
        if (bCompareHMAC) {
            Date currentDate = new Date();
            Date timestampRangeStart = new Date(this.stopRequest.timestamp - 20000L);
            Date timestampRangeEnd = new Date(this.stopRequest.timestamp + 20000L);
            if (currentDate.after(timestampRangeStart) && currentDate.before(timestampRangeEnd)) {
                this.shutdownServerDuringPostProcess = true;
                caResponse.setResponse(new XmlStopResponse());
            } else {
                XmlCaError caError = new XmlCaError();
                caError.addError("The Certificate Authority service shut down request contained an invalid time stamp.");
                caResponse.setResponse(caError);
            }
        } else {
            XmlCaError caError = new XmlCaError();
            caError.addError("A Certificate Authority Service shut down request was not authorized. Most likely the client machine's CA password does not match the server's.");
            caResponse.setResponse(caError);
        }
        return caResponse.toString();
    }

    @Override
    public void postprocess() {
        if (this.shutdownServerDuringPostProcess) {
            CaServer.shutdownServer();
        }
    }
}

