/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.autoca;

import org.dom4j.Element;

public class XmlCertRequest {
    public String shaHMAC;
    public String hmac;
    public String hmacAlgorithm;
    public String pkcs10data;

    public static XmlCertRequest fromElement(Element certReqElem) {
        if (certReqElem.getNamespaceURI().compareTo("http://developer.cognos.com/schemas/autoCAService/1/") != 0 || certReqElem.getName().compareTo("certRequest") != 0) {
            return null;
        }
        String hmacAlg = certReqElem.attributeValue("hmacAlgorithm");
        if (hmacAlg == null || hmacAlg.length() == 0) {
            return XmlCertRequest.fromElement1(certReqElem);
        }
        return XmlCertRequest.fromElement2(certReqElem, hmacAlg);
    }

    private static XmlCertRequest fromElement1(Element certReqElem) {
        XmlCertRequest newCertReq = new XmlCertRequest();
        newCertReq.shaHMAC = certReqElem.attributeValue("sha1HMAC");
        Element pkcs10dataElem = certReqElem.element("pkcs10data");
        if (pkcs10dataElem == null) {
            return null;
        }
        newCertReq.pkcs10data = pkcs10dataElem.getText();
        return newCertReq;
    }

    private static XmlCertRequest fromElement2(Element certReqElem, String hmacAlg) {
        XmlCertRequest newCertReq = new XmlCertRequest();
        newCertReq.hmacAlgorithm = hmacAlg;
        newCertReq.hmac = certReqElem.attributeValue("HMAC");
        Element pkcs10dataElem = certReqElem.element("pkcs10data");
        if (pkcs10dataElem == null) {
            return null;
        }
        newCertReq.pkcs10data = pkcs10dataElem.getText();
        return newCertReq;
    }

    public String toString() {
        if (this.hmacAlgorithm == null || this.hmacAlgorithm.length() == 0) {
            return "<certRequest sha1HMAC=\"" + this.shaHMAC + "\"><" + "pkcs10data" + ">" + this.pkcs10data.toString() + "</" + "pkcs10data" + ">" + "</" + "certRequest" + ">";
        }
        return "<certRequest HMAC=\"" + this.hmac + "\" " + "hmacAlgorithm" + "=\"" + this.hmacAlgorithm + "\"><" + "pkcs10data" + ">" + this.pkcs10data.toString() + "</" + "pkcs10data" + ">" + "</" + "certRequest" + ">";
    }
}

