/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.autoca.client;

import com.cognos.accman.autoca.XmlCaError;
import com.cognos.accman.autoca.XmlCaRequest;
import com.cognos.accman.autoca.XmlCaResponse;
import com.cognos.accman.autoca.XmlCertRequest;
import com.cognos.accman.autoca.XmlCertResponse;
import com.cognos.accman.autoca.client.CaClientException;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapperException;
import com.cognos.accman.jcam.crypto.misc.HttpClientInitializer;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URL;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class CaClient {
    private Certificate requestedCert = null;
    private Certificate caCert = null;
    private static final String CA_REQ_HEAD = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">\n<SOAP-ENV:Header>\n<bus:biBusHeader xsi:type=\"bus:biBusHeader\">\n</bus:biBusHeader>\n</SOAP-ENV:Header>\n<SOAP-ENV:Body>\n";
    private static final String CA_REQ_TAIL = "</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>\n";
    private static final String CA_FND_SOAP_ACTION = "\"http://developer.cognos.com/schemas/autoCAFinder/1\"";
    private static final String CA_AUTO_SOAP_ACTION = "\"http://developer.cognos.com/schemas/autoCAService/1\"";

    public Certificate getRequestedCert() {
        return this.requestedCert;
    }

    public Certificate getCaCert() {
        return this.caCert;
    }

    public XmlCaRequest genCARequest(String certSubjectDN, PublicKey publicKey, PrivateKey reqSigningKey, String caPassword) throws CaClientException {
        String base64pkcs10data;
        XmlCaRequest caRequest = new XmlCaRequest();
        XmlCertRequest certRequest = new XmlCertRequest();
        Configuration config = Configuration.getInstance();
        try {
            String base64HMAC;
            String digestAlgorithm = config.getDigestAlgorithm();
            byte[] pkcs10data = CryptoWrapper.createCertificateRequest(certSubjectDN, publicKey, reqSigningKey, digestAlgorithm, null);
            base64pkcs10data = new String(CryptoWrapper.encodeBase64(pkcs10data));
            String hmacAlgorithm = config.getConfiguredHMACAlgorithm();
            byte[] hmac = CryptoWrapper.calculateHMAC(base64pkcs10data.getBytes(), caPassword, hmacAlgorithm);
            certRequest.hmac = base64HMAC = new String(CryptoWrapper.encodeBase64(hmac));
            certRequest.hmacAlgorithm = hmacAlgorithm;
        }
        catch (CAMCryptoException cce) {
            throw new CaClientException(cce, MessageSet.getMessage("CAM_CRP_no_create_cert_req_p0"));
        }
        certRequest.pkcs10data = base64pkcs10data;
        caRequest.setRequest(certRequest);
        return caRequest;
    }

    public void verifyCAResponse(XmlCertResponse certResponse, String caPassword) throws CaClientException {
        boolean bCompareHMAC = false;
        try {
            byte[] properHMAC;
            String base64properHMAC;
            byte[] properShaHMAC;
            String base64properShaHMAC;
            bCompareHMAC = certResponse.hmacAlgorithm == null || certResponse.hmacAlgorithm.length() == 0 ? certResponse.shaHMAC.compareTo(base64properShaHMAC = new String(CryptoWrapper.encodeBase64(properShaHMAC = CryptoWrapper.calculateHMAC((certResponse.requestedCert + certResponse.caCert).getBytes(), caPassword)))) == 0 : certResponse.hmac.compareTo(base64properHMAC = new String(CryptoWrapper.encodeBase64(properHMAC = CryptoWrapper.calculateHMAC((certResponse.requestedCert + certResponse.caCert).getBytes(), caPassword, certResponse.hmacAlgorithm)))) == 0;
        }
        catch (CryptoWrapperException cge) {
            throw new CaClientException(cge, MessageSet.getMessage("CAM_CRP_ca_hmac_calc_error"));
        }
        if (!bCompareHMAC) {
            throw new CaClientException(MessageSet.getMessage("CAM_CRP_no_verify_autoCA_response"));
        }
    }

    public void decodeCAResponse(XmlCertResponse certResponse) throws CaClientException {
        CertificateFactory cf = null;
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                cf = CertificateFactory.getInstance("X.509", jceProvider);
            } else {
                cf = CertificateFactory.getInstance("X.509");
            }
        }
        catch (Exception e) {
            throw new CaClientException(e, MessageSet.getMessage("CAM_CRP_failed_find_JCE_provider"));
        }
        try {
            ByteArrayInputStream req_bais = new ByteArrayInputStream(CryptoWrapper.decodeBase64(certResponse.requestedCert.getBytes()));
            this.requestedCert = cf.generateCertificate(req_bais);
        }
        catch (CertificateException ce) {
            throw new CaClientException(ce, MessageSet.getMessage("CAM_CRP_no_decode_generated_cert"));
        }
        ByteArrayInputStream ca_bais = new ByteArrayInputStream(CryptoWrapper.decodeBase64(certResponse.caCert.getBytes()));
        try {
            this.caCert = cf.generateCertificate(ca_bais);
        }
        catch (CertificateException ce) {
            throw new CaClientException(ce, MessageSet.getMessage("CAM_CRP_no_decode_autoCA_cert"));
        }
    }

    public void requestCertificate(XmlCaRequest caRequest, URL dispatcher, String caPassword) throws CaClientException {
        XmlCaResponse caResponse;
        try {
            File caStore;
            if (dispatcher.getProtocol().equals("https") && !(caStore = new File(Configuration.getInstance().getCAMKeystoreLocation())).exists()) {
                IPFAuditFunction.trace("Could not load truststore, will prompt user.");
            }
            caResponse = CaClient.sendCARequest(caRequest, dispatcher);
        }
        catch (Exception e) {
            throw new CaClientException(e, MessageSet.getMessage("CAM_CRP_ca_req_error"));
        }
        if (caResponse == null) {
            throw new CaClientException(MessageSet.getMessage("CAM_CRP_ca_req_error"));
        }
        XmlCertResponse certResponse = (XmlCertResponse)caResponse.getResponse();
        this.verifyCAResponse(certResponse, caPassword);
        this.decodeCAResponse(certResponse);
    }

    private static XmlCaResponse sendCARequest(XmlCaRequest caRequest, URL dispatcher) throws CaClientException {
        String response;
        XmlCaResponse caResponse = null;
        PostMethod post = new PostMethod();
        String strXMLRequest = new StringBuffer().append(CA_REQ_HEAD).append(caRequest.toString()).append(CA_REQ_TAIL).toString();
        post.setRequestBody(strXMLRequest);
        post.setPath(dispatcher.getFile());
        post.setRequestHeader("Content-type", "text/xml");
        Configuration cfg = Configuration.getInstance();
        if (!cfg.getWeAreCM()) {
            post.setRequestHeader("SOAPAction", CA_FND_SOAP_ACTION);
        } else {
            post.setRequestHeader("SOAPAction", CA_AUTO_SOAP_ACTION);
        }
        int resultCode = 0;
        try {
            HttpClient hc = HttpClientInitializer.getInstance().createHttpClient(dispatcher);
            hc.setConnectionTimeout(30000);
            hc.setTimeout(30000);
            resultCode = hc.executeMethod((HttpMethod)post);
            response = CAMCryptoUtilities.getResponseString(post);
            post.releaseConnection();
        }
        catch (Exception e) {
            throw new CaClientException(e, MessageSet.getMessage("CAM_CRP_ca_connection_failed"));
        }
        if (resultCode < 200 || resultCode > 299) {
            CaClientException wrappedExc = new CaClientException(MessageSet.getMessage("CAM_CRP_req_http_ret_code_error", new String[]{String.valueOf(resultCode)}));
            throw new CaClientException(wrappedExc, MessageSet.getMessage("CAM_CRP_ca_connection_failed"));
        }
        caResponse = XmlCaResponse.fromBibusString(response);
        if (caResponse == null) {
            throw new CaClientException(MessageSet.getMessage("CAM_CRP_ca_req_error"));
        }
        if (caResponse.getIsErrorResponse()) {
            XmlCaError caError = (XmlCaError)caResponse.getResponse();
            String[] errParams = new String[]{caError.toErrorText()};
            throw new CaClientException(MessageSet.getMessage("CAM_CRP_ca_error_xml", errParams));
        }
        return caResponse;
    }
}

