/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.Token;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CSKDigest;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Mac;

public class BATrustedRequestSession
extends Token {
    private int timeout_millisecond = 300000;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int VERSION = 2;
    private int version;
    private Date timestamp;
    private byte[] serviceid;
    private byte[] cskAlias;
    private byte[] hmacAlgorithm;
    private byte[] hmac;
    private int version_test = 0;

    public String generateToken(String serviceid) throws CAMCryptoException {
        IPFAuditFunction.trace("generateToken called");
        this.version = this.version_test != 0 ? this.version_test : 2;
        this.timestamp = this.getTimeoutDate(this.timeout_millisecond);
        this.serviceid = serviceid.getBytes();
        this.cskAlias = CSKDigest.getInstance().getCurrentCSKDigest();
        if (this.version == 1) {
            this.hmacAlgorithm = "HmacSHA256".getBytes();
        } else {
            Configuration config = Configuration.getInstance();
            this.hmacAlgorithm = config.getHMACAlgorithm().getBytes();
        }
        byte[] hmacBytes = this.calculateHMAC();
        if (hmacBytes == null) {
            IPFAuditFunction.error("Failed at calculating HMAC");
            return null;
        }
        this.hmac = hmacBytes;
        byte[] binaryToken = null;
        try {
            binaryToken = this.writeToken();
        }
        catch (CAMCryptoException e) {
            IPFAuditFunction.error("Failed at writing token. Exception: " + e.getMessage());
            return null;
        }
        String base64Token = new String(CryptoWrapper.encodeBase64(binaryToken));
        IPFAuditFunction.trace("generateToken completed");
        return base64Token;
    }

    public boolean verifyToken(String base64Token) throws CAMCryptoException {
        IPFAuditFunction.trace("verifyToken called");
        byte[] binaryToken = CryptoWrapper.decodeBase64(base64Token.getBytes());
        try {
            this.readToken(binaryToken);
        }
        catch (CAMCryptoException e) {
            IPFAuditFunction.error("Failed at reading token. Exception: " + e.getMessage());
            return false;
        }
        if (this.version != 1 && this.version != 2) {
            IPFAuditFunction.error("invalid token version.");
            return false;
        }
        Date now = new Date();
        if (now.getTime() > this.timestamp.getTime()) {
            IPFAuditFunction.error("token is expired.");
            return false;
        }
        byte[] hmacBytes = this.calculateHMAC();
        if (!Arrays.equals(hmacBytes, this.hmac)) {
            IPFAuditFunction.error("invalid token.");
            return false;
        }
        IPFAuditFunction.trace("verifyToken completed");
        return true;
    }

    public String getServiceIDAndVerifyToken(String trustToken) throws CAMCryptoException {
        IPFAuditFunction.trace("getServiceIDAndVerifyToken called");
        String serviceIDString = null;
        boolean isTrusted = this.verifyToken(trustToken);
        if (isTrusted) {
            IPFAuditFunction.trace("Verified trustToken and return the server ID");
            serviceIDString = new String(this.serviceid);
        } else {
            IPFAuditFunction.error("Not return the server ID because not able to verify the trustToken");
        }
        IPFAuditFunction.trace("getServiceIDAndVerifyToken completed");
        return serviceIDString;
    }

    public void setTimeout(int timeout_millisecond) {
        this.timeout_millisecond = timeout_millisecond;
    }

    protected void setVersion(int version) {
        this.version_test = version;
    }

    @Override
    public void writeToken(ByteArrayOutputStream out) throws CAMCryptoException {
        this.writeVersion(out, this.version);
        this.writeBATime(out, this.timestamp);
        this.writeByteArray(out, this.serviceid);
        this.writeByteArray(out, this.cskAlias);
        if (this.version > 1) {
            this.writeByteArray(out, this.hmacAlgorithm);
        }
        this.writeByteArray(out, this.hmac);
    }

    @Override
    public void readToken(ByteArrayInputStream in) throws CAMCryptoException {
        this.version = this.readVersion(in);
        this.timestamp = this.readBATime(in);
        this.serviceid = this.readByteArray(in);
        this.cskAlias = this.readByteArray(in);
        this.hmacAlgorithm = this.version == 1 ? "HmacSHA256".getBytes() : this.readByteArray(in);
        this.hmac = this.readByteArray(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] calculateHMAC() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
        byte[] timestampBytes = sdf.format(this.timestamp).getBytes();
        Mac mac = null;
        String alg = new String(this.hmacAlgorithm);
        try {
            mac = CAMCryptoUtilities.getMacGivenCSKDigest(this.cskAlias, alg);
        }
        catch (CAMCryptoException e) {
            IPFAuditFunction.error("Failed at initializing MAC object with exception: " + e.getClass().getName() + ", message = " + e.getMessage());
            return null;
        }
        byte[] hmacBytes = null;
        try {
            Mac mac2 = mac;
            synchronized (mac2) {
                mac.update(timestampBytes);
                mac.update(this.serviceid);
                mac.update(this.cskAlias);
                hmacBytes = mac.doFinal();
            }
        }
        catch (IllegalStateException e) {
            IPFAuditFunction.error("Failed at generating HMAC bytes. Exception: " + e.getMessage());
            return null;
        }
        return hmacBytes;
    }

    private Date getTimeoutDate(int timeout_millisecond) {
        Date now = new Date();
        long lNow = now.getTime();
        long timeoutTime = lNow + (long)timeout_millisecond;
        Date timeoutDate = new Date(timeoutTime);
        return timeoutDate;
    }
}

