/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.res.MessageSet;
import java.io.PrintStream;
import java.io.PrintWriter;

public class CAMCryptoException
extends Exception {
    private Throwable cause;

    public CAMCryptoException(Throwable cause, String message) {
        super(CAMCryptoException.appendCauseMessage(cause, message));
        this.cause = cause;
    }

    private static String appendCauseMessage(Throwable cause, String message) {
        String causeMsg = cause.toString();
        if (cause instanceof CAMCryptoException) {
            causeMsg = causeMsg.substring(causeMsg.indexOf(32) + 1);
            return message + " " + causeMsg;
        }
        String reason = MessageSet.getMessage("CAM_CRP_exception_reason", new String[]{causeMsg});
        reason = reason.substring(reason.indexOf(32) + 1);
        return message + " " + reason;
    }

    public CAMCryptoException(String message) {
        super(message);
    }

    public CAMCryptoException(Throwable cause) {
        this(cause, "");
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public Throwable getRootCause() {
        if (this.cause instanceof CAMCryptoException) {
            return ((CAMCryptoException)this.cause).getRootCause();
        }
        return this.cause == null ? this : this.cause;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.cause != null) {
            this.cause.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        if (this.cause != null) {
            this.cause.printStackTrace(ps);
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        if (this.cause != null) {
            this.cause.printStackTrace(pw);
        }
    }

    @Override
    public String toString() {
        String s = this.getMessage();
        if (s == "" || s == null) {
            s = this.getCause().getMessage();
        }
        return s;
    }
}

