/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.res.MessageSet;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;

public class CAMCryptoServerException
extends CAMCryptoException {
    private Throwable cause;
    private String messageName;

    public CAMCryptoServerException(Throwable cause, String messageName) {
        super(MessageSet.getMessage(messageName));
        this.cause = cause;
        this.messageName = messageName;
    }

    public CAMCryptoServerException(String messageName) {
        super(MessageSet.getMessage(messageName));
        this.messageName = messageName;
    }

    public CAMCryptoServerException(Throwable cause, String messageName, String[] parameter) {
        super(MessageSet.getMessage(messageName));
        this.cause = cause;
        this.messageName = messageName;
    }

    public CAMCryptoServerException(String messageName, String[] parameter) {
        super(MessageSet.getMessage(messageName, parameter));
        this.messageName = messageName;
    }

    public String toString(String locale) {
        CompositeName messageNames = null;
        try {
            messageNames = new CompositeName(this.getMessageNames());
        }
        catch (InvalidNameException e) {
            e.printStackTrace();
        }
        if (locale == null || locale.length() == 0) {
            locale = "en_US";
        }
        String s = "";
        for (int i = 0; i < messageNames.size(); ++i) {
            String messageName = messageNames.get(i);
            String msg = null;
            try {
                msg = MessageSet.getMessage(messageName, locale);
            }
            catch (RuntimeException e1) {
                msg = messageName;
            }
            s = msg + " " + s;
        }
        return s;
    }

    public String getMessageNames() {
        String messageNames0 = null;
        CompositeName messageNames = null;
        try {
            if (this.cause != null) {
                messageNames0 = this.cause instanceof CAMCryptoServerException ? ((CAMCryptoServerException)this.cause).getMessageNames() : this.cause.getMessage();
                messageNames = new CompositeName(messageNames0);
            } else {
                messageNames = new CompositeName();
            }
            if (this.messageName != null && this.messageName.compareTo("") != 0) {
                messageNames.add(this.messageName);
            }
        }
        catch (InvalidNameException e) {
            e.printStackTrace();
        }
        return messageNames.toString();
    }
}

