/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.BATrustedRequestSession;
import com.cognos.accman.jcam.crypto.CAMCipherStreamFactory;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CMDRTEncryptingSession;
import com.cognos.accman.jcam.crypto.CSKRequestHandler;
import com.cognos.accman.jcam.crypto.ConfiguringSession;
import com.cognos.accman.jcam.crypto.DSServiceAccessSession;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.DeploymentCipherStreamSession;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.accman.jcam.crypto.FileSignatureSession;
import com.cognos.accman.jcam.crypto.GenericHMACSession;
import com.cognos.accman.jcam.crypto.HttpClientFactory;
import com.cognos.accman.jcam.crypto.ReportSpecProtectionSession;
import com.cognos.accman.jcam.crypto.SecureStateSession;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.accman.jcam.crypto.SystemProtectionSession;
import com.cognos.accman.jcam.crypto.TmpCipherStreamSession;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.accman.jcam.crypto.UserSessionIDSession;
import com.cognos.accman.jcam.crypto.casync.CARequestHandler;
import com.cognos.accman.jcam.crypto.casync.CaSyncHandler;
import com.cognos.accman.jcam.crypto.gss.CAM_GSSHelper;
import com.cognos.accman.jcam.crypto.gss.CAM_GSSHelperImpl;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CAMSSLSocketFactory;
import com.cognos.accman.jcam.crypto.misc.CipherSuiteManager;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoProviderManager;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.DigestAlgorithmManager;
import com.cognos.accman.jcam.crypto.misc.HttpClientInitializer;
import com.cognos.accman.jcam.crypto.misc.IConfiguration;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyExpiryChecker;
import com.cognos.accman.jcam.crypto.misc.KeyStoreManager;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.misc.KeyStoreWriter;
import com.cognos.accman.jcam.crypto.misc.KeyStoreWriterExpirer;
import com.cognos.accman.jcam.crypto.misc.KeyStoreWriterExpirerImpl;
import com.cognos.accman.jcam.crypto.misc.PriorityUrlList;
import com.cognos.accman.jcam.crypto.misc.SSLProtocolManager;
import com.cognos.accman.jcam.crypto.misc.SymmetricAlgorithmManager;
import com.cognos.accman.jcam.crypto.xml.GenericTrustedSession;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CAMFactory
extends DefaultAdditionalInfoHandler {
    private IConfiguration configData;
    private boolean bInitialized = false;
    private String serviceID;

    public static void forceNoCM() {
        Configuration.forceNoCM();
    }

    public CAMFactory() {
    }

    public CAMFactory(String ID) throws CAMCryptoException {
        this.initializeWithServiceID(ID);
    }

    public void initializeWithServiceID(String ID) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("initializeWithServiceID", this);
        ipfFunction.addParameter("ID", ID);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                this.initializeImpl(ID);
            }
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("initialize", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("initialize", this).logExit();
    }

    public void initialize(byte[] initDocument) throws CAMCryptoException {
        block4: {
            IPFTraceFunction ipfFunction = new IPFTraceFunction("initialize", this);
            ipfFunction.addParameter("initDocument", new String(initDocument));
            ipfFunction.logEntry();
            ipfFunction = null;
            try {
                if (this.bInitialized) break block4;
                Document doc = null;
                try {
                    doc = CAMCryptoUtilities.parseXml(new ByteArrayInputStream(initDocument));
                }
                catch (DocumentException de) {
                    throw new CAMCryptoException(de, MessageSet.getMessage("CAM_CRP_could_not_parse_initialize_xml"));
                }
                this.initializeImpl(doc.valueOf("/initializeDocument/serviceID/text()"));
            }
            catch (CAMCryptoException e) {
                new IPFAuditFunction("initialize", this).logExit(e);
                throw e;
            }
        }
        new IPFTraceFunction("initialize", this).logExit();
    }

    private void initializeImpl(String serviceId) throws CAMCryptoException {
        Configuration config;
        this.setServiceID(serviceId);
        CAMFactory.checkFIPSSupport(false);
        CryptoProviderManager cpmgr = CryptoProviderManager.getInstance();
        cpmgr.loadJavaSecurityProvider();
        boolean isConfigTool = false;
        if (this.serviceID.compareTo("CNFG") == 0) {
            isConfigTool = true;
        }
        boolean isCFGAPI = false;
        if (this.serviceID.compareTo("CFGAPI") == 0) {
            isCFGAPI = true;
        }
        boolean isIPF = false;
        if (this.serviceID.compareTo("IPF") == 0) {
            isIPF = true;
        }
        this.configData = Configuration.getInstanceWithDefaultConfig(isConfigTool);
        this.configData.setWeAreCFGAPI(isCFGAPI);
        this.configData.setWeAreIPF(isIPF);
        this.configData.setWeAreTheConfigTool(isConfigTool);
        String jvmTrustStorePassword = this.configData.getJVMTrustStorePassword();
        if (jvmTrustStorePassword != null) {
            if (0 != jvmTrustStorePassword.length()) {
                System.setProperty("javax.net.ssl.trustStorePassword", jvmTrustStorePassword);
            }
        } else {
            IPFAuditFunction.warn("Not able to get the configured JVM truststore password.");
        }
        cpmgr.configureSecurityProviders();
        boolean bKeyPairValid = false;
        try {
            bKeyPairValid = this.configData.isIdentityKeyPairValid();
        }
        catch (CAMCryptoException e) {
            if (isConfigTool || isCFGAPI) {
                IPFAuditFunction.trace("Error checking Encryption rollover.Ignore if this is the first install running configuration toolfor first time");
                this.bInitialized = true;
                return;
            }
            throw e;
        }
        if (!bKeyPairValid) {
            if (!this.configData.getUsingThirdPartyCA()) {
                try {
                    KeyExpiryChecker.checkForEncryptionKeyExpiry();
                }
                catch (CAMCryptoException e) {
                    IPFAuditFunction.trace("Error checking Encryption rollover.Ignore if this is the first install running configuration tool for first time");
                }
            } else {
                e = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_encryption_key_expired_using_third_party_ca"));
                e.printStackTrace();
                throw e;
            }
        }
        this.checkPeersURLs(this.configData);
        if (JVMEnvironment.getInstance().isIBMJava() && JVMEnvironment.getJvmVersion() >= 1.7f && 0 == (config = Configuration.getInstance()).getCSKAlgorithm().compareTo("AES")) {
            Properties props = new Properties();
            props.setProperty("com.ibm.crypto.provider.doAESInHardware", "true");
        }
        this.bInitialized = true;
    }

    private void setServiceID(String serviceID) throws CAMCryptoException {
        this.serviceID = serviceID;
        if (this.serviceID == null || this.serviceID.length() == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_no_id_in_initialize_xml"));
        }
    }

    public void initialize(String config) throws CAMCryptoException {
        block28: {
            IPFTraceFunction ipfFunction = new IPFTraceFunction("initialize", this);
            ipfFunction.addParameter("config", config);
            ipfFunction.logEntry();
            ipfFunction = null;
            try {
                File newStore;
                if (this.bInitialized) break block28;
                if (config == null || config.length() <= 0) {
                    throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_no_config"));
                }
                CryptoProviderManager cpmgr = CryptoProviderManager.getInstance();
                cpmgr.loadJavaSecurityProvider();
                Configuration newConfig = Configuration.getInstanceWithConfig(config);
                Configuration.reset();
                IConfiguration oldConfigData = Configuration.getInstanceWithDefaultConfig(true);
                cpmgr.configureSecurityProviders();
                String cskOldPass = oldConfigData.getCSKPassword();
                String caOldPass = null;
                boolean loadedCSK = false;
                boolean loadedCAPair = false;
                boolean loadedEncryptionPair = false;
                try {
                    KeyStoreReader.getCSKWithoutExpiryCheckButWithNoRemoteRequest();
                    loadedCSK = true;
                }
                catch (CAMCryptoException e) {
                    loadedCSK = false;
                    KeyStoreManager.getInstance().resetcskKeyStore();
                }
                try {
                    KeyStoreReader.getCACertificate();
                    loadedCAPair = true;
                }
                catch (CAMCryptoException e) {
                    loadedCAPair = false;
                    KeyStoreManager.getInstance().resetcaKeyStore();
                }
                caOldPass = oldConfigData.getCAKeyPassword();
                Configuration.setDefaultInstance(newConfig);
                cpmgr.configureSecurityProviders();
                boolean bCAChanged = false;
                boolean bIdentityRebuild = false;
                boolean bIsOldCM = oldConfigData.getWeAreCM();
                boolean bIsNewCM = newConfig.getWeAreCM();
                boolean using3rdPartyCA = newConfig.getUsingThirdPartyCA();
                if (!using3rdPartyCA) {
                    long newLifetime;
                    long oldLifetime;
                    String newCADN;
                    String oldCADN;
                    if (bIsOldCM != bIsNewCM) {
                        bCAChanged = true;
                    }
                    if (!(oldCADN = oldConfigData.getCASubjectDN()).equalsIgnoreCase(newCADN = newConfig.getCASubjectDN())) {
                        bCAChanged = true;
                    }
                    if ((oldLifetime = oldConfigData.getCANewCertificateLifetime()) != (newLifetime = newConfig.getCANewCertificateLifetime())) {
                        bCAChanged = true;
                    }
                }
                boolean bCSKalgEqual = true;
                boolean bCSKkeyBitsEqual = true;
                boolean bCSKpwdEqual = true;
                boolean bCSKStays = false;
                if (loadedCSK) {
                    bCSKStays = oldConfigData.getCSKLocation().equalsIgnoreCase(newConfig.getCSKLocation());
                    bCSKalgEqual = oldConfigData.getCSKAlgorithm().equalsIgnoreCase(newConfig.getCSKAlgorithm());
                    bCSKkeyBitsEqual = oldConfigData.getCSKSize() == newConfig.getCSKSize();
                    bCSKpwdEqual = oldConfigData.getCSKPassword().equals(newConfig.getCSKPassword());
                    if (!(!loadedCSK || bCSKalgEqual && bCSKkeyBitsEqual && bCSKpwdEqual && bCSKStays)) {
                        KeyStoreWriter.forceSaveOfCSKKeystore(cskOldPass);
                        KeyStoreManager.getInstance().resetcskKeyStore();
                    }
                }
                boolean bCAStays = true;
                boolean bCAalgEqual = true;
                boolean bCAkeyBitsEqual = true;
                boolean bCApwdEqual = true;
                boolean bDigestAlgEqual = true;
                if (loadedCAPair && newConfig.isStandaloneCA()) {
                    bCAStays = oldConfigData.getCAMKeystoreLocation().equalsIgnoreCase(newConfig.getCAMKeystoreLocation());
                    bCAalgEqual = oldConfigData.getCAKeyPairAlgorithm().equalsIgnoreCase(newConfig.getCAKeyPairAlgorithm()) && oldConfigData.getDigestAlgorithm().equalsIgnoreCase(newConfig.getDigestAlgorithm());
                    bCAkeyBitsEqual = CAMCryptoUtilities.getAsymmetricKeyBits(KeyStoreReader.getCACertificate().getPublicKey()) == newConfig.getCAKeyPairSize();
                    bCApwdEqual = oldConfigData.getCAKeyPassword().equals(newConfig.getCAKeyPassword());
                    if (!(bCAalgEqual && bCAkeyBitsEqual && bCApwdEqual && bCAStays && !bCAChanged)) {
                        KeyStoreWriter.forceSaveOfCAKeystore(caOldPass);
                        KeyStoreManager.getInstance().resetcaKeyStore();
                    }
                    if (!bCAalgEqual || !bCAkeyBitsEqual) {
                        bCAChanged = true;
                    }
                }
                try {
                    X509Certificate encryptionCertificate = (X509Certificate)KeyStoreReader.getEncryptionCertificate();
                    bIdentityRebuild = CAMCryptoUtilities.isCertificateConfigurationChanged(encryptionCertificate);
                    bDigestAlgEqual = oldConfigData.getDigestAlgorithm().equalsIgnoreCase(newConfig.getDigestAlgorithm());
                    if (!bDigestAlgEqual || bCAChanged) {
                        KeyStoreWriter.forceSaveOfCAKeystore(caOldPass);
                        KeyStoreManager.getInstance().resetencKeyStore();
                    } else if (bIdentityRebuild) {
                        KeyStoreWriter.updateEncryptionKeyPair();
                    }
                }
                catch (CAMCryptoException e) {
                    loadedEncryptionPair = false;
                    KeyStoreManager.getInstance().resetencKeyStore();
                }
                KeyStoreManager.getInstance().resetcmCSKStore();
                if (loadedCSK && loadedCSK && (!bCSKalgEqual || !bCSKkeyBitsEqual)) {
                    KeyStoreWriter.expireCsk();
                }
                KeyStoreWriterExpirerImpl expirer = new KeyStoreWriterExpirerImpl();
                this.maybeExpireKeyPairs(loadedCAPair, loadedEncryptionPair, bCAChanged, bIdentityRebuild, bCAalgEqual, bCAkeyBitsEqual, bDigestAlgEqual, using3rdPartyCA, expirer);
                File oldStore = new File(oldConfigData.getCSKLocation());
                if (!bCSKStays) {
                    oldStore.delete();
                    new File(oldStore.getAbsolutePath() + ".lock").delete();
                    oldStore.getParentFile().delete();
                }
                if (!(oldStore = new File(oldConfigData.getCSKLocationForCPP())).equals(newStore = new File(newConfig.getCSKLocationForCPP()))) {
                    oldStore.delete();
                    new File(oldStore.getAbsolutePath() + ".lock").delete();
                    oldStore.getParentFile().delete();
                }
                oldStore = new File(oldConfigData.getCAMKeystoreLocation());
                if (!bCAStays) {
                    oldStore.delete();
                    new File(oldStore.getAbsolutePath() + ".lock").delete();
                    oldStore.getParentFile().delete();
                }
                try {
                    CaSyncHandler cash;
                    KeyStoreReader.getSigningCertificate();
                    if (!newConfig.getUsingThirdPartyCA() && !newConfig.isMDMRunning() && (cash = CaSyncHandler.getInstance()).isSameTrustRoot()) {
                        cash.synchronizeCaCerts();
                    }
                }
                catch (CAMCryptoException e) {
                    IPFTraceFunction.trace("Error no jCAKeystore.Bypassing CA synchronization");
                }
                this.checkPeersURLs(newConfig);
                this.configData = newConfig;
                this.configData.setWeAreTheConfigTool(true);
                this.bInitialized = true;
            }
            catch (CAMCryptoException e) {
                new IPFAuditFunction("initialize", this).logExit(e);
                throw e;
            }
        }
        new IPFTraceFunction("initialize", this).logExit();
    }

    public void maybeExpireKeyPairs(boolean loadedCAPair, boolean loadedEncryptionPair, boolean bCAChanged, boolean bIdentityRebuild, boolean bCAalgEqual, boolean bCAkeyBitsEqual, boolean bDigestAlgEqual, boolean using3rdPartyCA, KeyStoreWriterExpirer expirer) throws CAMCryptoException {
        if (!using3rdPartyCA) {
            if (loadedCAPair && (!bCAalgEqual || !bCAkeyBitsEqual || bCAChanged)) {
                expirer.expireCAKeyPair();
            }
            if (loadedEncryptionPair && (!bDigestAlgEqual || bCAChanged) && bIdentityRebuild) {
                expirer.expireEncryptKeyPair();
            }
        }
    }

    public long CheckCertificateExpiry(Certificate certificate) throws CAMCryptoException {
        X509Certificate x509Cert = (X509Certificate)certificate;
        Date expireDate = x509Cert.getNotAfter();
        Date now = new Date();
        long milliseconds = expireDate.getTime() - now.getTime();
        long seconds = milliseconds / 1000L;
        return seconds;
    }

    public void terminate() {
        new IPFTraceFunction("terminate", this).logEntry();
        new IPFTraceFunction("terminate", this).logExit();
    }

    public ConfiguringSession createConfiguringSession() throws CAMCryptoException {
        new IPFTraceFunction("createConfiguringSession", this).logEntry();
        ConfiguringSession cs = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            cs = new ConfiguringSession(this.serviceID);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createConfiguringSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createConfiguringSession", this).logExit(cs);
        return cs;
    }

    public CipherOutputStream createCipherOutputStream(String fileName) throws CAMCryptoException, FileNotFoundException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("initialize", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            CipherOutputStream cos = CAMCipherStreamFactory.CreateCipherOutputStream(fileName);
            new IPFTraceFunction("createCipherOutputStream", this).logExit(cos);
            return cos;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createCipherOutputStream", this).logExit();
            throw e;
        }
    }

    public CipherInputStream createCipherInputStream(String fileName) throws CAMCryptoException, FileNotFoundException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createCipherInputStream", this);
        ipfFunction.addParameter("inputStream", fileName);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            CipherInputStream cis = CAMCipherStreamFactory.CreateCipherInputStream(fileName);
            new IPFTraceFunction("createCipherInputStream", this).logExit(cis);
            return cis;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createCipherInputStream", this).logExit(e);
            throw e;
        }
    }

    public CipherOutputStream createEncryptingOutputStream(OutputStream os) throws CAMCryptoException {
        CipherOutputStream cos;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("initialize", this);
        ipfFunction.addParameter("outputStream", os);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            Cipher c;
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            SecretKey csk = KeyStoreReader.getCSKWithExpiryCheck();
            String alg = csk.getAlgorithm();
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            try {
                if (alg.equalsIgnoreCase("RC2")) {
                    SecureRandom random = JVMEnvironment.getInstance().getSecureRandom();
                    byte[] iv = new byte[8];
                    random.nextBytes(iv);
                    c = Cipher.getInstance("RC2/CBC/PKCS7Padding", jceProvider);
                    c.init(1, (Key)csk, new RC2ParameterSpec(csk.getEncoded().length * 8, iv));
                } else {
                    c = Cipher.getInstance(alg, jceProvider);
                    c.init(1, csk);
                }
                AlgorithmParameters param = c.getParameters();
                os.write(alg.length());
                os.write(alg.getBytes());
                if (param == null) {
                    os.write(0);
                } else {
                    os.write(param.getEncoded().length);
                    os.write(param.getEncoded());
                }
                os.write(CAMCryptoUtilities.getCSKDigestLength());
                os.write(CAMCryptoUtilities.digestCSK(csk));
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_cipher_obj"));
            }
            cos = new CipherOutputStream(os, c);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createEncryptingOutputStream", this).logExit();
            throw e;
        }
        new IPFTraceFunction("createEncryptingOutputStream", this).logExit(cos);
        return cos;
    }

    public CipherInputStream createDecryptingInputStream(InputStream is) throws CAMCryptoException {
        CipherInputStream cis;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createDecryptingInputStream", this);
        ipfFunction.addParameter("inputStream", is);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            Cipher c;
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            try {
                int size;
                int len;
                int size2;
                int algLen = is.read();
                byte[] alg = new byte[algLen];
                int off = 0;
                for (len = algLen; len > 0; len -= size2) {
                    size2 = is.read(alg, off, len);
                    off += size2;
                }
                int paramsLen = is.read();
                byte[] params = null;
                if (paramsLen > 0) {
                    int size3;
                    params = new byte[paramsLen];
                    off = 0;
                    for (len = paramsLen; len > 0; len -= size3) {
                        size3 = is.read(params, off, len);
                        off += size3;
                    }
                }
                int digestLen = is.read();
                byte[] digest = new byte[digestLen];
                off = 0;
                for (len = digestLen; len > 0; len -= size) {
                    size = is.read(digest, off, len);
                    off += size;
                }
                SecretKey csk = KeyStoreReader.getCSKGivenCSKDigest(digest);
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                if (params != null) {
                    AlgorithmParameters algParams = AlgorithmParameters.getInstance(new String(alg), "BC");
                    algParams.init(params);
                    if (csk.getAlgorithm().startsWith("RC2")) {
                        RC2ParameterSpec rc2spec = algParams.getParameterSpec(RC2ParameterSpec.class);
                        byte[] iv = rc2spec.getIV();
                        c = Cipher.getInstance("RC2/CBC/PKCS7Padding", jceProvider);
                        c.init(2, (Key)csk, new RC2ParameterSpec(csk.getEncoded().length * 8, iv));
                    } else {
                        c = Cipher.getInstance(new String(alg));
                        c.init(2, (Key)csk, algParams);
                    }
                } else {
                    c = Cipher.getInstance(new String(alg), jceProvider);
                    if (csk.getAlgorithm().startsWith("RC2")) {
                        c.init(2, (Key)csk, new RC2ParameterSpec(csk.getEncoded().length * 8));
                    } else {
                        c.init(2, csk);
                    }
                }
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_cipher_obj"));
            }
            cis = new CipherInputStream(is, c);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createDecryptingInputStream", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createDecryptingInputStream", this).logExit(cis);
        return cis;
    }

    public TmpCipherStreamSession createTmpCipherStreamSession() throws CAMCryptoException {
        TmpCipherStreamSession tess;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createTmpEncryptingSession", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            tess = new TmpCipherStreamSession();
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createTmpEncryptingSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createTmpEncryptingSession", this).logExit(tess);
        return tess;
    }

    public DeploymentCipherStreamSession createDeploymentCipherStreamSession(byte[] password) throws CAMCryptoException {
        DeploymentCipherStreamSession dcss;
        byte[] passwd;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createDeploymentCipherStreamSession", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            byte[] encpasswd = CryptoWrapper.decodeBase64(password);
            EncryptingSession es = this.createEncryptingSession();
            passwd = es.decryptData(encpasswd);
        }
        catch (CAMCryptoException e) {
            CAMCryptoException ee = new CAMCryptoException("The password is incorrectly base64 encoded or is not encrypted with Common Symmetric Key (CSK).");
            new IPFAuditFunction("createDeploymentCipherStreamSession", this).logExit(e);
            throw ee;
        }
        try {
            dcss = new DeploymentCipherStreamSession(passwd);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createDeploymentCipherStreamSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createDeploymentCipherStreamSession", this).logExit(dcss);
        return dcss;
    }

    public EncryptingSession createEncryptingSession() throws CAMCryptoException {
        EncryptingSession es;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createEncryptingSession", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            es = new EncryptingSession(this.serviceID);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createEncryptingSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createEncryptingSession", this).logExit(es);
        return es;
    }

    public SystemProtectionSession createSystemProtectionSession() throws CAMCryptoException {
        CryptoProviderManager cpmgr = CryptoProviderManager.getInstance();
        cpmgr.loadJavaSecurityProvider();
        SystemProtectionSession sps = new SystemProtectionSession();
        return sps;
    }

    public SigningSession createSigningSession() throws CAMCryptoException {
        SigningSession ss;
        new IPFTraceFunction("createSigningSession", this).logEntry();
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            ss = new SigningSession(this.serviceID);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSigningSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createSigningSession", this).logExit(ss);
        return ss;
    }

    public FileSignatureSession createFileSignatureSession() throws CAMCryptoException {
        FileSignatureSession fileSignatureSession;
        new IPFTraceFunction("createLicenseSignatureSession", this).logEntry();
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            fileSignatureSession = new FileSignatureSession(this.serviceID);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createLicenseSignatureSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createLicenseSignatureSession", this).logExit(fileSignatureSession);
        return fileSignatureSession;
    }

    public SSLContext createSSLContext() throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("creategetSSLContext", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        SSLContext sslctx = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            sslctx = JVMEnvironment.getInstance().getSSLContext();
        }
        catch (Exception e) {
            new IPFAuditFunction("createSSLContext", this).logExit(e);
            throw new CAMCryptoException(e);
        }
        new IPFTraceFunction("createSSLContext", this).logExit();
        return sslctx;
    }

    public Socket createSocket() throws CAMCryptoException {
        Socket s;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createSocket", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            URL peer = this.configData.getPeer();
            s = this.createSocket(peer.getHost(), peer.getPort(), this.configData.isPeerConnectionSSL());
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createSocket", this).logExit(s);
        return s;
    }

    public Socket createSocket(String host, int port) throws CAMCryptoException {
        Socket s;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createSocket", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            s = this.createSocket(host, port, this.configData.isHostConnectionSSL(host, port));
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createSocket", this).logExit(s);
        return s;
    }

    public Socket createSocket(String host, int port, boolean secure) throws CAMCryptoException {
        Socket s;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createSocket", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.addParameter("secure", secure);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            InetAddress ia = null;
            try {
                ia = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_peer_unknown", new String[]{host + ":" + Integer.toString(port)}));
            }
            s = this.createSocket(ia, port, secure);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createSocket", this).logExit(s);
        return s;
    }

    public Socket createSocket(InetAddress host, int port) throws CAMCryptoException {
        Socket s;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createSocket", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            s = this.createSocket(host, port, this.configData.isHostConnectionSSL(host.getHostName(), port));
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createSocket", this).logExit(s);
        return s;
    }

    public Socket createSocket(URL url) throws CAMCryptoException {
        Socket s;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createSocket", this);
        ipfFunction.addParameter("url", url);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            int port = url.getPort();
            String host = url.getHost();
            InetAddress ia = null;
            try {
                ia = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_peer_unknown", new String[]{host + ":" + Integer.toString(port)}));
            }
            String proto = url.getProtocol();
            boolean secure = false;
            if (proto.equalsIgnoreCase("https")) {
                secure = true;
            }
            s = this.createSocket(ia, port, secure);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createSocket", this).logExit(s);
        return s;
    }

    public Socket createSocket(InetAddress host, int port, boolean secure) throws CAMCryptoException {
        Socket s;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createSocket", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.addParameter("secure", secure);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            try {
                if (!this.bInitialized) {
                    throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
                }
                if (secure) {
                    Configuration config = Configuration.getInstance();
                    CAMSSLSocketFactory _socketFactory = config.getCAMSSLSocketFactory();
                    s = _socketFactory.createSocket(host, port);
                    SSLSocket ss = (SSLSocket)s;
                    ss.setEnabledCipherSuites(config.getJSSECipherSuitesList());
                    ss.setEnabledProtocols(config.getSSLProtocols());
                } else {
                    s = new Socket(host, port);
                }
            }
            catch (UnknownHostException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_peer_unknown", new String[]{host + ":" + Integer.toString(port)}));
            }
            catch (Exception e) {
                throw new CAMCryptoException(e);
            }
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createSocket", this).logExit(s);
        return s;
    }

    public SocketFactory createSocketFactory(boolean secure) throws CAMCryptoException {
        SocketFactory sf = null;
        try {
            try {
                if (!this.bInitialized) {
                    throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
                }
                sf = secure ? JVMEnvironment.getInstance().getSSLSocketFactory() : SocketFactory.getDefault();
            }
            catch (Exception e) {
                throw new CAMCryptoException(e);
            }
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSocketFactory", this).logExit(e);
            throw e;
        }
        return sf;
    }

    public ServerSocket createServerSocket(int port) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createServerSocket", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        ServerSocket s = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            s = this.createServerSocket(port, 3, this.configData.isPeerConnectionSSL());
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createServerSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createServerSocket", this).logExit(s);
        return s;
    }

    public ServerSocket createServerSocket(int port, boolean secure) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createServerSocket", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        ServerSocket s = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            s = this.createServerSocket(port, 3, secure);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createServerSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createServerSocket", this).logExit(s);
        return s;
    }

    public ServerSocket createMutualAuthServerSocket(int port) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createMutualAuthServerSocket", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        ServerSocket s = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            SSLServerSocketFactory sslSrvrSockFactory = JVMEnvironment.getInstance().getSSLServerSocketFactory();
            s = sslSrvrSockFactory.createServerSocket(port, 3);
            SSLServerSocket sss = (SSLServerSocket)s;
            sss.setNeedClientAuth(true);
            Configuration config = Configuration.getInstance();
            sss.setEnabledCipherSuites(config.getJSSECipherSuitesList());
            sss.setEnabledProtocols(config.getSSLProtocols());
        }
        catch (Exception e) {
            new IPFAuditFunction("createMutualAuthServerSocket", this).logExit(e);
            throw new CAMCryptoException(e);
        }
        new IPFTraceFunction("createMutualAuthServerSocket", this).logExit(s);
        return s;
    }

    public ServerSocket createServerSocket(int port, int backlog) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createServerSocket", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        ServerSocket s = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            s = this.createServerSocket(port, backlog, this.configData.areServerConnectionsSSL());
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createServerSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createServerSocket", this).logExit(s);
        return s;
    }

    public ServerSocket createServerSocket(int port, int backlog, boolean secure) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createServerSocket", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        ServerSocket s = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            s = this.createServerSocket(port, backlog, null, secure);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createServerSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createServerSocket", this).logExit(s);
        return s;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createServerSocket", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        ServerSocket s = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            s = this.createServerSocket(port, backlog, bindAddr, this.configData.areServerConnectionsSSL());
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createServerSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createServerSocket", this).logExit(s);
        return s;
    }

    public ServerSocket createServerSocket(URL url) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createServerSocket", this);
        ipfFunction.addParameter("url", url);
        ipfFunction.logEntry();
        ipfFunction = null;
        ServerSocket s = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            int port = url.getPort();
            String host = url.getHost();
            InetAddress ia = null;
            try {
                ia = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_peer_unknown", new String[]{host + ":" + Integer.toString(port)}));
            }
            String proto = url.getProtocol();
            boolean secure = false;
            if (proto.equalsIgnoreCase("https")) {
                secure = true;
            }
            s = this.createServerSocket(port, 3, ia, secure);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createServerSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createServerSocket", this).logExit(s);
        return s;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr, boolean secure) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createServerSocket", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        ServerSocket s = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            if (secure) {
                SSLServerSocketFactory sslSrvrSockFactory = JVMEnvironment.getInstance().getSSLServerSocketFactory();
                s = bindAddr != null ? sslSrvrSockFactory.createServerSocket(port, backlog, bindAddr) : sslSrvrSockFactory.createServerSocket(port, backlog);
                Configuration config = Configuration.getInstance();
                SSLServerSocket sss = (SSLServerSocket)s;
                sss.setNeedClientAuth(config.useMutualAuthentication());
                sss.setEnabledCipherSuites(config.getJSSECipherSuitesList());
                sss.setEnabledProtocols(config.getSSLProtocols());
            } else {
                s = new ServerSocket(port, backlog, bindAddr);
            }
        }
        catch (Exception e) {
            new IPFAuditFunction("createServerSocket", this).logExit(e);
            throw new CAMCryptoException(e);
        }
        new IPFTraceFunction("createServerSocket", this).logExit(s);
        return s;
    }

    public Socket createSocket(String pkcs12File, String pkcs12FilePassword, InetAddress host, int port, boolean secure) throws CAMCryptoException, CertificateExpiredException, CertificateNotYetValidException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createSocket", this);
        ipfFunction.addParameter("pkcs12File", pkcs12File);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.addParameter("secure", secure);
        ipfFunction.logEntry();
        ipfFunction = null;
        if (!this.bInitialized) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
        }
        Socket s = null;
        try {
            Configuration config = Configuration.getInstance();
            if (secure) {
                CAMSSLSocketFactory _socketFactory = config.getPKCS12SSLSocketFactory(pkcs12File, pkcs12FilePassword);
                s = _socketFactory.createSocket(host, port);
                SSLSocket ss = (SSLSocket)s;
                ss.setEnabledCipherSuites(config.getJSSECipherSuitesList());
                ss.setEnabledProtocols(config.getSSLProtocols());
            } else {
                s = new Socket(host, port);
            }
        }
        catch (UnknownHostException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_peer_unknown", new String[]{host + ":" + Integer.toString(port)}));
        }
        catch (IOException e) {
            throw new CAMCryptoException(e);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSocket", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createSocket", this).logExit(s);
        return s;
    }

    public ServerSocket createServerSocket(String pkcs12File, String pkcs12FilePassword, InetAddress bindAddr, int port, int backlog, boolean secure) throws CAMCryptoException, CertificateExpiredException, CertificateNotYetValidException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createServerSocket", this);
        ipfFunction.addParameter("pkcs12File", pkcs12File);
        ipfFunction.addParameter("bindAddr", bindAddr.getHostName());
        ipfFunction.addParameter("port", port);
        ipfFunction.addParameter("backlog", backlog);
        ipfFunction.addParameter("secure", secure);
        ipfFunction.logEntry();
        ipfFunction = null;
        if (!this.bInitialized) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
        }
        ServerSocket s = null;
        try {
            if (secure) {
                SSLServerSocketFactory sslSrvrSockFactory = JVMEnvironment.getInstance().getPKCS12SSLServerSocketFactory(pkcs12File, pkcs12FilePassword);
                s = bindAddr != null ? sslSrvrSockFactory.createServerSocket(port, backlog, bindAddr) : sslSrvrSockFactory.createServerSocket(port, backlog);
                SSLServerSocket sss = (SSLServerSocket)s;
                Configuration config = Configuration.getInstance();
                sss.setNeedClientAuth(config.useMutualAuthentication());
                sss.setEnabledCipherSuites(config.getJSSECipherSuitesList());
                sss.setEnabledProtocols(config.getSSLProtocols());
            } else {
                s = new ServerSocket(port, backlog, bindAddr);
            }
        }
        catch (IOException e) {
            new IPFAuditFunction("createServerSocket", this).logExit(e);
            throw new CAMCryptoException(e);
        }
        new IPFTraceFunction("createServerSocket", this).logExit(s);
        return s;
    }

    public TrustedRequestSession createTrustedSession() throws CAMCryptoException {
        TrustedRequestSession ts;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("TrustedRequestSession", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            ts = new TrustedRequestSession(this.serviceID);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("TrustedRequestSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("TrustedRequestSession", this).logExit(ts);
        return ts;
    }

    public BATrustedRequestSession createBATrustedSession() throws CAMCryptoException {
        BATrustedRequestSession bats;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("BATrustedRequestSession", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            bats = new BATrustedRequestSession();
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("TrustedRequestSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("TrustedRequestSession", this).logExit(bats);
        return bats;
    }

    public GenericTrustedSession createGenericTrustedSession() throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("GenericTrustedSession", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        GenericTrustedSession gts = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            gts = new GenericTrustedSession(this.serviceID);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("GenericTrustedSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("GenericTrustedSession", this).logExit(gts);
        return gts;
    }

    public HttpClientFactory createHttpClientFactory() throws CAMCryptoException {
        HttpClientFactory hcf;
        new IPFTraceFunction("createHttpClientFactory", this).logEntry();
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            hcf = new HttpClientFactory(this.configData);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClientFactory", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClientFactory", this).logExit(hcf);
        return hcf;
    }

    public HttpConnection createHttpConnection() throws CAMCryptoException {
        HttpConnection hc;
        new IPFTraceFunction("createHttpConnection", this).logEntry();
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            URL urlPeer = this.configData.getPeer();
            hc = HttpClientInitializer.getInstance().createHttpConnection(urlPeer.getHost(), urlPeer.getPort(), this.configData.isPeerConnectionSSL());
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpConnection", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpConnection", this).logExit(hc);
        return hc;
    }

    public HttpConnection createHttpConnection(String host, int port, boolean secure) throws CAMCryptoException {
        HttpConnection hc;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpConnection", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.addParameter("secure", secure);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            hc = HttpClientInitializer.getInstance().createHttpConnection(host, port, secure);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpConnection", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpConnection", this).logExit(hc);
        return hc;
    }

    public HttpConnection createHttpConnection(URL url) throws CAMCryptoException {
        HttpConnection hc;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpConnection", this);
        ipfFunction.addParameter("url", url);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            hc = HttpClientInitializer.getInstance().createHttpConnection(url);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpConnection", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpConnection", this).logExit(hc);
        return hc;
    }

    public HttpClient createHttpClient() throws CAMCryptoException {
        HttpClient hc;
        new IPFTraceFunction("createHttpClient", this).logEntry();
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            URL urlPeer = this.configData.getPeer();
            hc = HttpClientInitializer.getInstance().createHttpClient(urlPeer.getHost(), urlPeer.getPort(), this.configData.isPeerConnectionSSL());
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClient", this).logExit(hc);
        return hc;
    }

    public HttpClient createHttpClient(String host, int port) throws CAMCryptoException {
        HttpClient hc;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpClient", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            hc = this.createHttpClient(host, port, this.configData.isHostConnectionSSL(host, port));
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClient", this).logExit(hc);
        return hc;
    }

    public HttpClient createHttpClient(InetAddress host, int port) throws CAMCryptoException {
        HttpClient hc;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpClient", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            String hostname = host.getHostName();
            hc = this.createHttpClient(hostname, port, this.configData.isHostConnectionSSL(host.getHostName(), port));
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClient", this).logExit(hc);
        return hc;
    }

    public HttpClient createHttpClient(String host, int port, boolean secure) throws CAMCryptoException {
        HttpClient hc;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpClient", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.addParameter("secure", secure);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            hc = HttpClientInitializer.getInstance().createHttpClient(host, port, secure);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClient", this).logExit(hc);
        return hc;
    }

    public HttpClient createSecurePooledHttpClient(String host, int port) throws CAMCryptoException {
        HttpClient hc;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createSecurePooledHttpClient", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            hc = HttpClientInitializer.getInstance().createSecurePooledHttpClient(host, port);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSecurePooledHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createSecurePooledHttpClient", this).logExit(hc);
        return hc;
    }

    public HttpClient createHttpClient(InetAddress host, int port, boolean secure) throws CAMCryptoException {
        HttpClient hc;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpClient", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.addParameter("secure", secure);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            String hostname = host.getHostName();
            hc = HttpClientInitializer.getInstance().createHttpClient(hostname, port, secure);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClient", this).logExit(hc);
        return hc;
    }

    public HttpClient createHttpClient(URL url) throws CAMCryptoException {
        HttpClient hc;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpClient", this);
        ipfFunction.addParameter("url", url);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            hc = HttpClientInitializer.getInstance().createHttpClient(url);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClient", this).logExit(hc);
        return hc;
    }

    public CSKRequestHandler createCSKRequestHandler() throws CAMCryptoException {
        CSKRequestHandler crh;
        new IPFTraceFunction("createCSKRequestHandler", this).logEntry();
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            crh = new CSKRequestHandler(this.serviceID);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createCSKRequestHandler", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createCSKRequestHandler", this).logExit(crh);
        return crh;
    }

    public CARequestHandler createCARequestHandler() throws CAMCryptoException {
        CARequestHandler carh;
        new IPFTraceFunction("createCARequestHandler", this).logEntry();
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            carh = new CARequestHandler(this.serviceID);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createCARequestHandler", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createCARequestHandler", this).logExit(carh);
        return carh;
    }

    public static Element getSSLProtocols(String sProviderType, Locale locale) throws CAMCryptoException {
        IPFTraceFunction.trace("Calling CAMFactory.getSSLProtocols: Provider Type =" + sProviderType);
        Element elem = null;
        try {
            SSLProtocolManager sslProtocolManager = new SSLProtocolManager();
            elem = sslProtocolManager.getSupportedSSLProtocolsDOM();
        }
        catch (CAMCryptoException e) {
            IPFTraceFunction.fatalException("CAMFactory.getSSLProtocolss failed at CAMCryptoException: " + e.getMessage());
            return DocumentHelper.createDocument().addElement("values");
        }
        catch (Exception e) {
            IPFTraceFunction.fatalException("CAMFactory.getSSLProtocolss failed at Exception: " + e.getMessage());
            return DocumentHelper.createDocument().addElement("values");
        }
        IPFTraceFunction.trace("CAMFactory.getSSLProtocolss: completed successfully");
        return elem;
    }

    public static Element getCiphersuites(String sProviderType, Locale locale) throws CAMCryptoException {
        IPFTraceFunction.trace("getCiphersuites: Provider Type =" + sProviderType);
        IPFTraceFunction.trace("getCiphersuites: locale =" + locale);
        Element elem = null;
        try {
            if (sProviderType == null || locale == null) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
            }
            JVMEnvironment jvmEnv = new JVMEnvironment(null, sProviderType);
            try {
                jvmEnv.addJSSESecurityProvider();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CipherSuiteManager csm = new CipherSuiteManager(jvmEnv);
            elem = csm.getSupportedCiphersuitesDOM(sProviderType);
        }
        catch (CAMCryptoException e) {
            IPFTraceFunction.trace("getCiphersuites: exit  =" + e.getMessage());
            return DocumentHelper.createDocument().addElement("values");
        }
        IPFTraceFunction.trace("getSymmetricCryptoAlgorithms: exit");
        return elem;
    }

    public static Element getDefaultCiphersuites(String sProviderType, Locale locale) throws CAMCryptoException {
        IPFTraceFunction.trace("getDefaultCiphersuites: Provider Type =" + sProviderType);
        IPFTraceFunction.trace("getDefaultCiphersuites: locale =" + locale);
        Element elem = null;
        try {
            if (sProviderType == null || locale == null) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
            }
            JVMEnvironment jvmEnv = new JVMEnvironment(null, sProviderType);
            try {
                jvmEnv.addJSSESecurityProvider();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CipherSuiteManager csm = new CipherSuiteManager(jvmEnv);
            elem = csm.getDefaultCiphersuitesDOM(sProviderType);
        }
        catch (CAMCryptoException e) {
            IPFTraceFunction.trace("getDefaultCiphersuites: exit  =" + e.getMessage());
            return DocumentHelper.createDocument().addElement("values");
        }
        IPFTraceFunction.trace("getDefaultCiphersuites: exit");
        return elem;
    }

    public static Element getDefaultCiphersuiteConfiguration(ArrayList<String> mergeCiphersuiteList, Locale locale) throws CAMCryptoException {
        IPFTraceFunction.trace("getDefaultCiphersuites: locale = " + locale);
        if (mergeCiphersuiteList != null) {
            IPFTraceFunction.trace("getDefaultCiphersuites: merge cipher suite list = " + mergeCiphersuiteList.toString());
        } else {
            IPFTraceFunction.trace("getDefaultCiphersuites: merge cipher suite list = null");
        }
        Element elem = null;
        try {
            JVMEnvironment jvmEnv = new JVMEnvironment(null, null);
            try {
                jvmEnv.addJSSESecurityProvider();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CipherSuiteManager csm = new CipherSuiteManager(jvmEnv);
            elem = csm.getDefaultCiphersuitesDOM(mergeCiphersuiteList);
        }
        catch (CAMCryptoException e) {
            IPFTraceFunction.trace("getDefaultCiphersuites: exit  =" + e.getMessage());
            return DocumentHelper.createDocument().addElement("values");
        }
        IPFTraceFunction.trace("getDefaultCiphersuites: call completed");
        return elem;
    }

    public static Element getDigestAlgorithms(String sProviderType, Locale locale) throws CAMCryptoException {
        IPFTraceFunction.trace("getDigestAlgorithms: Provider Type =" + sProviderType);
        IPFTraceFunction.trace("getDigestAlgorithms: locale =" + locale);
        Element elem = null;
        try {
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            if (sProviderType != null && sProviderType.compareToIgnoreCase("CognosFIPS") == 0) {
                jceProvider = "IBMJCEFIPS";
            } else if (jceProvider.compareTo("SunJCE") == 0) {
                jceProvider = "SUN";
            }
            DigestAlgorithmManager dam = new DigestAlgorithmManager();
            elem = dam.getSupportedDigestAlgorithmDOM(jceProvider);
        }
        catch (CAMCryptoException e) {
            IPFTraceFunction.trace("getDigestAlgorithms: exit  = " + e.getMessage());
            throw e;
        }
        IPFTraceFunction.trace("getDigestAlgorithms: exit");
        return elem;
    }

    public static Element getDigestAlgorithmsFromAllSecurityProviders(String sProviderType, Locale locale) throws CAMCryptoException {
        IPFTraceFunction.trace("getDigestAlgorithms: Provider Type =" + sProviderType);
        IPFTraceFunction.trace("getDigestAlgorithms: locale =" + locale);
        Element elem = null;
        try {
            if (sProviderType == null || locale == null) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
            }
            DigestAlgorithmManager dam = new DigestAlgorithmManager();
            elem = dam.getSupportedDigestAlgorithmDOM();
        }
        catch (CAMCryptoException e) {
            IPFTraceFunction.trace("getDigestAlgorithms: exit  =" + e.getMessage());
            throw e;
        }
        IPFTraceFunction.trace("getDigestAlgorithms: exit");
        return elem;
    }

    public static Element getSymmetricCryptoAlgorithms(String sProviderType, Locale locale) throws CAMCryptoException {
        IPFTraceFunction.trace("getSymmetricCryptoAlgorithms: Provider Type =" + sProviderType);
        IPFTraceFunction.trace("getSymmetricCryptoAlgorithms: locale =" + locale);
        Element elem = null;
        try {
            if (sProviderType == null || locale == null) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
            }
            SymmetricAlgorithmManager sam = new SymmetricAlgorithmManager();
            elem = sam.getSupportedSymmetricAlgsDOM(sProviderType, locale.toString());
        }
        catch (CAMCryptoException e) {
            IPFTraceFunction.trace("getSymmetricCryptoAlgorithms: exit  =" + e.getMessage());
            throw e;
        }
        IPFTraceFunction.trace("getSymmetricCryptoAlgorithms: exit");
        return elem;
    }

    public static Element getPDFCryptoAlgorithms(String sProviderType, Locale locale) throws CAMCryptoException {
        IPFTraceFunction.trace("getSymmetricCryptoAlgorithms: Provider Type =" + sProviderType);
        IPFTraceFunction.trace("getSymmetricCryptoAlgorithms: locale =" + locale);
        Element elem = null;
        try {
            if (sProviderType == null || locale == null) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
            }
            SymmetricAlgorithmManager sam = new SymmetricAlgorithmManager();
            elem = sam.getSupportedPDFAlgsDOM(sProviderType, locale.toString());
        }
        catch (CAMCryptoException e) {
            IPFTraceFunction.trace("getPDFCryptoAlgorithms: exit  =" + e.getMessage());
            throw e;
        }
        IPFTraceFunction.trace("getSymmetricCryptoAlgorithms: exit");
        return elem;
    }

    public static void checkFIPSSupport() throws CAMCryptoException {
        CAMFactory.checkFIPSSupport(true);
    }

    private static void checkFIPSSupport(boolean isConfigTool) throws CAMCryptoException {
        if (IPFTraceFunction.isEnabled()) {
            new IPFTraceFunction("checkFIPSSupport").logEntry();
        }
        JVMEnvironment.getInstance().isFIPSSupportedOS(isConfigTool);
        if (JVMEnvironment.getInstance().isFIPSEnabled()) {
            IPFAuditFunction.logFIPSMode();
        }
        if (IPFTraceFunction.isEnabled()) {
            new IPFTraceFunction("checkFIPSSupport").logExit();
        }
    }

    public DSServiceAccessSession createDSServiceAccessSession() throws CAMCryptoException {
        new IPFTraceFunction("createDSServiceAccessSession", this).logEntry();
        DSServiceAccessSession dssas = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            dssas = new DSServiceAccessSession();
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createDSServiceAccessSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createDSServiceAccessSession", this).logExit(dssas);
        return dssas;
    }

    public CMDRTEncryptingSession createCMDRTEncryptingSession() throws CAMCryptoException {
        CMDRTEncryptingSession ces;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createCMDRTEncryptingSession", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            ces = new CMDRTEncryptingSession(this.serviceID);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createCMDRTEncryptingSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createCMDRTEncryptingSession", this).logExit(ces);
        return ces;
    }

    public GenericHMACSession createGenericHMACSession(byte[] password) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createGenericHMACSession", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        GenericHMACSession ghs = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            ghs = new GenericHMACSession(password);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createGenericHMACSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createGenericHMACSession", this).logExit(ghs);
        return ghs;
    }

    public ReportSpecProtectionSession createReportSpecProtectionSession() throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createGenericCSKHMACSession", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        ReportSpecProtectionSession rsps = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            rsps = new ReportSpecProtectionSession();
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createGenericCSKHMACSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createGenericCSKHMACSession", this).logExit(rsps);
        return rsps;
    }

    public SecureStateSession createSecureStateSession(byte[] passport) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createSecureStateSession", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        SecureStateSession sss = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            sss = new SecureStateSession(passport);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSecureStateSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createSecureStateSession", this).logExit(sss);
        return sss;
    }

    public SecureStateSession createSecureStateSession(byte[] passport, byte[] token) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createSecureStateSession", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        SecureStateSession sss = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            sss = new SecureStateSession(passport, token);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createSecureStateSession", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createSecureStateSession", this).logExit(sss);
        return sss;
    }

    public UserSessionIDSession createUserSessionIDSession() throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createUserSessionIDSession", this);
        ipfFunction.logEntry();
        UserSessionIDSession usIDSession = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            usIDSession = new UserSessionIDSession();
        }
        catch (CAMCryptoException e) {
            ipfFunction.logExit(e);
            throw e;
        }
        ipfFunction.logExit();
        ipfFunction = null;
        return usIDSession;
    }

    public CAM_GSSHelper createGSSHelper(Subject serverSubject) throws CAMCryptoException {
        CAM_GSSHelperImpl gssHelper;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createGSSHelper(server)", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (!this.bInitialized) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_not_initialized"));
            }
            gssHelper = new CAM_GSSHelperImpl(serverSubject);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createGSSHelper(server)", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createGSSHelper(server)", this).logExit(gssHelper);
        return gssHelper;
    }

    private void checkPeersURLs(IConfiguration config) throws CAMCryptoException {
        if (!config.getWeAreCM()) {
            boolean runAsStandaloneCA = config.isStandaloneCA();
            PriorityUrlList peerURLs = config.getPeers();
            if (peerURLs.isEmpty() && !runAsStandaloneCA) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_no_peer_url"));
            }
        }
    }
}

