/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;

public class CMDRTEncryptingSession
extends DefaultAdditionalInfoHandler {
    private static final int ENCODING_VERSION = 1;
    private String serviceID;

    CMDRTEncryptingSession(String serviceID) {
        this.serviceID = serviceID;
    }

    public byte[] encryptPassport(byte[] passport) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("encryptPassport", this);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            byte[] encoded_pp = new byte[15 + passport.length];
            encoded_pp[0] = 1;
            long time = System.currentTimeMillis() / 1000L;
            for (int i = 0; i < 8; ++i) {
                encoded_pp[1 + i] = (byte)(time >> 8 * i & 0xFFL);
            }
            System.arraycopy("CMDRT:".getBytes(), 0, encoded_pp, 9, 6);
            System.arraycopy(passport, 0, encoded_pp, 15, passport.length);
            EncryptingSession encSession = new EncryptingSession(this.serviceID);
            byte[] ciphertext = encSession.encryptData(encoded_pp);
            byte[] b64Ciphertext = CryptoWrapper.encodeBase64(ciphertext);
            new IPFTraceFunction("encryptPassport", this).logExit(b64Ciphertext);
            return b64Ciphertext;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("encryptPassPort", this).logExit(e);
            throw e;
        }
    }
}

