/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMCryptoServerException;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.EncodedCSKRequest;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.pkcs.PKCS7EnvelopedData;
import com.cognos.accman.jcam.crypto.pkcs.PKCS7SignedData;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.pkcs.SignedData;

public class CSKRequestHandler
extends DefaultAdditionalInfoHandler {
    static IPFTraceLogger cskTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CSK");
    private String serviceID;
    private String locale;

    CSKRequestHandler(String serviceID) {
        cskTraceLogger.logEnter();
        this.serviceID = serviceID;
        this.locale = "en_US";
        cskTraceLogger.logExit(serviceID);
    }

    public byte[] handleCSKRequest(byte[] base64SignedRequest) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        if (base64SignedRequest == null || base64SignedRequest.length == 0) {
            cskTraceLogger.trace("The base 64 CSK request is empty.");
            CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException("CAM_CRP_empty_csk_request");
            return CAMCryptoUtilities.buildServerError(this.locale, (byte)2, (byte)9, camCryptoServerException);
        }
        cskTraceLogger.trace("Start to handle a CSK requst, base64SignedRequest size = " + base64SignedRequest.length);
        byte[] b64CSK = null;
        byte[] signedRequest = null;
        try {
            signedRequest = CryptoWrapper.decodeBase64(base64SignedRequest);
        }
        catch (Exception e) {
            cskTraceLogger.trace("Failed to b64 decode signed request");
            CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException("CAM_CRP_csk_request_b64_decode_exception");
            return CAMCryptoUtilities.buildServerError(this.locale, (byte)2, (byte)9, camCryptoServerException);
        }
        if (signedRequest == null) {
            cskTraceLogger.trace("Unable to b64 decode signed request");
            CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException("CAM_CRP_csk_request_b64_decode_error");
            return CAMCryptoUtilities.buildServerError(this.locale, (byte)2, (byte)9, camCryptoServerException);
        }
        SignedData signedContentDataObject = null;
        byte[] contentData = null;
        try {
            signedContentDataObject = PKCS7SignedData.getSignedContentDataObject(signedRequest);
            contentData = PKCS7SignedData.getContentData(signedContentDataObject);
        }
        catch (Exception e) {
            cskTraceLogger.trace("Failed to get contant data");
            CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException(e, "CAM_CRP_csk_request_get_content_data_error");
            return CAMCryptoUtilities.buildServerError(this.locale, (byte)2, (byte)9, camCryptoServerException);
        }
        EncodedCSKRequest encodedCSKRequest = new EncodedCSKRequest();
        if (!encodedCSKRequest.parseCSKRequest(contentData)) {
            CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException("CAM_CRP_csk_request_parse_error");
            return CAMCryptoUtilities.buildServerError(this.locale, (byte)2, (byte)9, camCryptoServerException);
        }
        String b64Digest = null;
        byte[] digest = encodedCSKRequest.getDigest();
        if (digest != null && digest.length != 0) {
            b64Digest = new String(CryptoWrapper.encodeBase64(digest));
        }
        String installID = null;
        byte[] iid = encodedCSKRequest.getInstallID();
        if (iid != null && iid.length != 0) {
            installID = new String(iid);
        }
        if (contentData[0] != 2) {
            cskTraceLogger.trace("New format request version mismatch.");
            CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException("CAM_CRP_csk_invalid_request_version");
            new IPFAuditFunction("handleCSKRequest", this).logExit(camCryptoServerException);
            return CAMCryptoUtilities.buildServerError(this.locale, (byte)2, (byte)9, camCryptoServerException);
        }
        byte[] byteLocale = encodedCSKRequest.getLocale();
        if (byteLocale != null && byteLocale.length != 0) {
            this.locale = new String(byteLocale);
        }
        byte[] ipAddr = encodedCSKRequest.getIP();
        String originatingIPAddrStr = "Unknown";
        if (ipAddr.length == 4) {
            originatingIPAddrStr = (ipAddr[0] & 0xFF) + "." + (ipAddr[1] & 0xFF) + "." + (ipAddr[2] & 0xFF) + "." + (ipAddr[3] & 0xFF);
        } else {
            originatingIPAddrStr = "";
            for (int b = 0; b < ipAddr.length; ++b) {
                originatingIPAddrStr = originatingIPAddrStr + Integer.toHexString(ipAddr[b] & 0xFF);
                originatingIPAddrStr = originatingIPAddrStr + Integer.toHexString(ipAddr[++b] & 0xFF);
                originatingIPAddrStr = originatingIPAddrStr + ":";
            }
        }
        cskTraceLogger.trace("Successfully parsed the CSK request.");
        byte[] rawCert = encodedCSKRequest.getCert();
        X509Certificate remoteCert = null;
        try {
            remoteCert = CryptoWrapper.decodeCert(rawCert);
        }
        catch (CertificateParsingException e) {
            CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException(e, "CAM_CRP_csk_request_decode_remote_cert_error");
            new IPFAuditFunction("handleCSKRequest", this).logExit(camCryptoServerException);
            this.logSenderInfo("CertificateParsingException", installID, originatingIPAddrStr, b64Digest);
            return CAMCryptoUtilities.buildServerError(this.locale, (byte)2, (byte)9, camCryptoServerException);
        }
        String subjectDN = remoteCert.getSubjectDN().toString();
        byte[] encodedCSK = null;
        boolean bFoundCSK = true;
        try {
            encodedCSK = KeyStoreReader.getEncodedCSKWithExpiryCheck(digest);
        }
        catch (Exception e1) {
            bFoundCSK = false;
        }
        if (!bFoundCSK || encodedCSK.length == 0) {
            CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException("CAM_CRP_csk_request_csk_not_found", new String[]{b64Digest});
            new IPFAuditFunction("handleCSKRequest", this).logExit(camCryptoServerException);
            this.logSenderInfo("Could not find requested CSK", installID, originatingIPAddrStr, b64Digest);
            return CAMCryptoUtilities.buildServerError(this.locale, (byte)2, (byte)9, camCryptoServerException);
        }
        cskTraceLogger.trace("Found CSK");
        try {
            PKCS7SignedData.verify(signedContentDataObject);
        }
        catch (Exception e) {
            CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException(e, "CAM_CRP_not_able_to_verify_signed_request");
            new IPFAuditFunction("handleCSKRequest", this).logExit(camCryptoServerException);
            this.logSenderInfo("Signature verificate failed", installID, originatingIPAddrStr, b64Digest);
            return CAMCryptoUtilities.buildServerError(this.locale, (byte)2, (byte)9, camCryptoServerException);
        }
        cskTraceLogger.trace("Verified signature of the CSK request.");
        try {
            KeyStoreReader.verifyCertificateIsTrusted(remoteCert, true);
        }
        catch (CAMCryptoException e) {
            CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException(e, "CAM_CRP_remote_cert_is_not_trusted");
            new IPFAuditFunction("handleCSKRequest", this).logExit(camCryptoServerException);
            this.logSenderInfo("Certificate verificateion failed", installID, originatingIPAddrStr, b64Digest);
            return CAMCryptoUtilities.buildServerError(this.locale, (byte)2, (byte)9, camCryptoServerException);
        }
        cskTraceLogger.trace("Verified the remote client certificate = '" + subjectDN + "' is trusted.");
        byte[] encryptedCSK = null;
        if (encodedCSKRequest.isReturnPKCS7()) {
            X509Certificate[] recipients = new X509Certificate[]{remoteCert};
            encryptedCSK = PKCS7EnvelopedData.encode(recipients, encodedCSK);
        } else {
            try {
                Cipher c = null;
                if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                    String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                    c = Cipher.getInstance("RSA", jceProvider);
                } else {
                    c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                }
                c.init(1, remoteCert.getPublicKey());
                encryptedCSK = c.doFinal(encodedCSK);
            }
            catch (Exception e) {
                CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException(e, "CAM_CRP_not_able_to_encrypt_csk");
                new IPFAuditFunction("handleCSKRequest", this).logExit(camCryptoServerException);
                this.logSenderInfo("Encryption of CSK response failied", installID, originatingIPAddrStr, b64Digest);
                return CAMCryptoUtilities.buildServerError(this.locale, (byte)2, (byte)9, camCryptoServerException);
            }
        }
        byte[] barray = new byte[encryptedCSK.length + 2];
        barray[0] = 2;
        barray[1] = 0;
        System.arraycopy(encryptedCSK, 0, barray, 2, encryptedCSK.length);
        b64CSK = CryptoWrapper.encodeBase64(barray);
        cskTraceLogger.trace("Return CSK request");
        cskTraceLogger.logExit(true);
        return b64CSK;
    }

    private void logSenderInfo(String failure, String installID, String originatingIPAddrStr, String b64Digest) {
        String msg = failure + ": CSK name = " + b64Digest + "; Sender's IP Address = " + originatingIPAddrStr + "; install ID = " + installID;
        cskTraceLogger.trace(msg);
    }
}

