/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.AdditionalInfo;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.LoggableObject;
import com.cognos.accman.res.MessageSet;
import java.io.CharArrayReader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultAdditionalInfoHandler
implements AdditionalInfo,
LoggableObject {
    private String _hopCount;
    private String _sessionContext;
    private String _requestContext;
    private String _stepContext;
    private String _productLocale;
    private String _contentLocale;
    private String _serverLocale;
    private int _id;
    private static Object _idMutex = new Object();
    private static int _nextID = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultAdditionalInfoHandler() {
        Object object = _idMutex;
        synchronized (object) {
            this._id = _nextID++;
        }
        this._productLocale = "en";
        this._contentLocale = "en";
        this._serverLocale = "en";
        this._hopCount = "";
        this._sessionContext = "";
        this._requestContext = "";
        this._stepContext = "";
    }

    @Override
    public void setAdditionalInfo(String document) throws CAMCryptoException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            SAXParser parser = factory.newSAXParser();
            ContentHandler handler = new ContentHandler(this);
            parser.parse(new InputSource(new CharArrayReader(document.toCharArray())), (DefaultHandler)handler);
            while (handler.extraPassRequired()) {
                parser.parse(new InputSource(new CharArrayReader(document.toCharArray())), (DefaultHandler)handler);
            }
            MessageSet.setLocale(this._productLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getContentLocale() {
        return this._contentLocale;
    }

    @Override
    public String getHopCount() {
        return this._hopCount;
    }

    @Override
    public String getProductLocale() {
        return this._productLocale;
    }

    @Override
    public String getRequestContext() {
        return this._requestContext;
    }

    @Override
    public String getServerLocale() {
        return this._serverLocale;
    }

    @Override
    public String getSessionContext() {
        return this._sessionContext;
    }

    @Override
    public String getStepContext() {
        return this._stepContext;
    }

    @Override
    public int getClassInstanceID() {
        return this._id;
    }

    private class ContentHandler
    extends DefaultHandler {
        private int _state;
        private String currentArrayItemName;
        private Hashtable _href2stateMap;
        private HashSet _resolvedHrefs;
        private Vector _stateStack;
        private DefaultAdditionalInfoHandler _outer;
        private boolean _foundNewHref;
        private static final int kStateStart = 0;
        private static final int kStateSoapEnvelope = 1;
        private static final int kStateSoapHeader = 2;
        private static final int kStateBIBusHeader = 3;
        private static final int kStateTrackingElement = 4;
        private static final int kStateSessionContextElement = 5;
        private static final int kStateRequestContextElement = 6;
        private static final int kStateStepContextElement = 7;
        private static final int kStateHopCount = 8;
        private static final int kStateUserPreferenceArray = 9;
        private static final int kStateUserPreferenceArrayContent = 10;
        private static final int kStateUserPreferenceArrayNameElement = 11;
        private static final int kStateUserPreferenceArrayValueElement = 12;
        private static final String kNamespaceURIEmpty = "";
        private static final String kNamespaceURISoapEnvelope = "http://schemas.xmlsoap.org/soap/envelope/";
        private static final String kNamespaceURIBIBus = "http://developer.cognos.com/schemas/bibus/3/";
        private static final String kElementSoapHeader = "Header";
        private static final String kElementSoapEnvelope = "Envelope";
        private static final String kElementBIBusHeader = "biBusHeader";
        private static final String kElementBIBusTracking = "tracking";
        private static final String kElementBIBusSessionContext = "sessionContext";
        private static final String kElementBIBusRequestContext = "requestContext";
        private static final String kElementBIBusStepContext = "stepContext";
        private static final String kElementBIBusHopCount = "hopCount";
        private static final String kElementBIBusUserPreference = "userPreferenceVars";
        private static final String kElementBIBusName = "name";
        private static final String kElementBIBusValue = "value";
        private static final String kAttributeSoapHref = "href";
        private static final String kAttributeSoapId = "id";
        private static final String kValueBIBusProductLocale = "productLocale";
        private static final String kValueBIBusContentLocale = "contentLocale";
        private static final String kValueBIBusServerLocale = "serverLocale";

        public ContentHandler(DefaultAdditionalInfoHandler outer) {
            this._outer = outer;
            this._href2stateMap = new Hashtable();
            this._stateStack = new Vector();
            this._resolvedHrefs = new HashSet();
            this.currentArrayItemName = null;
        }

        @Override
        public void startDocument() {
            this._foundNewHref = false;
        }

        @Override
        public void endDocument() {
            if (!this._foundNewHref) {
                this._href2stateMap.clear();
            }
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes atts) {
            Object obj;
            this._stateStack.add(this._state);
            String id = atts.getValue(kNamespaceURIEmpty, kAttributeSoapId);
            if (id != null && (obj = this._href2stateMap.get(id = "#" + id)) != null) {
                this._state = (Integer)obj;
                this._href2stateMap.remove(id);
                this._resolvedHrefs.add(id);
                return;
            }
            switch (this._state) {
                case 0: {
                    if (!name.equals(kElementSoapEnvelope) || !uri.equals(kNamespaceURISoapEnvelope)) break;
                    this.changeState(1, atts);
                    break;
                }
                case 1: {
                    if (!name.equals(kElementSoapHeader) || !uri.equals(kNamespaceURISoapEnvelope)) break;
                    this.changeState(2, atts);
                    break;
                }
                case 2: {
                    if (!name.equals(kElementBIBusHeader) || !uri.equals(kNamespaceURIBIBus)) break;
                    this.changeState(3, atts);
                    break;
                }
                case 3: {
                    if (name.equals(kElementBIBusUserPreference)) {
                        this.changeState(9, atts);
                        break;
                    }
                    if (!name.equals(kElementBIBusTracking)) break;
                    this.changeState(4, atts);
                    break;
                }
                case 4: {
                    if (name.equals(kElementBIBusSessionContext)) {
                        this.changeState(5, atts);
                        break;
                    }
                    if (name.equals(kElementBIBusRequestContext)) {
                        this.changeState(6, atts);
                        break;
                    }
                    if (name.equals(kElementBIBusStepContext)) {
                        this.changeState(7, atts);
                        break;
                    }
                    if (!name.equals(kElementBIBusHopCount)) break;
                    this.changeState(8, atts);
                    break;
                }
                case 9: {
                    this.changeState(10, atts);
                    break;
                }
                case 10: {
                    if (name.equals(kElementBIBusName)) {
                        this.changeState(11, atts);
                    }
                    if (!name.equals(kElementBIBusValue)) break;
                    this.changeState(12, atts);
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            this._state = (Integer)this._stateStack.lastElement();
            this._stateStack.remove(this._stateStack.size() - 1);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            switch (this._state) {
                case 5: {
                    this._outer._sessionContext = new String(ch, start, length);
                    break;
                }
                case 6: {
                    this._outer._requestContext = new String(ch, start, length);
                    break;
                }
                case 7: {
                    this._outer._stepContext = new String(ch, start, length);
                    break;
                }
                case 8: {
                    this._outer._hopCount = new String(ch, start, length);
                    break;
                }
                case 11: {
                    this.currentArrayItemName = new String(ch, start, length);
                    break;
                }
                case 12: {
                    if (this.currentArrayItemName == null) break;
                    if (this.currentArrayItemName.equals(kValueBIBusProductLocale)) {
                        this._outer._productLocale = new String(ch, start, length);
                        break;
                    }
                    if (this.currentArrayItemName.equals(kValueBIBusContentLocale)) {
                        this._outer._contentLocale = new String(ch, start, length);
                        break;
                    }
                    if (!this.currentArrayItemName.equals(kValueBIBusServerLocale)) break;
                    this._outer._serverLocale = new String(ch, start, length);
                    break;
                }
            }
        }

        private void changeState(int target, Attributes atts) {
            String href = atts.getValue(kNamespaceURIEmpty, kAttributeSoapHref);
            if (href != null) {
                if (!this._resolvedHrefs.contains(href)) {
                    this._foundNewHref = true;
                    this._href2stateMap.put(href, target);
                }
            } else {
                this._state = target;
            }
        }

        public boolean extraPassRequired() {
            return this._href2stateMap.size() != 0;
        }
    }
}

