/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.misc.CAMKeyStore;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class FileSignatureSession
extends DefaultAdditionalInfoHandler {
    private final String SIGN_ALG = "SHA1withDSA";
    private String serviceID;
    private String base64Cert;

    FileSignatureSession(String serviceID) {
        this.serviceID = serviceID;
    }

    public byte[] signData(String fileName, String keystore, String keystorePassword) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("FileSignature.sign", this);
        ipfFunction.addParameter("fileData", fileName);
        ipfFunction.logEntry();
        ipfFunction = null;
        byte[] base64Signature = null;
        byte[] fileData = null;
        PrivateKey privateKey = null;
        try {
            fileData = this.getFileData(fileName);
            KeyStore ks = null;
            FileInputStream ksStream = new FileInputStream(keystore);
            char[] password = keystorePassword.toCharArray();
            try {
                ks = KeyStore.getInstance("PKCS12-DEF", "BC");
                ks.load(ksStream, password);
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{keystore}));
            }
            privateKey = (PrivateKey)ks.getKey("signing", keystorePassword.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            byte[] signedData = null;
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initSign(privateKey);
            signature.update(fileData);
            signedData = signature.sign();
            base64Signature = CryptoWrapper.encodeBase64(signedData);
        }
        catch (InvalidKeyException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (SignatureException e1) {
            e1.printStackTrace();
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(fileName + ".signature");
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.write(base64Signature, 0, base64Signature.length);
            dataOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] base64Cert = null;
        try {
            CAMKeyStore signKeyStore = new CAMKeyStore(keystore, keystorePassword, "PKCS12-DEF", "BC");
            signKeyStore.loadKeyStore();
            Certificate certificate = signKeyStore.getCertificate("encryption");
            byte[] cert = certificate.getEncoded();
            base64Cert = CryptoWrapper.encodeBase64(cert);
        }
        catch (Exception signKeyStore) {
            // empty catch block
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(fileName + ".certificate");
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.write(base64Cert, 0, base64Cert.length);
            dataOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new IPFTraceFunction("FileSignature.sign", this).logExit();
        return base64Signature;
    }

    public boolean verifyData(String fileName) throws FileNotFoundException, IOException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, CAMCryptoException, NoSuchProviderException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("FileSignature.verify", this);
        ipfFunction.addParameter("fileData", fileName);
        ipfFunction.logEntry();
        ipfFunction = null;
        byte[] fileData = this.getFileData(fileName);
        Certificate cert = null;
        byte[] byteCert = CryptoWrapper.decodeBase64(this.getFileData(fileName + ".certificate"));
        ByteArrayInputStream baisCert = new ByteArrayInputStream(byteCert);
        CertificateFactory cf = null;
        if (JVMEnvironment.getInstance().isFIPSEnabled()) {
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            cf = CertificateFactory.getInstance("X.509", jceProvider);
        } else {
            cf = CertificateFactory.getInstance("X.509");
        }
        cert = cf.generateCertificate(baisCert);
        byte[] base64Signature = this.getSignatureData(fileName + ".signature");
        boolean ret = false;
        Signature signature = null;
        byte[] signedData = CryptoWrapper.decodeBase64(base64Signature);
        signature = Signature.getInstance("SHA1withDSA");
        signature.initVerify(cert.getPublicKey());
        signature.update(fileData);
        ret = signature.verify(signedData);
        new IPFTraceFunction("LicenseSignagure.verify", this).logExit();
        return ret;
    }

    private byte[] getFileData(String fileName) throws FileNotFoundException, IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        FileInputStream fis = new FileInputStream(fileName);
        while ((c = fis.read()) != -1) {
            if (c == 9 || c == 10 || c == 13 || c == 32) continue;
            buf.append((char)c);
        }
        byte[] fileData = buf.toString().getBytes();
        return fileData;
    }

    private byte[] getSignatureData(String fileName) throws FileNotFoundException, IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        FileInputStream fis = new FileInputStream(fileName);
        while ((c = fis.read()) != -1) {
            buf.append((char)c);
        }
        byte[] fileData = buf.toString().getBytes();
        return fileData;
    }
}

