/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.Token;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import javax.crypto.Mac;

public class GenericHMACToken
extends Token {
    public static int VERSION1 = 1;
    public static int VERSION2 = 2;
    private int m_version = 2;
    private String m_algorithm;
    private byte[] m_hmacDigest;

    public GenericHMACToken() {
    }

    public GenericHMACToken(String theAlgorithm, Mac theMac, byte[] data) {
        this.m_algorithm = theAlgorithm;
        theMac.reset();
        this.m_hmacDigest = theMac.doFinal(data);
    }

    public int getVersion() {
        return this.m_version;
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    public String getAlgorithm() {
        return this.m_algorithm;
    }

    @Override
    public void readToken(ByteArrayInputStream in) throws CAMCryptoException {
        this.m_version = this.readVersion(in);
        if (this.m_version != VERSION1 && this.m_version != VERSION2) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_message_version"));
        }
        this.m_algorithm = this.readAlgorithm(in);
        this.m_hmacDigest = this.readHMacDigest(in);
    }

    @Override
    public void writeToken(ByteArrayOutputStream out) throws CAMCryptoException {
        this.writeVersion(out, this.m_version);
        this.writeAlgorithm(out, this.m_algorithm);
        this.writeHmacDigest(out, this.m_hmacDigest);
    }

    public boolean verify(GenericHMACToken token) throws CAMCryptoException {
        return Arrays.equals(token.m_hmacDigest, this.m_hmacDigest);
    }
}

