/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.ReportSpecTokenV1;
import com.cognos.accman.jcam.crypto.ReportSpecTokenV2;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IConfiguration;
import com.cognos.accman.jcam.crypto.misc.IJVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.res.MessageSet;
import java.security.SecureRandom;
import java.util.Date;
import javax.crypto.Mac;

public class ReportSpecProtectionSession {
    public static final int NO_SIGNATURE_FOUND = -1;
    public static final int INVALID_SIGNATURE = -2;
    private static final int VERSION1 = 1;
    private static final int VERSION2 = 2;
    private static final int ENCODED_TOKEN_LEN = 8;
    private static final int SALT_LENGTH = 8;
    private static final String HEADER_AND_FOOTER = "00001111C4MCRYP7000001111";
    private final IJVMEnvironment jvmEnv;
    private final IConfiguration config;
    private final byte[] currentCskDigest = CAMCryptoUtilities.digestCSK(KeyStoreReader.getCSKWithExpiryCheck());
    private final SecureRandom random;
    private byte[] tokenBytes = null;
    private byte[] spec = null;
    private int specLength = 0;

    ReportSpecProtectionSession() throws CAMCryptoException {
        this.jvmEnv = JVMEnvironment.getInstance();
        this.random = this.jvmEnv.getSecureRandom();
        this.config = Configuration.getInstance();
    }

    private byte[] createProtectedSpec(byte[] tokenByteArray) {
        byte[] specSignature = this.createSpecSignature(tokenByteArray);
        byte[] protectedSpec = new byte[this.specLength + specSignature.length];
        System.arraycopy(this.spec, 0, protectedSpec, 0, this.specLength);
        System.arraycopy(specSignature, 0, protectedSpec, this.specLength, specSignature.length);
        return protectedSpec;
    }

    private byte[] createSpecSignature(byte[] tokenByteArray) {
        byte[] tokenB64 = CryptoWrapper.encodeBase64(tokenByteArray);
        byte[] tokenB64Length = CryptoWrapper.toByteArray(tokenB64.length);
        byte[] tokenB64LengthB16 = CryptoWrapper.encodeBase16(tokenB64Length);
        byte[] headerAndFooter = HEADER_AND_FOOTER.getBytes();
        byte[] specSignature = new byte[headerAndFooter.length + tokenB64.length + tokenB64LengthB16.length + headerAndFooter.length];
        int offset = 0;
        System.arraycopy(headerAndFooter, 0, specSignature, offset, headerAndFooter.length);
        System.arraycopy(tokenB64, 0, specSignature, offset += headerAndFooter.length, tokenB64.length);
        System.arraycopy(tokenB64LengthB16, 0, specSignature, offset += tokenB64.length, tokenB64LengthB16.length);
        System.arraycopy(headerAndFooter, 0, specSignature, offset += tokenB64LengthB16.length, headerAndFooter.length);
        return specSignature;
    }

    private Mac getMacGivenCSKDigest(byte[] cskDigest) throws CAMCryptoException {
        String hMacAlgorithm = this.config.getHMACAlgorithm();
        return CAMCryptoUtilities.getMacGivenCSKDigest(cskDigest, hMacAlgorithm);
    }

    public boolean isProtected() throws CAMCryptoException {
        int start = this.extractSignature();
        if (start != -1) {
            this.specLength = start;
            return true;
        }
        return false;
    }

    public int locateSignature() throws CAMCryptoException {
        int start = this.extractSignature();
        if (start != -1) {
            this.specLength = start;
            if (!this.verifyData()) {
                start = -2;
            }
        }
        return start;
    }

    private int extractSignature() throws CAMCryptoException {
        if (this.spec == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        int headFootLength = HEADER_AND_FOOTER.length();
        int start = this.specLength - headFootLength;
        String footer = new String(this.spec, this.specLength - headFootLength, headFootLength);
        if (!HEADER_AND_FOOTER.equals(footer)) {
            return -1;
        }
        byte[] byte16TokenLen = new byte[8];
        System.arraycopy(this.spec, start -= 8, byte16TokenLen, 0, 8);
        byte[] byteTokenLen = CryptoWrapper.decodeBase16(byte16TokenLen);
        int encodedTokenLen = CryptoWrapper.toInt(byteTokenLen, 0, 4);
        byte[] tokenB64 = new byte[encodedTokenLen];
        System.arraycopy(this.spec, start -= encodedTokenLen, tokenB64, 0, encodedTokenLen);
        byte[] token = CryptoWrapper.decodeBase64(tokenB64);
        String header = new String(this.spec, start -= headFootLength, headFootLength);
        if (!HEADER_AND_FOOTER.equals(header)) {
            return -1;
        }
        this.tokenBytes = token;
        return start;
    }

    public byte[] protectDataV1() throws CAMCryptoException {
        byte[] tokenByteArray = this.generateTokenV1();
        return this.createProtectedSpec(tokenByteArray);
    }

    public byte[] generateSignatureV1() throws CAMCryptoException {
        byte[] tokenByteArray = this.generateTokenV1();
        return this.createSpecSignature(tokenByteArray);
    }

    private byte[] generateTokenV1() throws CAMCryptoException {
        if (this.spec == null || this.specLength == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        Mac mac = this.getMacGivenCSKDigest(this.currentCskDigest);
        byte[] salt = new byte[8];
        this.random.nextBytes(salt);
        ReportSpecTokenV1 token = new ReportSpecTokenV1(mac, salt, new Date(), this.currentCskDigest, this.spec, this.specLength);
        byte[] tokenByteArray = token.writeToken();
        return tokenByteArray;
    }

    public byte[] protectData() throws CAMCryptoException {
        byte[] tokenByteArray = this.generateToken();
        return this.createProtectedSpec(tokenByteArray);
    }

    public byte[] generateSignature() throws CAMCryptoException {
        byte[] tokenByteArray = this.generateToken();
        return this.createSpecSignature(tokenByteArray);
    }

    private byte[] generateToken() throws CAMCryptoException {
        if (this.spec == null || this.specLength == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        String algorithm = this.config.getDigestAlgorithm();
        String hMacAlgorithm = this.config.getHMACAlgorithm(algorithm);
        Mac mac = CAMCryptoUtilities.getMacGivenCSKDigest(this.currentCskDigest, hMacAlgorithm);
        byte[] salt = new byte[8];
        this.random.nextBytes(salt);
        ReportSpecTokenV2 token = new ReportSpecTokenV2(mac, algorithm, salt, new Date(), this.currentCskDigest, this.spec, this.specLength);
        byte[] tokenByteArray = token.writeToken();
        return tokenByteArray;
    }

    public void setSpec(byte[] theSpec) throws CAMCryptoException {
        if (theSpec == null || theSpec.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        this.spec = theSpec;
        this.specLength = theSpec.length;
    }

    public boolean verifyData() throws CAMCryptoException {
        if (this.tokenBytes == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        byte tokenVersion = this.tokenBytes[0];
        if (tokenVersion == 1) {
            ReportSpecTokenV1 token = new ReportSpecTokenV1();
            token.readToken(this.tokenBytes);
            byte[] cskDigest = token.getCSKDigest();
            Mac cskMac = this.getMacGivenCSKDigest(cskDigest);
            ReportSpecTokenV1 expectedToken = new ReportSpecTokenV1(cskMac, token.getSalt(), token.getTime(), cskDigest, this.spec, this.specLength);
            return token.verify(expectedToken);
        }
        if (tokenVersion == 2) {
            ReportSpecTokenV2 token = new ReportSpecTokenV2();
            token.readToken(this.tokenBytes);
            byte[] cskDigest = token.getCSKDigest();
            String algorithm = token.getAlgorithm();
            String hMacAlgorithm = this.config.getHMACAlgorithm(algorithm);
            Mac cskMac = CAMCryptoUtilities.getMacGivenCSKDigest(cskDigest, hMacAlgorithm);
            ReportSpecTokenV2 expectedToken = new ReportSpecTokenV2(cskMac, algorithm, token.getSalt(), token.getTime(), cskDigest, this.spec, this.specLength);
            return token.verify(expectedToken);
        }
        throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_message_version"));
    }
}

