/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.Token;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Mac;

public class ReportSpecTokenV1
extends Token {
    private static final int VERSION_1 = 1;
    private static final String CLASS_ID = "ReportSpecSign";
    private byte[] salt;
    private byte[] cskDigest;
    private byte[] digest;
    private Date time;
    private byte[] spec;

    public ReportSpecTokenV1() {
    }

    public ReportSpecTokenV1(Mac theMac, byte[] theSalt, Date theTime, byte[] theCskDigest, byte[] theSpec) {
        this.salt = theSalt;
        this.time = theTime;
        this.cskDigest = theCskDigest;
        this.spec = theSpec;
        this.determineDigest(theMac, this.spec.length);
    }

    public ReportSpecTokenV1(Mac theMac, byte[] theSalt, Date theTime, byte[] theCskDigest, byte[] theSpec, int specLength) {
        this.salt = theSalt;
        this.time = theTime;
        this.cskDigest = theCskDigest;
        this.spec = theSpec;
        this.determineDigest(theMac, specLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineDigest(Mac theMac, int specLength) {
        Mac mac = theMac;
        synchronized (mac) {
            theMac.update((byte)1);
            theMac.update(this.getByteTime(this.time));
            theMac.update(this.salt);
            theMac.update(CLASS_ID.getBytes());
            theMac.update(this.spec, 0, specLength);
            byte[] tmpMac = theMac.doFinal();
            theMac.update(this.spec, 0, specLength);
            theMac.update(tmpMac);
            this.digest = theMac.doFinal();
        }
    }

    public Date getTime() {
        return this.time;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getCSKDigest() {
        return this.cskDigest;
    }

    @Override
    public void readToken(ByteArrayInputStream in) throws CAMCryptoException {
        int version = this.readVersion(in);
        if (version != 1) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_message_version"));
        }
        this.time = this.readTime(in);
        this.salt = this.readSalt(in);
        this.cskDigest = this.readCSKDigest(in);
        this.digest = this.readByteArray(in);
    }

    @Override
    public void writeToken(ByteArrayOutputStream out) throws CAMCryptoException {
        this.writeVersion(out, 1);
        this.writeTime(out, this.time);
        this.writeSalt(out, this.salt);
        this.writeCSKDigest(out, this.cskDigest);
        this.writeByteArray(out, this.digest);
    }

    public boolean verify(ReportSpecTokenV1 token) {
        boolean areEqual = Arrays.equals(token.digest, this.digest);
        return areEqual;
    }
}

