/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.Token;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Mac;

public class ReportSpecTokenV2
extends Token {
    private static final int VERSION_2 = 2;
    private static final String CLASS_ID = "ReportSpecSign";
    private byte[] salt;
    private byte[] cskDigest;
    private byte[] digest;
    private Date time;
    private byte[] spec;
    private String algorithm;

    public ReportSpecTokenV2() {
    }

    public ReportSpecTokenV2(Mac theMac, String theAlgorithm, byte[] theSalt, Date theTime, byte[] theCskDigest, byte[] theSpec) {
        this.algorithm = theAlgorithm;
        this.salt = theSalt;
        this.time = theTime;
        this.cskDigest = theCskDigest;
        this.spec = theSpec;
        this.determineDigest(theMac, this.spec.length);
    }

    public ReportSpecTokenV2(Mac theMac, String theAlgorithm, byte[] theSalt, Date theTime, byte[] theCskDigest, byte[] theSpec, int specLength) {
        this.algorithm = theAlgorithm;
        this.salt = theSalt;
        this.time = theTime;
        this.cskDigest = theCskDigest;
        this.spec = theSpec;
        this.determineDigest(theMac, specLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineDigest(Mac theMac, int specLength) {
        Mac mac = theMac;
        synchronized (mac) {
            theMac.update((byte)2);
            theMac.update(this.getByteTime(this.time));
            theMac.update(this.salt);
            theMac.update(CLASS_ID.getBytes());
            theMac.update(this.spec, 0, specLength);
            byte[] tmpMac = theMac.doFinal();
            theMac.update(this.spec, 0, specLength);
            theMac.update(tmpMac);
            this.digest = theMac.doFinal();
        }
    }

    public Date getTime() {
        return this.time;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getCSKDigest() {
        return this.cskDigest;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void readToken(ByteArrayInputStream in) throws CAMCryptoException {
        int version = this.readVersion(in);
        if (version != 2) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_message_version"));
        }
        this.algorithm = this.readAlgorithm(in);
        this.time = this.readTime(in);
        this.salt = this.readSalt(in);
        this.cskDigest = this.readCSKDigest(in);
        this.digest = this.readByteArray(in);
    }

    @Override
    public void writeToken(ByteArrayOutputStream out) throws CAMCryptoException {
        this.writeVersion(out, 2);
        this.writeAlgorithm(out, this.algorithm);
        this.writeTime(out, this.time);
        this.writeSalt(out, this.salt);
        this.writeCSKDigest(out, this.cskDigest);
        this.writeByteArray(out, this.digest);
    }

    public boolean verify(ReportSpecTokenV2 token) {
        return Arrays.equals(token.digest, this.digest);
    }
}

