/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.SPSCipher;
import com.cognos.accman.jcam.crypto.jni.JNISystemProperties;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IJVMEnvironment;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class SPSCipherDESwParity
extends SPSCipher {
    public static final int TYPE = 2;
    private final IJVMEnvironment jvmEnv;

    public SPSCipherDESwParity(IJVMEnvironment theJvmEnv) {
        this.jvmEnv = theJvmEnv;
    }

    @Override
    protected SecretKeySpec createSecretKeySpec(byte[] rawKey) {
        byte[] rawKeyWithParity = CryptoWrapper.addParity(rawKey);
        return new SecretKeySpec(rawKeyWithParity, 0, 8, "DES");
    }

    @Override
    protected Cipher getCipher() throws Exception {
        return Cipher.getInstance("DES/ECB/PKCS5Padding", this.jvmEnv.getPBEProvider());
    }

    @Override
    protected byte[] getSystemKey() {
        return new JNISystemProperties().getByteBuffer2(0);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    protected byte[] addExtraData(byte[] cipherText) {
        return cipherText;
    }

    @Override
    protected byte[] removeExtraData(byte[] data) {
        return data;
    }
}

