/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.SecureStateSessionToken2;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CSKDigest;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Mac;

public class SecureStateSession {
    private boolean bSetValidated = false;
    private boolean bValidated = false;
    private boolean bSetExternal = false;
    private boolean bExternal = false;
    private byte[] currentCskDigest;
    private Mac currentCskMac;
    byte[] token = null;
    boolean bSetToken = false;
    byte[] decodedToken = null;
    byte reqVersion;
    byte[] byteSalt = null;
    byte[] byteCskid = null;
    int macLocation = 0;
    byte[] byteTime = null;
    private SecureStateSessionToken2 tokenV2 = null;
    boolean bSetPassport = false;
    private byte[] passport = null;
    private static final byte VERSION = 1;
    private static final byte VERSION_2 = 2;
    private static final int SALT_LENGTH = 8;
    private SecureRandom random = null;
    private final String classId = "SecureStateSign";

    SecureStateSession(byte[] givenPassport, byte[] givenToken) throws CAMCryptoException {
        this.setPassport(givenPassport);
        this.setSecureStateToken(givenToken);
        this.genericSetup();
    }

    SecureStateSession(byte[] givenPassport) throws CAMCryptoException {
        this.setPassport(givenPassport);
        this.genericSetup();
    }

    private synchronized void genericSetup() throws CAMCryptoException {
        this.currentCskDigest = CSKDigest.getInstance().getCurrentCSKDigest();
        this.currentCskMac = this.getMacGivenCSKDigest(this.currentCskDigest);
        this.random = JVMEnvironment.getInstance().getSecureRandom();
    }

    private void setPassport(byte[] givenPassport) throws CAMCryptoException {
        if (givenPassport == null || givenPassport.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        this.passport = givenPassport;
        this.bSetPassport = true;
    }

    private void setSecureStateToken(byte[] givenToken) throws CAMCryptoException {
        if (givenToken == null || givenToken.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        this.token = givenToken;
        this.decodedToken = CryptoWrapper.decodeBase64(this.token);
        this.bSetToken = true;
        int pos = 0;
        this.reqVersion = this.decodedToken[pos];
        if (this.reqVersion != 1 && this.reqVersion != 2) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_message_version"));
        }
        if (this.reqVersion == 2) {
            ByteArrayInputStream in = new ByteArrayInputStream(this.decodedToken);
            this.tokenV2 = new SecureStateSessionToken2();
            this.tokenV2.readToken(in);
            this.bValidated = this.tokenV2.getValidationFlag();
            this.bExternal = this.tokenV2.getExternFlag();
            return;
        }
        byte[] byteTimeLen = new byte[4];
        System.arraycopy(this.decodedToken, ++pos, byteTimeLen, 0, 4);
        int timelen = CryptoWrapper.toInt(byteTimeLen, 0, 4);
        this.byteTime = new byte[timelen];
        System.arraycopy(this.decodedToken, pos += 4, this.byteTime, 0, timelen);
        byte[] byteSaltLen = new byte[4];
        System.arraycopy(this.decodedToken, pos += timelen, byteSaltLen, 0, 4);
        int saltlen = CryptoWrapper.toInt(byteSaltLen, 0, 4);
        this.byteSalt = new byte[saltlen];
        System.arraycopy(this.decodedToken, pos += 4, this.byteSalt, 0, saltlen);
        byte[] byteCskIdLen = new byte[4];
        System.arraycopy(this.decodedToken, pos += saltlen, byteCskIdLen, 0, 4);
        int cskidlen = CryptoWrapper.toInt(byteCskIdLen, 0, 4);
        this.byteCskid = new byte[cskidlen];
        System.arraycopy(this.decodedToken, pos += 4, this.byteCskid, 0, cskidlen);
        this.bValidated = (this.decodedToken[pos += cskidlen] & 1) == 1;
        this.bExternal = (this.decodedToken[++pos] & 1) == 1;
        this.macLocation = ++pos;
    }

    public void setRequestValidated(boolean state) {
        this.bValidated = state;
        this.bSetValidated = true;
    }

    public boolean getRequestValidated() throws CAMCryptoException {
        return this.bValidated;
    }

    public void setRequestExternal(boolean state) {
        this.bExternal = state;
        this.bSetExternal = true;
    }

    public boolean getRequestExternal() throws CAMCryptoException {
        return this.bExternal;
    }

    public byte[] getSecureStateToken() throws CAMCryptoException {
        if (!(this.bSetValidated && this.bSetExternal && this.bSetPassport)) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        Configuration config = Configuration.getInstance();
        String algorithm = config.getDigestAlgorithm();
        Mac mac = CAMCryptoUtilities.getMacGivenCSKDigest(this.currentCskDigest, config.getHMACAlgorithm(algorithm));
        byte[] salt = new byte[8];
        this.random.nextBytes(salt);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SecureStateSessionToken2 token2 = new SecureStateSessionToken2(algorithm, new Date(), salt, this.currentCskDigest, this.bValidated, this.bExternal, mac, this.passport);
        token2.writeToken(out);
        return CryptoWrapper.encodeBase64(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSecureStateTokenV1() throws CAMCryptoException {
        if (!(this.bSetValidated && this.bSetExternal && this.bSetPassport)) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        if (this.currentCskMac == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_no_hmac_object"));
        }
        Date now = new Date();
        long lNow = now.getTime();
        byte[] byteTime = CryptoWrapper.toByteArray(lNow /= 1000L, 0);
        int timelen = byteTime.length;
        byte[] byteTimeLen = CryptoWrapper.toByteArray(timelen);
        byte[] salt = new byte[8];
        this.random.nextBytes(salt);
        int saltlen = salt.length;
        byte[] byteSaltLen = CryptoWrapper.toByteArray(saltlen);
        int cskidlen = this.currentCskDigest.length;
        byte[] byteCskIdLen = CryptoWrapper.toByteArray(cskidlen);
        byte byteValidationFlag = this.bValidated ? (byte)1 : 0;
        byte byteExtFlag = this.bExternal ? (byte)1 : 0;
        byte[] finalMac = null;
        Mac mac = this.currentCskMac;
        synchronized (mac) {
            this.currentCskMac.reset();
            this.currentCskMac.update((byte)1);
            this.currentCskMac.update(byteTime);
            this.currentCskMac.update(salt);
            this.currentCskMac.update("SecureStateSign".getBytes());
            this.currentCskMac.update(byteValidationFlag);
            this.currentCskMac.update(byteExtFlag);
            this.currentCskMac.update(this.passport);
            byte[] tmpMac = this.currentCskMac.doFinal();
            this.currentCskMac.update(this.passport);
            this.currentCskMac.update(tmpMac);
            finalMac = this.currentCskMac.doFinal();
        }
        int maclen = finalMac.length;
        byte[] byteMacLen = CryptoWrapper.toByteArray(maclen);
        int tokenLen = 5 + timelen + 4 + saltlen + 4 + cskidlen + 1 + 1 + 4 + maclen;
        int pos = 0;
        byte[] token = new byte[tokenLen];
        token[pos] = 1;
        System.arraycopy(byteTimeLen, 0, token, ++pos, byteTimeLen.length);
        System.arraycopy(byteTime, 0, token, pos += byteTimeLen.length, timelen);
        System.arraycopy(byteSaltLen, 0, token, pos += timelen, byteSaltLen.length);
        System.arraycopy(salt, 0, token, pos += byteSaltLen.length, saltlen);
        System.arraycopy(byteCskIdLen, 0, token, pos += saltlen, byteCskIdLen.length);
        System.arraycopy(this.currentCskDigest, 0, token, pos += byteCskIdLen.length, cskidlen);
        token[pos += cskidlen] = byteValidationFlag;
        token[++pos] = byteExtFlag;
        System.arraycopy(byteMacLen, 0, token, ++pos, byteMacLen.length);
        System.arraycopy(finalMac, 0, token, pos += byteMacLen.length, maclen);
        pos += maclen;
        byte[] base64token = CryptoWrapper.encodeBase64(token);
        return base64token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifySecureStateToken() throws CAMCryptoException {
        if (this.tokenV2 != null) {
            Configuration config = Configuration.getInstance();
            Mac mac = CAMCryptoUtilities.getMacGivenCSKDigest(this.tokenV2.getCskDigest(), config.getHMACAlgorithm(this.tokenV2.getAlgorithm()));
            return this.tokenV2.verifyToken(mac, this.passport);
        }
        if (!this.bSetToken || !this.bSetPassport) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        Mac thisMac = this.getMacGivenCSKDigest(this.byteCskid);
        byte[] byteMacLen = new byte[4];
        System.arraycopy(this.decodedToken, this.macLocation, byteMacLen, 0, 4);
        int maclen = CryptoWrapper.toInt(byteMacLen, 0, 4);
        this.macLocation += 4;
        byte[] byteDigest = new byte[maclen];
        System.arraycopy(this.decodedToken, this.macLocation, byteDigest, 0, maclen);
        this.macLocation += maclen;
        byte byteValidationFlag = this.bValidated ? (byte)1 : 0;
        byte byteExtFlag = this.bExternal ? (byte)1 : 0;
        byte[] macToVerify = null;
        Mac mac = thisMac;
        synchronized (mac) {
            thisMac.reset();
            thisMac.update(this.reqVersion);
            thisMac.update(this.byteTime);
            thisMac.update(this.byteSalt);
            thisMac.update("SecureStateSign".getBytes());
            thisMac.update(byteValidationFlag);
            thisMac.update(byteExtFlag);
            thisMac.update(this.passport);
            byte[] tmpMac = thisMac.doFinal();
            thisMac.update(this.passport);
            thisMac.update(tmpMac);
            macToVerify = thisMac.doFinal();
        }
        boolean bResult = Arrays.equals(macToVerify, byteDigest);
        return bResult;
    }

    private Mac getMacGivenCSKDigest(byte[] cskDigest) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        String hmacAlg = config.getHMACAlgorithm();
        return CAMCryptoUtilities.getMacGivenCSKDigest(cskDigest, hmacAlg);
    }
}

