/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.Token;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Mac;

public class SecureStateSessionToken2
extends Token {
    private static final String classId = "SecureStateSign";
    private static final int VERSION = 2;
    private int version;
    private String algorithm;
    private Date time;
    private byte[] salt;
    private byte[] cskDigest;
    private boolean validationFlag;
    private boolean externFlag;
    private byte[] digest;

    public SecureStateSessionToken2() {
    }

    public SecureStateSessionToken2(String theAlgorithm, Date theTime, byte[] theSalt, byte[] theCskDigest, boolean theValidateFlag, boolean theExternFlag, Mac mac, byte[] passport) throws CAMCryptoException {
        this.version = 2;
        this.algorithm = theAlgorithm;
        this.time = theTime;
        this.salt = theSalt;
        this.cskDigest = theCskDigest;
        this.validationFlag = theValidateFlag;
        this.externFlag = theExternFlag;
        this.digest = this.createDigest(mac, passport);
    }

    public boolean verifyToken(Mac mac, byte[] passport) throws CAMCryptoException {
        byte[] digestToVerify = this.createDigest(mac, passport);
        return Arrays.equals(digestToVerify, this.digest);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getCskDigest() {
        return this.cskDigest;
    }

    public boolean getExternFlag() {
        return this.externFlag;
    }

    public boolean getValidationFlag() {
        return this.validationFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createDigest(Mac mac, byte[] passport) throws CAMCryptoException {
        byte[] theDigest;
        Mac mac2 = mac;
        synchronized (mac2) {
            mac.reset();
            mac.update((byte)(this.version & 0xFF));
            mac.update(this.getStringBytes(this.algorithm));
            mac.update(this.getByteTime(this.time));
            mac.update(this.salt);
            mac.update(classId.getBytes());
            mac.update(this.validationFlag ? (byte)1 : 0);
            mac.update(this.externFlag ? (byte)1 : 0);
            mac.update(passport);
            byte[] tmpMac = mac.doFinal();
            mac.update(passport);
            mac.update(tmpMac);
            theDigest = mac.doFinal();
        }
        return theDigest;
    }

    @Override
    public void readToken(ByteArrayInputStream in) throws CAMCryptoException {
        this.version = this.readVersion(in);
        if (this.version != 2) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_message_version"));
        }
        this.algorithm = this.readAlgorithm(in);
        this.time = this.readTime(in);
        this.salt = this.readSalt(in);
        this.cskDigest = this.readCSKDigest(in);
        this.validationFlag = this.readFlag(in);
        this.externFlag = this.readFlag(in);
        this.digest = this.readByteArray(in);
    }

    @Override
    public void writeToken(ByteArrayOutputStream out) throws CAMCryptoException {
        this.writeVersion(out, this.version);
        this.writeAlgorithm(out, this.algorithm);
        this.writeTime(out, this.time);
        this.writeSalt(out, this.salt);
        this.writeCSKDigest(out, this.cskDigest);
        this.writeFlag(out, this.validationFlag);
        this.writeFlag(out, this.externFlag);
        this.writeByteArray(out, this.digest);
    }
}

