/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CSKDigest;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.EncodedCSK_HMAC_Digest;
import com.cognos.accman.jcam.crypto.misc.IJVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.pkcs.PKCS7SignedData;
import com.cognos.accman.res.MessageSet;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.pkcs.SignedData;

public class SigningSession
extends DefaultAdditionalInfoHandler {
    public static final byte HMAC_VERSION1 = 1;
    public static final byte HMAC_VERSION2 = 2;
    private String serviceID;

    SigningSession(String serviceID) {
        this.serviceID = serviceID;
    }

    public byte[] signData(byte[] inputdata) throws CAMCryptoException {
        byte[] signedData;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("signData", this);
        ipfFunction.addParameter("inputdata", inputdata);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            Configuration config = Configuration.getInstance();
            PrivateKey privateKey = KeyStoreReader.getSigningPrivateKey();
            Certificate[] certChain = KeyStoreReader.getSigningCertificateChain();
            X509Certificate[] x509certChain = new X509Certificate[certChain.length];
            System.arraycopy(certChain, 0, x509certChain, 0, certChain.length);
            certChain = null;
            signedData = PKCS7SignedData.sign(inputdata, privateKey, x509certChain, config.getDigestAlgorithm());
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("signData", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("signData", this).logExit(signedData);
        return signedData;
    }

    public boolean verifyData(byte[] signedRequest) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("verifyData", this);
        ipfFunction.addParameter("signedData", signedRequest);
        ipfFunction.logEntry();
        ipfFunction = null;
        boolean dataOk = false;
        try {
            SignedData signedData = PKCS7SignedData.getSignedContentDataObject(signedRequest);
            byte[] contentData = PKCS7SignedData.verify(signedData);
            if (contentData != null) {
                dataOk = true;
            }
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("verifyData", this).logExit(e);
            throw e;
        }
        catch (Exception e) {
            new IPFAuditFunction("verifyData", this).logExit(e);
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        new IPFTraceFunction("verifyData", this).logExit(dataOk);
        return dataOk;
    }

    public byte[] hash(byte[] inputdata) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("hash", this);
        ipfFunction.addParameter("inputdata", inputdata);
        ipfFunction.logEntry();
        ipfFunction = null;
        Configuration config = Configuration.getInstance();
        try {
            MessageDigest md = null;
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(config.getDigestAlgorithm(), jceProvider);
            } else {
                md = MessageDigest.getInstance(config.getDigestAlgorithm());
            }
            md.update(inputdata);
            byte[] digest = md.digest();
            new IPFTraceFunction("hash", this).logExit(digest);
            return digest;
        }
        catch (Exception e) {
            CAMCryptoException ee = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{config.getDigestAlgorithm()}));
            new IPFAuditFunction("hash", this).logExit(ee);
            throw ee;
        }
    }

    public byte[] hmac(byte[] inputdata) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("hmac", this);
        ipfFunction.addParameter("inputdata", inputdata);
        ipfFunction.logEntry();
        ipfFunction = null;
        return this.createHMACToken2(inputdata);
    }

    private byte[] createHMACToken1(byte[] inputdata) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        String hmacAlg = config.getHMACAlgorithm();
        try {
            SecretKey cskKey = KeyStoreReader.getCSKWithExpiryCheck();
            byte[] cskDigest = CAMCryptoUtilities.digestCSK(cskKey);
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            Mac mac = Mac.getInstance(hmacAlg, jceProvider);
            mac.init(cskKey);
            cskKey = null;
            mac.update(inputdata);
            byte[] hmac = mac.doFinal();
            EncodedCSK_HMAC_Digest encodedCskHmacDigest = new EncodedCSK_HMAC_Digest(cskDigest, hmac);
            new IPFTraceFunction("hmac", this).logExit(hmac);
            return encodedCskHmacDigest.getEncodedHMACDigest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{hmacAlg}));
        }
        catch (GeneralSecurityException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_gen_HMAC"));
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("hmac", this).logExit(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createHMACToken2(byte[] inputdata) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        String mdAlg = config.getDigestAlgorithm();
        String hmacAlg = config.getHMACAlgorithm(mdAlg);
        int algorithmLength = mdAlg.length();
        int hmacVersion = 2;
        IJVMEnvironment jvmEnv = null;
        try {
            jvmEnv = JVMEnvironment.getInstance();
        }
        catch (CAMCryptoException e) {
            return null;
        }
        try {
            byte[] hmac;
            Mac mac;
            byte[] cskDigest = CSKDigest.getInstance().getCurrentCSKDigest();
            int cskDigestLength = cskDigest.length;
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            Mac mac2 = mac = CAMCryptoUtilities.getMacGivenCSKDigest(cskDigest, hmacAlg);
            synchronized (mac2) {
                mac.update(inputdata);
                hmac = mac.doFinal();
            }
            int hmacLength = hmac.length;
            int sizeFieldLength = 4;
            int tokenLength = 1 + sizeFieldLength + cskDigestLength + sizeFieldLength + algorithmLength + sizeFieldLength + hmacLength;
            byte[] token = new byte[tokenLength];
            token[0] = (byte)(hmacVersion & 0xFF);
            int pos = 1;
            pos += CAMCryptoUtilities.addTokenField(token, pos, cskDigest);
            pos += CAMCryptoUtilities.addTokenField(token, pos, mdAlg.getBytes());
            CAMCryptoUtilities.addTokenField(token, pos, hmac);
            new IPFTraceFunction("hmac", this).logExit(hmac);
            return token;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("hmac", this).logExit(e);
            throw e;
        }
    }

    public boolean hmacVerify(byte[] encodedCskHmacDigestBlob, byte[] inputdata) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("hmacSign", this);
        ipfFunction.addParameter("inputdata", inputdata);
        ipfFunction.logEntry();
        ipfFunction = null;
        byte hmacVersion = this.getHMACTokenVersion(encodedCskHmacDigestBlob);
        if (hmacVersion == 1) {
            return this.verifyHMACToken1(encodedCskHmacDigestBlob, inputdata);
        }
        return this.verifyHMACToken2(encodedCskHmacDigestBlob, inputdata);
    }

    private boolean verifyHMACToken1(byte[] encodedCskHmacDigestBlob, byte[] inputdata) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        String hmacAlg = config.getHMACAlgorithm();
        try {
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            Mac mac = Mac.getInstance(hmacAlg, jceProvider);
            int hmacLength = mac.getMacLength();
            EncodedCSK_HMAC_Digest encodedCskHmacDigest = new EncodedCSK_HMAC_Digest(encodedCskHmacDigestBlob, hmacLength);
            SecretKey cskKey = KeyStoreReader.getCSKGivenCSKDigest(encodedCskHmacDigest.getCSKDigest());
            byte[] hmacToVerify = encodedCskHmacDigest.getHMACDigest();
            mac.init(cskKey);
            cskKey = null;
            mac.update(inputdata);
            byte[] actualHmac = mac.doFinal();
            boolean hashesMatch = Arrays.equals(hmacToVerify, actualHmac);
            new IPFTraceFunction("hmac", this).logExit();
            return hashesMatch;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{hmacAlg}));
        }
        catch (GeneralSecurityException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_gen_HMAC"));
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("hmac", this).logExit(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyHMACToken2(byte[] token, byte[] inputdata) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        int sizeFieldLength = 4;
        int pos = 1;
        byte[] cskDigest = CAMCryptoUtilities.getTokenField(token, pos);
        byte[] mdAlgorithm = CAMCryptoUtilities.getTokenField(token, pos += sizeFieldLength + cskDigest.length);
        String hmacAlg = config.getHMACAlgorithm(new String(mdAlgorithm));
        byte[] hmac = CAMCryptoUtilities.getTokenField(token, pos += sizeFieldLength + mdAlgorithm.length);
        pos += sizeFieldLength + hmac.length;
        try {
            byte[] actualHmac;
            Mac mac;
            Mac mac2 = mac = CAMCryptoUtilities.getMacGivenCSKDigest(cskDigest, hmacAlg);
            synchronized (mac2) {
                mac.update(inputdata);
                actualHmac = mac.doFinal();
            }
            boolean hashesMatch = Arrays.equals(hmac, actualHmac);
            new IPFTraceFunction("hmac", this).logExit();
            return hashesMatch;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("hmac", this).logExit(e);
            throw e;
        }
    }

    private byte getHMACTokenVersion(byte[] encodedCskHmacDigestBlob) {
        byte version = 0;
        version = (encodedCskHmacDigestBlob[0] == 20 || encodedCskHmacDigestBlob[0] == 32) && encodedCskHmacDigestBlob[1] == 0 && encodedCskHmacDigestBlob[2] == 0 && encodedCskHmacDigestBlob[3] == 0 ? (byte)1 : encodedCskHmacDigestBlob[0];
        return version;
    }
}

