/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.res.MessageSet;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;

public class TmpCipherStreamSession {
    private SecretKey sessionTmpKey = null;
    RC2ParameterSpec aps = null;

    TmpCipherStreamSession() throws CAMCryptoException {
        String alg = null;
        try {
            Configuration config = Configuration.getInstance();
            alg = config.getCSKAlgorithm();
            SecretKey csk = KeyStoreReader.getCSKWithExpiryCheck();
            KeyGenerator kg = null;
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                kg = KeyGenerator.getInstance(alg, jceProvider);
            } else {
                kg = KeyGenerator.getInstance(alg, "BC");
            }
            int cskSize = config.getCSKSize();
            kg.init(cskSize);
            this.sessionTmpKey = kg.generateKey();
            if (alg.equalsIgnoreCase("RC2")) {
                SecureRandom random = JVMEnvironment.getInstance().getSecureRandom();
                byte[] iv = new byte[8];
                random.nextBytes(iv);
                this.aps = new RC2ParameterSpec(csk.getEncoded().length * 8, iv);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_create_tmp_cipher_key", new String[]{alg}));
        }
    }

    public CipherOutputStream createEncryptingOutputStream(OutputStream os) throws CAMCryptoException {
        try {
            Cipher c = null;
            String jceProvider = null;
            jceProvider = JVMEnvironment.getInstance().isFIPSEnabled() ? JVMEnvironment.getInstance().getJCEProvider() : "BC";
            if (this.aps != null) {
                c = Cipher.getInstance("RC2/CBC/PKCS7Padding", jceProvider);
                c.init(1, (Key)this.sessionTmpKey, this.aps);
            } else {
                Configuration config = Configuration.getInstance();
                c = Cipher.getInstance(config.getCSKAlgorithm(), jceProvider);
                c.init(1, this.sessionTmpKey);
            }
            CipherOutputStream cos = new CipherOutputStream(os, c);
            return cos;
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_cipher_obj"));
        }
    }

    public CipherInputStream createDecryptingInputStream(InputStream is) throws CAMCryptoException {
        try {
            Cipher c = null;
            String jceProvider = null;
            jceProvider = JVMEnvironment.getInstance().isFIPSEnabled() ? JVMEnvironment.getInstance().getJCEProvider() : "BC";
            if (this.aps != null) {
                c = Cipher.getInstance("RC2/CBC/PKCS7Padding", jceProvider);
                c.init(2, (Key)this.sessionTmpKey, this.aps);
            } else {
                Configuration config = Configuration.getInstance();
                c = Cipher.getInstance(config.getCSKAlgorithm(), jceProvider);
                c.init(2, this.sessionTmpKey);
            }
            CipherInputStream cis = new CipherInputStream(is, c);
            return cis;
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_cipher_obj"));
        }
    }
}

