/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;

public abstract class Token {
    public abstract void readToken(ByteArrayInputStream var1) throws CAMCryptoException;

    public abstract void writeToken(ByteArrayOutputStream var1) throws CAMCryptoException;

    public void readToken(byte[] tokenBytes) throws CAMCryptoException {
        ByteArrayInputStream in = new ByteArrayInputStream(tokenBytes);
        this.readToken(in);
    }

    public byte[] writeToken() throws CAMCryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeToken(out);
        return out.toByteArray();
    }

    protected void writeVersion(ByteArrayOutputStream out, int theVersion) {
        out.write(theVersion);
    }

    protected void writeAlgorithm(ByteArrayOutputStream out, String theAlgorithm) throws CAMCryptoException {
        byte[] algorithmBytes = this.getStringBytes(theAlgorithm);
        this.writeByteArray(out, algorithmBytes);
    }

    protected byte[] getStringBytes(String string) throws CAMCryptoException {
        byte[] stringBytes;
        try {
            stringBytes = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CAMCryptoException(e);
        }
        return stringBytes;
    }

    protected void writeCSKDigest(ByteArrayOutputStream out, byte[] theCSKDigest) {
        this.writeByteArray(out, theCSKDigest);
    }

    protected void writeHmacDigest(ByteArrayOutputStream out, byte[] theHmacDigest) {
        out.write(theHmacDigest, 0, theHmacDigest.length);
    }

    protected void writeSalt(ByteArrayOutputStream out, byte[] salt) {
        this.writeByteArray(out, salt);
    }

    protected void writeTime(ByteArrayOutputStream out, Date time) {
        byte[] byteTime = this.getByteTime(time);
        this.writeSize(out, byteTime.length);
        out.write(byteTime, 0, byteTime.length);
    }

    protected byte[] getByteTime(Date time) {
        long ltime = time.getTime();
        byte[] byteTime = CryptoWrapper.toByteArray(ltime, 0);
        return byteTime;
    }

    protected void writeBATime(ByteArrayOutputStream out, Date time) {
        byte[] byteTime = this.getBAByteTime(time);
        this.writeSize(out, byteTime.length);
        out.write(byteTime, 0, byteTime.length);
    }

    protected byte[] getBAByteTime(Date time) {
        long ltime = time.getTime();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byteTime = byteBuffer.putLong(ltime).array();
        return byteTime;
    }

    protected void writeByteArray(ByteArrayOutputStream out, byte[] array) {
        this.writeSize(out, array.length);
        out.write(array, 0, array.length);
    }

    protected void writeFlag(ByteArrayOutputStream out, boolean flag) {
        out.write(flag ? 1 : 0);
    }

    protected void writeSize(ByteArrayOutputStream out, int size) {
        this.writeInt(out, size);
    }

    protected void writeInt(ByteArrayOutputStream out, int integer) {
        byte[] integerBytes = CryptoWrapper.toByteArray(integer);
        out.write(integerBytes, 0, integerBytes.length);
    }

    protected byte[] readCSKDigest(ByteArrayInputStream in) throws CAMCryptoException {
        return this.readByteArray(in);
    }

    protected byte[] readSalt(ByteArrayInputStream in) throws CAMCryptoException {
        return this.readByteArray(in);
    }

    protected Date readTime(ByteArrayInputStream in) throws CAMCryptoException {
        byte[] timeBytes = this.readByteArray(in);
        long ltime = CryptoWrapper.toLong(timeBytes);
        return new Date(ltime);
    }

    protected Date readBATime(ByteArrayInputStream in) throws CAMCryptoException {
        byte[] timeBytes = this.readByteArray(in);
        ByteBuffer byteBuffer = ByteBuffer.wrap(timeBytes);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long ltime = byteBuffer.getLong();
        return new Date(ltime);
    }

    protected byte[] readHMacDigest(ByteArrayInputStream in) {
        int b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        return out.toByteArray();
    }

    protected String readAlgorithm(ByteArrayInputStream in) throws CAMCryptoException {
        String name;
        byte[] nameBytes = this.readByteArray(in);
        try {
            name = new String(nameBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CAMCryptoException(e);
        }
        return name;
    }

    protected int readVersion(ByteArrayInputStream in) {
        return in.read();
    }

    protected byte[] readByteArray(ByteArrayInputStream in) throws CAMCryptoException {
        int size = this.readSize(in);
        byte[] array = new byte[size];
        int read = in.read(array, 0, size);
        if (read != size) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        return array;
    }

    protected boolean readFlag(ByteArrayInputStream in) {
        int flag = in.read();
        return flag != 0;
    }

    protected int readInt(ByteArrayInputStream in) {
        byte[] integerBytes = new byte[4];
        in.read(integerBytes, 0, 4);
        int integer = CryptoWrapper.toInt(integerBytes);
        return integer;
    }

    protected int readSize(ByteArrayInputStream in) {
        return this.readInt(in);
    }
}

