/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.EncodedCSK_HMAC_Digest;
import com.cognos.accman.jcam.crypto.misc.EncodedCSK_HMAC_Digest2;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.objectpools.CanonicalizerPool;
import com.cognos.accman.jcam.crypto.objectpools.PooledObject;
import com.cognos.accman.jcam.crypto.objectpools.TransformerPool;
import com.cognos.accman.jcam.crypto.xml.BaseTrustedSession;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TrustedRequestSession
extends BaseTrustedSession {
    private static final String CAM_PROTECTION = "CAMProtect";
    private static final String SOAP_HEADER = "Header";
    private static final String BI_BUS_HEADER = "biBusHeader";
    private static final String TRUSTED_VALUE = "trustedValue";
    private static final String SERVICE_ID = "serviceId";
    private static final String CAM_PROTECTION_TYPE = "bus:CAMProtect";
    private static final String TRUSTED_VALUE_TYPE = "xsd:base64Binary";
    private static final String SERVICE_ID_TYPE = "xsd:string";
    private static final String TYPE_ATTR = "xsi:type";
    private static final String NIL_ATTR = "xsi:nil";
    private static final String NS_ATTR = "xmlns:bus";
    private static final String NS_TYPE = "http://developer.cognos.com/schemas/bibus/3/";
    private static final String SOAP_ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String BIBUS_CAM = "CAM";
    private static final String BIBUS_BODY = "Body";
    private String factoryServiceID;

    TrustedRequestSession(String serviceID) throws CAMCryptoException {
        this.factoryServiceID = serviceID;
    }

    private byte getHMACTokenVersion(byte[] encodedCskHmacDigestBlob) {
        byte v = 0;
        v = (encodedCskHmacDigestBlob[0] == 20 || encodedCskHmacDigestBlob[0] == 32) && encodedCskHmacDigestBlob[1] == 0 && encodedCskHmacDigestBlob[2] == 0 && encodedCskHmacDigestBlob[3] == 0 ? (byte)1 : encodedCskHmacDigestBlob[0];
        return v;
    }

    public byte[] setMessageTrust(String serviceID, byte[] token) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("setMessageTrust", this);
        ipfFunction.addParameter("serviceID", serviceID);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            if (token == null || token.length == 0) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_null_soap_request"));
            }
            if (serviceID == null || serviceID.length() == 0) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
            }
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("setMessageTrust", this).logExit(e);
            throw e;
        }
        this.validateIdentity();
        this.updateCSK();
        try {
            ByteArrayOutputStream baos;
            Document doc;
            try {
                doc = this.domParse(token);
            }
            catch (Exception e) {
                throw new CAMCryptoException(e);
            }
            Element soapHeaderElem = this.getSoapHeaderElement(doc);
            if (soapHeaderElem == null) {
                IPFTraceFunction.trace("Error no SOAP header element");
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_no_soap_header_element_found"));
            }
            Element biBusHeaderElem = this.getBIBusHeaderElement(soapHeaderElem);
            if (biBusHeaderElem == null) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_no_bibus_header_element_found"));
            }
            Element camProtectElem = CAMCryptoUtilities.getChildElementByName(biBusHeaderElem, CAM_PROTECTION);
            if (camProtectElem != null) {
                Attr xsiAttr = camProtectElem.getAttributeNode(NIL_ATTR);
                if (xsiAttr != null) {
                    Element parent = (Element)camProtectElem.getParentNode();
                    if (parent != null) {
                        parent.removeChild(camProtectElem);
                    }
                } else {
                    throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_message_already_trusted"));
                }
            }
            byte[] encodedHMACDigest = null;
            Configuration config = Configuration.getInstance();
            String digestAlgorithm = config.getDigestAlgorithm();
            Mac currentCskMac = this.getCurrentCSKMac(digestAlgorithm);
            byte[] hmacValue = this.genMacFromToken(serviceID, doc, biBusHeaderElem, currentCskMac);
            byte[] currentCskDigest = this.getCurrentCSKDigest();
            EncodedCSK_HMAC_Digest2 cskHmacDigest = new EncodedCSK_HMAC_Digest2(currentCskDigest, digestAlgorithm.getBytes(), hmacValue);
            encodedHMACDigest = cskHmacDigest.getEncodedHMACDigest();
            byte[] cammacenc = CryptoWrapper.encodeBase64(encodedHMACDigest);
            Element camProt = (Element)biBusHeaderElem.appendChild(doc.createElement(CAM_PROTECTION));
            camProt.setAttribute(NS_ATTR, NS_TYPE);
            camProt.setAttribute(TYPE_ATTR, CAM_PROTECTION_TYPE);
            Element camvalueProt = (Element)camProt.appendChild(doc.createElement(TRUSTED_VALUE));
            camvalueProt.setAttribute(TYPE_ATTR, TRUSTED_VALUE_TYPE);
            camvalueProt.appendChild(doc.createTextNode(new String(cammacenc)));
            Element serviceIdElem = (Element)camProt.appendChild(doc.createElement(SERVICE_ID));
            serviceIdElem.setAttribute(TYPE_ATTR, SERVICE_ID_TYPE);
            serviceIdElem.appendChild(doc.createTextNode(serviceID));
            try {
                baos = new ByteArrayOutputStream();
                PooledObject pooledTransformer = TransformerPool.getInstance().get();
                Transformer transformer = (Transformer)pooledTransformer.getObject();
                transformer.transform(new DOMSource(doc), new StreamResult(baos));
                pooledTransformer.release();
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_serialize_trusted_xml"));
            }
            byte[] protectedToken = baos.toByteArray();
            new IPFTraceFunction("setMessageTrust", this).logExit(protectedToken);
            return protectedToken;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("setMessageTrust", this).logExit(e);
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isTrusted(byte[] token) throws CAMCryptoException {
        ipfFunction = new IPFTraceFunction("isTrusted", this);
        ipfFunction.addParameter("token", token);
        ipfFunction.logEntry();
        ipfFunction = null;
        this.validateIdentity();
        try {
            if (token == null || token.length == 0) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_null_soap_request"));
            }
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("isTrusted", this).logExit(e);
            throw e;
        }
        try {
            block11: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                block12: {
                                                    bReturn = false;
                                                    try {
                                                        doc = this.domParse(token);
                                                    }
                                                    catch (Exception e) {
                                                        IPFTraceFunction.trace("Error parsing SOAP document");
                                                        break block11;
                                                    }
                                                    soapHeaderElem = this.getSoapHeaderElement(doc);
                                                    if (soapHeaderElem != null) break block12;
                                                    IPFTraceFunction.trace("Error no SOAP header element");
                                                    break block11;
                                                }
                                                biBusHeaderElem = this.getBIBusHeaderElement(soapHeaderElem);
                                                if (biBusHeaderElem != null) break block13;
                                                IPFTraceFunction.trace("Error no BI Bus header element");
                                                break block11;
                                            }
                                            camProtElem = CAMCryptoUtilities.getChildElementByName(biBusHeaderElem, "CAMProtect");
                                            if (camProtElem != null) break block14;
                                            IPFTraceFunction.trace("Error no CAMProtect element");
                                            break block11;
                                        }
                                        servIdElem = CAMCryptoUtilities.getChildElementByName(camProtElem, "serviceId");
                                        if (servIdElem != null) break block15;
                                        IPFTraceFunction.trace("Error no service ID element under the CAMProtect element");
                                        break block11;
                                    }
                                    trustValElem = CAMCryptoUtilities.getChildElementByName(camProtElem, "trustedValue");
                                    if (trustValElem != null) break block16;
                                    IPFTraceFunction.trace("Error no trusted value element under the CAMProtect element");
                                    break block11;
                                }
                                truststring = CAMCryptoUtilities.getElementText(trustValElem);
                                if (truststring != null && truststring.length() != 0) break block17;
                                IPFTraceFunction.trace("Error no trustedValue element");
                                break block11;
                            }
                            serviceID = CAMCryptoUtilities.getElementText(servIdElem);
                            if (serviceID != null && serviceID.length() != 0) break block18;
                            IPFTraceFunction.trace("Error no service id, empty or missing");
                            break block11;
                        }
                        origmac = CryptoWrapper.decodeBase64(truststring.getBytes());
                        if (origmac.length >= 4) break block19;
                        IPFTraceFunction.trace("Error trusted value too short");
                        break block11;
                    }
                    version = this.getHMACTokenVersion(origmac);
                    thisMac = null;
                    if (version != 2) break block20;
                    cskHmacDigest1 = new EncodedCSK_HMAC_Digest2(origmac, this.hmacLength);
                    digestAlgorithm = new String(cskHmacDigest1.getAlgorithm());
                    config = Configuration.getInstance();
                    hmacAlgorithm = config.getHMACAlgorithm(digestAlgorithm);
                    thisMac = CAMCryptoUtilities.getMacGivenCSKDigest(cskHmacDigest1.getCSKDigest(), hmacAlgorithm);
                    origmac = cskHmacDigest1.getHMACDigest();
                    ** GOTO lbl79
                }
                if (version != 1) {
                    e = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_verify_trusted_request_failed"));
                    new IPFAuditFunction("isTrusted", this).logExit(e);
                } else {
                    cskHmacDigest = new EncodedCSK_HMAC_Digest(origmac, this.hmacLength);
                    thisMac = this.getMacGivenCSKDigest(cskHmacDigest.getCSKDigest());
                    origmac = cskHmacDigest.getHMACDigest();
lbl79:
                    // 2 sources

                    cammac = this.genMacFromToken(serviceID, doc, biBusHeaderElem, thisMac);
                    if (Arrays.equals(cammac, origmac)) {
                        bReturn = true;
                    } else {
                        IPFTraceFunction.trace("Error HMAC mismatch, message was modified");
                    }
                }
            }
            new IPFTraceFunction("isTrusted", this).logExit(bReturn);
            return bReturn;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("isTrusted", this).logExit(e);
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_verify_trusted_request_failed"));
        }
    }

    public String getServiceID(byte[] token) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("getServiceID", this);
        ipfFunction.addParameter("token", token);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            Document doc;
            try {
                doc = this.domParse(token);
            }
            catch (Exception e) {
                throw new CAMCryptoException(e);
            }
            Element soapHeaderElem = CAMCryptoUtilities.getChildElementByName(doc.getDocumentElement(), SOAP_HEADER);
            if (soapHeaderElem == null) {
                return "";
            }
            Element biBusHeaderElem = CAMCryptoUtilities.getChildElementByName(soapHeaderElem, BI_BUS_HEADER);
            if (biBusHeaderElem == null) {
                return "";
            }
            Element camProtElem = CAMCryptoUtilities.getChildElementByName(biBusHeaderElem, CAM_PROTECTION);
            if (camProtElem == null) {
                return "";
            }
            Element servIdElem = CAMCryptoUtilities.getChildElementByName(camProtElem, SERVICE_ID);
            if (servIdElem == null) {
                return "";
            }
            String originator = CAMCryptoUtilities.getElementText(servIdElem);
            new IPFTraceFunction("getServiceID", this).logExit(originator);
            return originator;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("getServiceID", this).logExit(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] genMacFromToken(String serviceID, Document doc, Element biBusHeaderElem, Mac mac) throws CAMCryptoException {
        byte[] result;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Element bodyElem;
            PooledObject pooledC14N = CanonicalizerPool.getInstance().get();
            Canonicalizer c14n = (Canonicalizer)pooledC14N.getObject();
            Element camElem = CAMCryptoUtilities.getChildElementByName(biBusHeaderElem, BIBUS_CAM);
            if (camElem != null) {
                c14n.canonicalizeSubtree((Node)camElem, (OutputStream)baos);
            }
            if ((bodyElem = CAMCryptoUtilities.getChildElementByName(doc.getDocumentElement(), BIBUS_BODY)) != null) {
                c14n.canonicalizeSubtree((Node)bodyElem, (OutputStream)baos);
            }
            baos.write(serviceID.getBytes());
            pooledC14N.release();
            Mac mac2 = mac;
            synchronized (mac2) {
                mac.reset();
                result = mac.doFinal(baos.toByteArray());
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_doc_obj"));
        }
        return result;
    }

    private Element getSoapHeaderElement(Document doc) {
        Element elem = doc.getDocumentElement();
        Element soapHdr = CAMCryptoUtilities.getChildElementByName(elem, SOAP_HEADER);
        return soapHdr;
    }

    private Element getBIBusHeaderElement(Element soapHeaderElem) {
        Element biBusHeaderElem = CAMCryptoUtilities.getChildElementByName(soapHeaderElem, BI_BUS_HEADER);
        return biBusHeaderElem;
    }

    static {
        Init.init();
        Canonicalizer.registerDefaultAlgorithms();
    }
}

