/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CSKDigest;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Mac;
import org.bouncycastle.util.encoders.DecoderException;

public class UserSessionIDSession
extends DefaultAdditionalInfoHandler {
    public static final byte VERSION1 = 1;
    public static final byte VERSION2 = 2;
    private static final int CAM_USID_SECOND_IN_DAY = 86400;
    private static final int CAM_USID_TIME_LENGTH_BYTES = 4;
    private static final int CAM_USID_USER_SESSION_ID_LENGTH_BYTES = 4;
    private static final int CAM_USID_USER_SESSION_ID_LENGTH = 10;
    private static final int CAM_USID_CSK_DIGEST_LENGTH_BYTES = 4;
    private static final int CAM_USID_HMAC_LENGTH_BYTES = 4;
    private static final int CAM_USID_DIGEST_ALG_LENGTH_BYTES = 4;
    private static String CAM_USID_CLASS_ID = "UserSessionID";
    private static final String GENERATE_AUTHENTICITY_TOKEN = "generateAuthenticityToken";
    private static final String SHA1 = "SHA1";
    private static final String AUTHTOKEN_VERSION1 = "V1";
    private static final String AUTHTOKEN_VERSION = "V1";
    private SecureRandom random = null;
    private byte version = (byte)2;

    public UserSessionIDSession() throws CAMCryptoException {
        this.random = JVMEnvironment.getInstance().getSecureRandom();
    }

    public byte[] generateAuthenticityToken(byte[] userSessionID) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction(GENERATE_AUTHENTICITY_TOKEN, this);
        ipfFunction.logEntry();
        UIDToken uidToken = new UIDToken();
        int res = this.verifyUserSessionID(userSessionID, uidToken);
        if (res == 1) {
            byte[] authToken = this.generateAuthenticityToken(uidToken);
            ipfFunction.logExit(authToken);
            return authToken;
        }
        throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_failed_authToken_invalid_userSessionID"));
    }

    public byte[] generateOldFormatAuthToken(byte[] userSessionID) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction(GENERATE_AUTHENTICITY_TOKEN, this);
        ipfFunction.logEntry();
        UIDToken uidToken = new UIDToken();
        int res = this.verifyUserSessionID(userSessionID, uidToken);
        if (res == 1) {
            byte[] authToken = this.generateOldFormatAuthenticityToken(uidToken);
            ipfFunction.logExit(authToken);
            return authToken;
        }
        throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_failed_authToken_invalid_userSessionID"));
    }

    private byte[] generateOldFormatAuthenticityToken(UIDToken uidToken) throws CAMCryptoException {
        String digestAlg = SHA1;
        MessageDigest md = CAMCryptoUtilities.getMessageDigest(SHA1);
        byte[] authToken = md.digest(uidToken.getUserSessionID());
        authToken = CryptoWrapper.encodeBase64(authToken);
        return authToken;
    }

    private byte[] generateAuthenticityToken(UIDToken uidToken) throws CAMCryptoException {
        byte[] authToken = uidToken.getHMAC();
        int authTokenLength = "V1".length() + authToken.length;
        byte[] visionedAuthToken = new byte[authTokenLength];
        int pos = 0;
        System.arraycopy("V1".getBytes(), 0, visionedAuthToken, pos, "V1".length());
        System.arraycopy(authToken, 0, visionedAuthToken, pos += "V1".length(), authToken.length);
        byte[] b64VersionedAuthToken = CryptoWrapper.encodeBase64(visionedAuthToken);
        return b64VersionedAuthToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateHMAC(byte[] cskDigest, byte[] userSessionID, String digestAlg, byte version) throws CAMCryptoException {
        byte[] md_value2;
        Mac hmac2;
        byte[] md_value1;
        Mac hmac1;
        String hmacAlg = Configuration.getInstance().getHMACAlgorithm(digestAlg);
        Mac mac = hmac1 = CAMCryptoUtilities.getMacGivenCSKDigest(cskDigest, hmacAlg);
        synchronized (mac) {
            hmac1.update(version);
            hmac1.update(CAM_USID_CLASS_ID.getBytes());
            md_value1 = hmac1.doFinal();
        }
        Mac mac2 = hmac2 = CAMCryptoUtilities.getMacGivenCSKDigest(cskDigest, hmacAlg);
        synchronized (mac2) {
            hmac2.update(userSessionID);
            hmac2.update(md_value1);
            md_value2 = hmac2.doFinal();
        }
        return md_value2;
    }

    private byte[] generateToken(byte version, byte[] userSessionID, byte[] timestampBytes, byte[] cskDigest, byte[] hmac, String digestAlg) {
        int userSessionIDLen = 10;
        byte[] userSessionIDLenBytes = CryptoWrapper.toByteArray(10);
        int timestampLen = timestampBytes.length;
        byte[] timestampLenBytes = CryptoWrapper.toByteArray(timestampLen);
        int cskDigestLen = cskDigest.length;
        byte[] cskDigestLenBytes = CryptoWrapper.toByteArray(cskDigestLen);
        int hmacLen = hmac.length;
        byte[] hmacLenBytes = CryptoWrapper.toByteArray(hmacLen);
        int tokenLength = 5 + timestampBytes.length + 4 + userSessionID.length + 4 + cskDigest.length + 4 + hmac.length;
        if (version == 2) {
            tokenLength += 4 + digestAlg.getBytes().length;
        }
        byte[] token = new byte[tokenLength];
        int pos = 0;
        token[pos] = (byte)(version & 0xFF);
        System.arraycopy(timestampLenBytes, 0, token, ++pos, 4);
        System.arraycopy(timestampBytes, 0, token, pos += 4, timestampLen);
        System.arraycopy(userSessionIDLenBytes, 0, token, pos += timestampLen, 4);
        System.arraycopy(userSessionID, 0, token, pos += 4, 10);
        System.arraycopy(cskDigestLenBytes, 0, token, pos += 10, 4);
        System.arraycopy(cskDigest, 0, token, pos += 4, cskDigestLen);
        pos += cskDigestLen;
        if (version == 2) {
            byte[] digestAlgBytes = digestAlg.getBytes();
            byte[] digestAlgLenBytes = CryptoWrapper.toByteArray(digestAlgBytes.length);
            System.arraycopy(digestAlgLenBytes, 0, token, pos, 4);
            System.arraycopy(digestAlgBytes, 0, token, pos += 4, digestAlgBytes.length);
            pos += digestAlgBytes.length;
        }
        System.arraycopy(hmacLenBytes, 0, token, pos, 4);
        System.arraycopy(hmac, 0, token, pos += 4, hmacLen);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateUserSessionID(int timeout) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("generateUserSessionID", this);
        ipfFunction.logEntry();
        byte[] timestampBytes = this.getTimeStamp(timeout);
        byte[] userSessionID = new byte[10];
        SecureRandom secureRandom = this.random;
        synchronized (secureRandom) {
            this.random.nextBytes(userSessionID);
        }
        String digestAlg = this.version == 1 ? Configuration.getInstance().getSHAAlgorithm() : Configuration.getInstance().getDigestAlgorithm();
        byte[] cskDigest = CSKDigest.getInstance().getCurrentCSKDigest();
        byte[] hmac = this.generateHMAC(cskDigest, userSessionID, digestAlg, this.version);
        byte[] token = this.generateToken(this.version, userSessionID, timestampBytes, cskDigest, hmac, digestAlg);
        byte[] base64token = CryptoWrapper.encodeBase64(token);
        ipfFunction.logExit(base64token);
        return base64token;
    }

    private byte[] getTimeStamp(int timeout) {
        Date now = new Date();
        long lNow = now.getTime();
        long lifeSeconds = timeout * 86400;
        long timestamp = (lNow /= 1000L) + lifeSeconds;
        byte[] timestampBytes = CryptoWrapper.toByteArray(timestamp, 0, 8);
        return timestampBytes;
    }

    public void setVersion(byte v) throws CAMCryptoException {
        if (v != 1 && v != 2) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_message_version"));
        }
        this.version = v;
    }

    public byte[] updateUserSessionID(byte[] base64Token, int timeout) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("updateUserSessionID", this);
        ipfFunction.logEntry();
        UIDToken uidToken = new UIDToken();
        int res = this.verifyUserSessionID(base64Token, uidToken);
        if (res == 1 || res == 0) {
            byte[] timestampBytes = this.getTimeStamp(timeout);
            byte[] updatedToken = this.generateToken(uidToken.getVersion(), uidToken.getUserSessionID(), timestampBytes, uidToken.getCSKDigest(), uidToken.getHMAC(), uidToken.getDigestAlg());
            byte[] updatedUIDToken = CryptoWrapper.encodeBase64(updatedToken);
            ipfFunction.logExit(updatedUIDToken);
            return updatedUIDToken;
        }
        throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_failed_updateUID_invalid_userSessionID"));
    }

    public int verifyAuthenticityToken(byte[] base64AuthToken, byte[] base64UserSessionID) throws CAMCryptoException {
        String methodId = new String(this.getClass().getName() + ".verifyAuthenticityToken");
        if (base64AuthToken == null || base64AuthToken.length == 0) {
            IPFTraceFunction.trace(methodId + " - empty authenticity token.");
            return -1;
        }
        UIDToken uidToken = new UIDToken();
        int res = this.verifyUserSessionID(base64UserSessionID, uidToken);
        if (res != 1) {
            IPFTraceFunction.trace(methodId + " - invalid UserSessionID.");
            return -1;
        }
        byte[] generatedAuthToken = null;
        byte[] authToken = null;
        try {
            authToken = CryptoWrapper.decodeBase64(base64AuthToken);
        }
        catch (DecoderException e) {
            IPFTraceFunction.trace(methodId + " - invalid Based 64 AuthToken. " + e.getMessage());
            return -1;
        }
        if (authToken.length == 20) {
            byte[] oldFormatAuthToken = this.generateOldFormatAuthToken(base64UserSessionID);
            if (JVMEnvironment.getInstance().RejectNonFipsJavaScriptHashes()) {
                IPFTraceFunction.trace(methodId + " - Old rejected because of RejectNonFipsJavaScriptHashes flag.");
                return -1;
            }
            if (Arrays.equals(oldFormatAuthToken, base64AuthToken)) {
                res = 1;
                IPFTraceFunction.trace(methodId + " - Old format authenticityToken valid.");
                IPFTraceFunction.trace(methodId + " - input AuthToken:" + IPFTraceLogger.toBase64String(base64AuthToken));
                IPFTraceFunction.trace(methodId + " - generated AuthToken:" + IPFTraceLogger.toBase64String(oldFormatAuthToken));
            } else {
                res = -1;
                IPFTraceFunction.trace(methodId + " - Old format authenticityToken not valid.");
                IPFTraceFunction.trace(methodId + " - input AuthToken:" + IPFTraceLogger.toBase64String(base64AuthToken));
                IPFTraceFunction.trace(methodId + " - generated AuthToken:" + IPFTraceLogger.toBase64String(oldFormatAuthToken));
            }
            return res;
        }
        byte[] version = new byte["V1".length()];
        System.arraycopy(authToken, 0, version, 0, "V1".length());
        if (!Arrays.equals(version, "V1".getBytes())) {
            IPFTraceFunction.trace(methodId + " - Invalid authenticityToken version.");
            IPFTraceFunction.trace(methodId + " - input AuthToken:" + IPFTraceLogger.toBase64String(base64AuthToken));
            return -1;
        }
        generatedAuthToken = this.generateAuthenticityToken(base64UserSessionID);
        if (Arrays.equals(generatedAuthToken, base64AuthToken)) {
            res = 1;
            IPFTraceFunction.trace(methodId + " - AuthenticityToken valid.");
            IPFTraceFunction.trace(methodId + " - input AuthToken:" + IPFTraceLogger.toBase64String(base64AuthToken));
            IPFTraceFunction.trace(methodId + " - generated AuthToken:" + IPFTraceLogger.toBase64String(generatedAuthToken));
        } else {
            res = -1;
            IPFTraceFunction.trace(methodId + " - AuthenticityToken not valid.");
            IPFTraceFunction.trace(methodId + " - input AuthToken:" + IPFTraceLogger.toBase64String(base64AuthToken));
            IPFTraceFunction.trace(methodId + " - generated AuthToken:" + IPFTraceLogger.toBase64String(generatedAuthToken));
        }
        return res;
    }

    private int verifyHMAC(UIDToken uidToken, String digestAlg) throws CAMCryptoException {
        byte[] md_value2 = this.generateHMAC(uidToken.getCSKDigest(), uidToken.getUserSessionID(), digestAlg, uidToken.getVersion());
        if (Arrays.equals(md_value2, uidToken.getHMAC())) {
            return 1;
        }
        return -1;
    }

    private int verifyTimeout(UIDToken uidToken) {
        Date now = new Date();
        long lNow = now.getTime();
        if (uidToken.getTimeStamp() - (lNow /= 1000L) < 0L) {
            return 0;
        }
        return 1;
    }

    private int verifyUIDToken(UIDToken uidToken) throws CAMCryptoException {
        String digestAlg;
        String methodId = new String(this.getClass().getName() + ".verifyUIDToken");
        int res = -1;
        if (uidToken.getVersion() == 1) {
            digestAlg = Configuration.getInstance().getSHAAlgorithm();
            IPFTraceFunction.trace(methodId + " - VERSION1 digestAlg = " + digestAlg);
        } else {
            digestAlg = uidToken.getDigestAlg();
            IPFTraceFunction.trace(methodId + " - VERSION2 digestAlg = " + digestAlg);
        }
        res = this.verifyHMAC(uidToken, digestAlg);
        IPFTraceFunction.trace(methodId + " - verifyHMAC res = " + res);
        if (res == 1) {
            res = this.verifyTimeout(uidToken);
        }
        IPFTraceFunction.trace(methodId + " - verifyTimeout res = " + res);
        return res;
    }

    public int verifyUserSessionID(byte[] base64Token) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("verifyUserSessionID", this);
        ipfFunction.logEntry();
        UIDToken uidToken = new UIDToken();
        int res = this.verifyUserSessionID(base64Token, uidToken);
        ipfFunction.logExit(res == 1);
        return res;
    }

    private int verifyUserSessionID(byte[] base64Token, UIDToken uidToken) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("verifyUserSessionIDToken", this);
        ipfFunction.logEntry();
        int res = uidToken.parseToken(base64Token);
        IPFTraceFunction.trace("parseToken = " + res);
        if (res == 1) {
            res = this.verifyUIDToken(uidToken);
        }
        IPFTraceFunction.trace("verifyUIDToken = " + res);
        ipfFunction.logExit(res == 1);
        return res;
    }

    private class UIDToken {
        byte tokenVersion;
        long timestamp;
        byte[] userSessionID;
        byte[] cskDigest;
        String digestAlg;
        byte[] hmac;

        public byte[] getCSKDigest() {
            return this.cskDigest;
        }

        public String getDigestAlg() {
            return this.digestAlg;
        }

        public byte[] getHMAC() {
            return this.hmac;
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public byte[] getUserSessionID() {
            return this.userSessionID;
        }

        public byte getVersion() {
            return this.tokenVersion;
        }

        public int parseToken(byte[] token) {
            byte[] uidToken;
            String methodId = new String(this.getClass().getName() + ".parseToken");
            if (token == null) {
                IPFTraceFunction.trace(methodId + " - Invalide input of empty token");
                return -1;
            }
            IPFTraceFunction.trace(methodId + " - token size = " + token.length);
            try {
                uidToken = CryptoWrapper.decodeBase64(token);
            }
            catch (Exception e) {
                IPFTraceFunction.trace(methodId + " - Failed decode Base 64.");
                return -1;
            }
            IPFTraceFunction.trace(methodId + " - decodeBase64 OK");
            this.tokenVersion = uidToken[0];
            if (this.tokenVersion != 1 && this.tokenVersion != 2) {
                return -1;
            }
            IPFTraceFunction.trace(methodId + " - version check OK.");
            int pos = 1;
            byte[] timestampLenBytes = new byte[4];
            System.arraycopy(uidToken, pos, timestampLenBytes, 0, 4);
            int timestampLen = CryptoWrapper.toInt(timestampLenBytes, 0, 4);
            byte[] timestamp = new byte[timestampLen];
            System.arraycopy(uidToken, pos += 4, timestamp, 0, timestampLen);
            this.timestamp = CryptoWrapper.toLong(timestamp, 8);
            IPFTraceFunction.trace(methodId + " - time OK");
            byte[] userSessionIDLenBytes = new byte[4];
            System.arraycopy(uidToken, pos += timestampLen, userSessionIDLenBytes, 0, 4);
            int userSessionIDLen = CryptoWrapper.toInt(userSessionIDLenBytes, 0, 4);
            this.userSessionID = new byte[userSessionIDLen];
            System.arraycopy(uidToken, pos += 4, this.userSessionID, 0, userSessionIDLen);
            IPFTraceFunction.trace(methodId + " - userSessinID OK");
            byte[] cskDigestLenBytes = new byte[4];
            System.arraycopy(uidToken, pos += userSessionIDLen, cskDigestLenBytes, 0, 4);
            int cskDigestLen = CryptoWrapper.toInt(cskDigestLenBytes, 0, 4);
            this.cskDigest = new byte[cskDigestLen];
            System.arraycopy(uidToken, pos += 4, this.cskDigest, 0, cskDigestLen);
            pos += cskDigestLen;
            IPFTraceFunction.trace(methodId + " - CSK digest OK");
            if (this.tokenVersion == 2) {
                IPFTraceFunction.trace(methodId + " - UserSessionIDSession.VERSION2");
                byte[] digestAlgLenBytes = new byte[4];
                System.arraycopy(uidToken, pos, digestAlgLenBytes, 0, 4);
                int digestAlgLen = CryptoWrapper.toInt(digestAlgLenBytes, 0, 4);
                byte[] digestAlgBytes = new byte[digestAlgLen];
                System.arraycopy(uidToken, pos += 4, digestAlgBytes, 0, digestAlgLen);
                this.digestAlg = new String(digestAlgBytes);
                pos += digestAlgLen;
                IPFTraceFunction.trace(methodId + " - algorithm OK");
            }
            byte[] hmacLenBytes = new byte[4];
            System.arraycopy(uidToken, pos, hmacLenBytes, 0, 4);
            int hmacLen = CryptoWrapper.toInt(hmacLenBytes, 0, 4);
            this.hmac = new byte[hmacLen];
            System.arraycopy(uidToken, pos += 4, this.hmac, 0, hmacLen);
            IPFTraceFunction.trace(methodId + " - HMAC OK");
            return 1;
        }
    }
}

