/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.casync;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMCryptoServerException;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.casync.CaCacheMessaging;
import com.cognos.accman.jcam.crypto.casync.CaFreshnessHandler;
import com.cognos.accman.jcam.crypto.casync.CaSyncHandler;
import com.cognos.accman.jcam.crypto.casync.EncodedCAMessage;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class CARequestHandler
extends DefaultAdditionalInfoHandler {
    static IPFTraceLogger caTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CA");
    private String locale;
    private static final byte VERSION_ONE = 1;
    private MessageDigest md = null;

    public CARequestHandler(String serviceID) throws CAMCryptoException {
        caTraceLogger.logEnter();
        this.locale = "en_US";
    }

    public byte[] handleCARequest(byte[] rawRequest) throws CAMCryptoException {
        caTraceLogger.logEnter();
        caTraceLogger.trace("rawRequest" + rawRequest);
        byte[] barray = null;
        try {
            String jceProvider;
            byte[] byteDigestAlgorithm;
            byte reqVersion;
            CaFreshnessHandler cafh;
            Configuration config = Configuration.getInstance();
            if (!config.getUsingThirdPartyCA() && (cafh = CaFreshnessHandler.getInstance()).needSync()) {
                CaSyncHandler cash = CaSyncHandler.getInstance();
                cash.synchronizeCaCerts();
            }
            if ((reqVersion = (rawRequest = CryptoWrapper.decodeBase64(rawRequest))[0]) != 2 && reqVersion != 3 && reqVersion != 4) {
                CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException("CAM_CRP_cacache_invalid_msg_version");
                return CAMCryptoUtilities.buildServerError(this.locale, reqVersion, (byte)9, camCryptoServerException);
            }
            CaCacheMessaging caCacheMessaging = new CaCacheMessaging(reqVersion);
            EncodedCAMessage caRequest = new EncodedCAMessage();
            boolean bParseRet = caRequest.parseCAMessage(rawRequest);
            if (!bParseRet) {
                CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException("CAM_CRP_cacache_invalid_msg_type");
                return CAMCryptoUtilities.buildServerError(this.locale, reqVersion, (byte)9, camCryptoServerException);
            }
            byte reqType = caRequest.getType();
            byte[] loc = caRequest.getLocale();
            if (loc != null && loc.length != 0) {
                this.locale = new String(loc);
            }
            if ((byteDigestAlgorithm = caRequest.getDigestAlgorithm()) != null && byteDigestAlgorithm.length != 0) {
                String digestAlgorithm = new String(byteDigestAlgorithm);
                if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                    jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                    this.md = MessageDigest.getInstance(digestAlgorithm, jceProvider);
                } else {
                    this.md = MessageDigest.getInstance(digestAlgorithm);
                }
            } else {
                String shaAlg = config.getSHAAlgorithm();
                try {
                    if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                        jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                        this.md = MessageDigest.getInstance(shaAlg, jceProvider);
                    } else {
                        this.md = MessageDigest.getInstance(shaAlg);
                    }
                }
                catch (Exception e) {
                    CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_request_error"));
                    caTraceLogger.logExit(cce);
                    throw cce;
                }
            }
            byte[] digest = caRequest.getDigest();
            byte[] passbytes = CaCacheMessaging.getPassbytes();
            this.md.update(passbytes);
            this.md.update(reqVersion);
            this.md.update(reqType);
            if (reqType == 5) {
                byte[] addcert = caRequest.getAdditionalData();
                this.md.update(addcert);
            }
            byte[] tmpDigest = this.md.digest();
            this.md.update(passbytes);
            this.md.update(tmpDigest);
            byte[] mac = this.md.digest();
            if (!MessageDigest.isEqual(mac, digest)) {
                CAMCryptoServerException camCryptoServerException = new CAMCryptoServerException("CAM_CRP_cacache_digest_failure");
                return CAMCryptoUtilities.buildServerError(this.locale, reqVersion, (byte)9, camCryptoServerException);
            }
            CaFreshnessHandler cfh = CaFreshnessHandler.getInstance();
            switch (reqType) {
                case 1: {
                    Integer f = cfh.getCSFreshness();
                    barray = caCacheMessaging.createFreshnessResponse(f);
                    break;
                }
                case 3: {
                    CaSyncHandler cash = CaSyncHandler.getInstance();
                    Vector certs = cash.getLocalCSCache();
                    barray = caCacheMessaging.createGetResponse(certs);
                    break;
                }
                case 10: {
                    CaSyncHandler cash = CaSyncHandler.getInstance();
                    Vector<X509Certificate> certs = cash.getLocallyGeneratedCerts();
                    barray = caCacheMessaging.createGetResponse(certs);
                    break;
                }
                case 5: {
                    byte[] addcert = caRequest.getAdditionalData();
                    boolean success = true;
                    try {
                        CaSyncHandler cash = CaSyncHandler.getInstance();
                        cash.addCertToCSwithCaCache(addcert);
                    }
                    catch (CAMCryptoException e) {
                        success = false;
                    }
                    barray = caCacheMessaging.createAddResponse(success);
                    break;
                }
                default: {
                    CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_invalid_msg_type"));
                    caTraceLogger.logExit(cce);
                    throw cce;
                }
            }
        }
        catch (CAMCryptoException e) {
            caTraceLogger.logExit(e);
            throw e;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_request_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        caTraceLogger.logExit(new String(barray));
        return barray;
    }
}

