/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.casync;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.casync.EncodedCAMessage;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.HttpClientInitializer;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.PriorityUrlList;
import com.cognos.accman.res.MessageSet;
import java.net.ConnectException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class CaCacheMessaging {
    private static final String CACACHE_REQ_HEAD = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">\n<SOAP-ENV:Header>\n<bus:biBusHeader xsi:type=\"bus:biBusHeader\">\n<CAM xsi:nil=\"true\"/>\n<CAMProtect xsi:type=\"bus:CAMProtect\">\n<trustedValue xsi:type=\"xsd:base64Binary\">";
    private static final String CACACHE_REQ_TAIL = "</trustedValue >\n<serviceId xsi:type=\"xsd:string\">CAMconfig</serviceId>\n</CAMProtect>\n</bus:biBusHeader>\n</SOAP-ENV:Header>\n<SOAP-ENV:Body>\n<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\">\n<search xsi:type=\"xsd:string\">/directory</search>\n<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\">\n<item xsi:type=\"cm:propEnum\">cachedCACertificates</item>\n</properties>\n</cm:query>\n</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>\n";
    static IPFTraceLogger caTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CA");
    private byte version;

    public static byte[] getPassbytes() throws CAMCryptoException {
        return Configuration.getInstance().getCAPassword().getBytes();
    }

    public CaCacheMessaging() {
        this.version = (byte)4;
    }

    public CaCacheMessaging(byte theVersion) {
        this.version = theVersion;
    }

    public byte[] createFreshnessRequest() throws CAMCryptoException {
        caTraceLogger.logEnter();
        byte type = 1;
        byte[] passbytes = CaCacheMessaging.getPassbytes();
        MessageDigest md = null;
        String digestAlgorithm = this.getTokenGenerationDigestAlgorithm();
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(digestAlgorithm, jceProvider);
            } else {
                md = MessageDigest.getInstance(digestAlgorithm);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_digest_alg_not_found"));
        }
        md.update(passbytes);
        md.update(this.version);
        md.update(type);
        byte[] tmpDigest = md.digest();
        md.update(passbytes);
        md.update(tmpDigest);
        byte[] mac = md.digest();
        byte[] locale = CAMCryptoUtilities.findLocale().getBytes();
        EncodedCAMessage caRequest = null;
        if (this.version == 2) {
            caRequest = new EncodedCAMessage(locale, type, mac, null);
        } else if (this.version == 3 || this.version == 4) {
            caRequest = new EncodedCAMessage(locale, type, mac, digestAlgorithm.getBytes(), null, this.version);
        }
        byte[] b64array = caRequest.genCAMessage();
        if (b64array.length > 0) {
            caTraceLogger.logExit(new String(b64array));
        } else {
            caTraceLogger.logExit(false);
        }
        return b64array;
    }

    public byte[] createFreshnessResponse(Integer f) throws CAMCryptoException {
        caTraceLogger.logEnter();
        byte type = 2;
        byte[] baFresh = CryptoWrapper.toByteArray(f);
        byte[] passbytes = CaCacheMessaging.getPassbytes();
        MessageDigest md = null;
        String digestAlgorithm = this.getTokenGenerationDigestAlgorithm();
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(digestAlgorithm, jceProvider);
            } else {
                md = MessageDigest.getInstance(digestAlgorithm);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_digest_alg_not_found"));
        }
        md.update(passbytes);
        md.update(this.version);
        md.update(type);
        md.update(baFresh);
        byte[] digRespTmp = md.digest();
        md.update(passbytes);
        md.update(digRespTmp);
        byte[] digResp = md.digest();
        byte[] locale = CAMCryptoUtilities.findLocale().getBytes();
        EncodedCAMessage caRequest = null;
        if (this.version == 2) {
            caRequest = new EncodedCAMessage(locale, type, digResp, baFresh);
        } else if (this.version == 3 || this.version == 4) {
            caRequest = new EncodedCAMessage(locale, type, digResp, digestAlgorithm.getBytes(), baFresh, this.version);
        }
        byte[] b64array = caRequest.genCAMessage();
        if (b64array.length > 0) {
            caTraceLogger.logExit(new String(b64array));
        } else {
            caTraceLogger.logExit(false);
        }
        return b64array;
    }

    public Integer parseFreshnessRequest(byte[] payload) throws CAMCryptoException {
        Integer i = null;
        return i;
    }

    public Integer parseFreshnessResponse(byte[] b64payload) throws CAMCryptoException {
        caTraceLogger.logEnter();
        byte[] payload = CryptoWrapper.decodeBase64(b64payload);
        byte reqVersion = payload[0];
        if (reqVersion != 2 && reqVersion != 3 && reqVersion != 4) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_invalid_msg_version"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        byte[] passbytes = CaCacheMessaging.getPassbytes();
        EncodedCAMessage caRequest = new EncodedCAMessage();
        caRequest.parseCAMessage(payload);
        byte respType = caRequest.getType();
        if (respType == 9) {
            byte[] error = caRequest.getError();
            CAMCryptoUtilities.throwPeerException(error);
        } else if (respType != 2) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_invalid_msg_type"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        byte[] digest = caRequest.getDigest();
        byte[] baFresh = caRequest.getAdditionalData();
        Configuration config = Configuration.getInstance();
        String digestAlgorithm = null;
        if (reqVersion == 2) {
            digestAlgorithm = config.getSHAAlgorithm();
        } else if (reqVersion == 3 || reqVersion == 4) {
            digestAlgorithm = new String(caRequest.getDigestAlgorithm());
        }
        MessageDigest md = null;
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(digestAlgorithm, jceProvider);
            } else {
                md = MessageDigest.getInstance(digestAlgorithm);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_digest_alg_not_found"));
        }
        md.update(passbytes);
        md.update(reqVersion);
        md.update(respType);
        md.update(baFresh);
        byte[] tmpRespDigest = md.digest();
        md.update(passbytes);
        md.update(tmpRespDigest);
        byte[] macResp = md.digest();
        if (!MessageDigest.isEqual(macResp, digest)) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_digest_failure"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        Integer freshness = CryptoWrapper.toInt(baFresh, 0, 4);
        caTraceLogger.logExit(freshness.toString());
        return freshness;
    }

    public byte[] createGetRequest() throws CAMCryptoException {
        caTraceLogger.logEnter();
        byte type = 3;
        byte[] passbytes = CaCacheMessaging.getPassbytes();
        MessageDigest md = null;
        String digestAlgorithm = this.getTokenGenerationDigestAlgorithm();
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(digestAlgorithm, jceProvider);
            } else {
                md = MessageDigest.getInstance(digestAlgorithm);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_digest_alg_not_found"));
        }
        md.update(passbytes);
        md.update(this.version);
        md.update(type);
        byte[] tmpDigest = md.digest();
        md.update(passbytes);
        md.update(tmpDigest);
        byte[] mac = md.digest();
        byte[] locale = CAMCryptoUtilities.findLocale().getBytes();
        EncodedCAMessage caRequest = null;
        if (this.version == 2) {
            caRequest = new EncodedCAMessage(locale, type, mac, null);
        } else if (this.version == 3 || this.version == 4) {
            caRequest = new EncodedCAMessage(locale, type, mac, digestAlgorithm.getBytes(), null, this.version);
        }
        byte[] b64array = caRequest.genCAMessage();
        if (b64array.length > 0) {
            caTraceLogger.logExit(new String(b64array));
        } else {
            caTraceLogger.logExit(false);
        }
        return b64array;
    }

    public byte[] createGetTestRequest() throws CAMCryptoException {
        caTraceLogger.logEnter();
        byte type = 10;
        byte[] passbytes = CaCacheMessaging.getPassbytes();
        MessageDigest md = null;
        String digestAlgorithm = this.getTokenGenerationDigestAlgorithm();
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(digestAlgorithm, jceProvider);
            } else {
                md = MessageDigest.getInstance(digestAlgorithm);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_digest_alg_not_found"));
        }
        md.update(passbytes);
        md.update(this.version);
        md.update(type);
        byte[] tmpDigest = md.digest();
        md.update(passbytes);
        md.update(tmpDigest);
        byte[] mac = md.digest();
        byte[] locale = CAMCryptoUtilities.findLocale().getBytes();
        EncodedCAMessage caRequest = null;
        if (this.version == 2) {
            caRequest = new EncodedCAMessage(locale, type, mac, null);
        } else if (this.version == 3 || this.version == 4) {
            caRequest = new EncodedCAMessage(locale, type, mac, digestAlgorithm.getBytes(), null, this.version);
        }
        byte[] b64array = caRequest.genCAMessage();
        if (b64array.length > 0) {
            caTraceLogger.logExit(new String(b64array));
        } else {
            caTraceLogger.logExit(false);
        }
        return b64array;
    }

    public byte[] createGetResponse(Vector<?> certs) throws CAMCryptoException {
        caTraceLogger.logEnter();
        byte type = 4;
        byte[] passbytes = CaCacheMessaging.getPassbytes();
        MessageDigest md = null;
        String digestAlgorithm = this.getTokenGenerationDigestAlgorithm();
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(digestAlgorithm, jceProvider);
            } else {
                md = MessageDigest.getInstance(digestAlgorithm);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_digest_alg_not_found"));
        }
        Iterator<?> certIt = certs.iterator();
        md.update(passbytes);
        md.update(this.version);
        md.update(type);
        int certsize = 0;
        int numCerts = 0;
        while (certIt.hasNext()) {
            byte[] certBytes;
            Certificate cert = (Certificate)certIt.next();
            if (this.version < 4) {
                try {
                    String sigAlgOID = ((X509Certificate)cert).getSigAlgOID();
                    if (sigAlgOID.startsWith("1.2.840.10045")) {
                        continue;
                    }
                }
                catch (Exception sigAlgOID) {
                    // empty catch block
                }
            }
            try {
                certBytes = cert.getEncoded();
            }
            catch (CertificateEncodingException e) {
                CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_decode_cert"));
                caTraceLogger.logExit(cce);
                throw cce;
            }
            certsize += certBytes.length;
            ++numCerts;
            md.update(certBytes);
        }
        byte[] digRespTmp = md.digest();
        md.update(passbytes);
        md.update(digRespTmp);
        byte[] digResp = md.digest();
        int loc = 0;
        byte[] bCerts = new byte[certsize + numCerts * 4];
        for (Certificate cert : certs) {
            byte[] certBytes;
            if (this.version < 4) {
                try {
                    String sigAlgOID = ((X509Certificate)cert).getSigAlgOID();
                    if (sigAlgOID.startsWith("1.2.840.10045")) {
                        continue;
                    }
                }
                catch (Exception sigAlgOID) {
                    // empty catch block
                }
            }
            try {
                certBytes = cert.getEncoded();
            }
            catch (CertificateEncodingException e) {
                CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_decode_cert"));
                caTraceLogger.logExit(cce);
                throw cce;
            }
            byte[] baLen = CryptoWrapper.toByteArray(certBytes.length);
            System.arraycopy(baLen, 0, bCerts, loc, 4);
            System.arraycopy(certBytes, 0, bCerts, loc += 4, certBytes.length);
            loc += certBytes.length;
        }
        byte[] locale = CAMCryptoUtilities.findLocale().getBytes();
        EncodedCAMessage caRequest = null;
        if (this.version == 2) {
            caRequest = new EncodedCAMessage(locale, type, digResp, bCerts);
        } else if (this.version == 3 || this.version == 4) {
            caRequest = new EncodedCAMessage(locale, type, digResp, digestAlgorithm.getBytes(), bCerts, this.version);
        }
        byte[] b64array = caRequest.genCAMessage();
        if (b64array.length > 0) {
            caTraceLogger.logExit(new String(b64array));
        } else {
            caTraceLogger.logExit(false);
        }
        return b64array;
    }

    public Vector<X509Certificate> parseGetResponse(byte[] b64payload) throws CAMCryptoException, CertificateParsingException {
        int certLength;
        byte[] payload = CryptoWrapper.decodeBase64(b64payload);
        byte reqVersion = payload[0];
        if (reqVersion != 2 && reqVersion != 3 && reqVersion != 4) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_invalid_msg_version"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        EncodedCAMessage caRequest = new EncodedCAMessage();
        caRequest.parseCAMessage(payload);
        byte respType = caRequest.getType();
        if (respType == 9) {
            byte[] error = caRequest.getError();
            CAMCryptoUtilities.throwPeerException(error);
        } else if (respType != 4 && respType != 11) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_invalid_msg_type"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        Configuration config = Configuration.getInstance();
        String digestAlgorithm = null;
        if (reqVersion == 2) {
            digestAlgorithm = config.getSHAAlgorithm();
        } else if (reqVersion == 3 || reqVersion == 4) {
            digestAlgorithm = new String(caRequest.getDigestAlgorithm());
        }
        MessageDigest md = null;
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(digestAlgorithm, jceProvider);
            } else {
                md = MessageDigest.getInstance(digestAlgorithm);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_digest_alg_not_found"));
        }
        byte[] digest = caRequest.getDigest();
        byte[] bCerts = caRequest.getAdditionalData();
        byte[] passbytes = CaCacheMessaging.getPassbytes();
        md.update(passbytes);
        md.update(reqVersion);
        md.update(respType);
        Vector<X509Certificate> certs = new Vector<X509Certificate>();
        int end = bCerts.length;
        for (int loc = 0; loc < end; loc += certLength) {
            byte[] baCertlen = new byte[4];
            System.arraycopy(bCerts, loc, baCertlen, 0, 4);
            certLength = CryptoWrapper.toInt(baCertlen, 0, 4);
            byte[] baCert = new byte[certLength];
            System.arraycopy(bCerts, loc += 4, baCert, 0, certLength);
            X509Certificate cert = CryptoWrapper.decodeCert(baCert);
            certs.add(cert);
            md.update(baCert);
        }
        byte[] tmpRespDigest = md.digest();
        md.update(passbytes);
        md.update(tmpRespDigest);
        byte[] macResp = md.digest();
        if (!MessageDigest.isEqual(macResp, digest)) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_digest_failure"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        if (certs.size() > 0) {
            caTraceLogger.logExit(true);
        } else {
            caTraceLogger.logExit(false);
        }
        return certs;
    }

    public byte[] createAddRequest(byte[] cert) throws CAMCryptoException {
        caTraceLogger.logEnter();
        byte type = 5;
        byte[] passbytes = CaCacheMessaging.getPassbytes();
        MessageDigest md = null;
        String digestAlgorithm = this.getTokenGenerationDigestAlgorithm();
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(digestAlgorithm, jceProvider);
            } else {
                md = MessageDigest.getInstance(digestAlgorithm);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_digest_alg_not_found"));
        }
        md.update(passbytes);
        md.update(this.version);
        md.update(type);
        md.update(cert);
        byte[] tmpDigest = md.digest();
        md.update(passbytes);
        md.update(tmpDigest);
        byte[] mac = md.digest();
        byte[] locale = CAMCryptoUtilities.findLocale().getBytes();
        EncodedCAMessage caRequest = null;
        if (this.version == 2) {
            caRequest = new EncodedCAMessage(locale, type, mac, cert);
        } else if (this.version == 3 || this.version == 4) {
            caRequest = new EncodedCAMessage(locale, type, mac, digestAlgorithm.getBytes(), cert, this.version);
        }
        byte[] b64array = caRequest.genCAMessage();
        if (b64array.length > 0) {
            caTraceLogger.logExit(new String(b64array));
        } else {
            caTraceLogger.logExit(false);
        }
        return b64array;
    }

    public byte[] createAddResponse(boolean addFlag) throws CAMCryptoException {
        caTraceLogger.logEnter();
        byte type = 6;
        byte[] passbytes = CaCacheMessaging.getPassbytes();
        MessageDigest md = null;
        String digestAlgorithm = this.getTokenGenerationDigestAlgorithm();
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(digestAlgorithm, jceProvider);
            } else {
                md = MessageDigest.getInstance(digestAlgorithm);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_digest_alg_not_found"));
        }
        int iFlag = addFlag ? 1 : 0;
        byte[] bFlag = CryptoWrapper.toByteArray(iFlag);
        md.update(passbytes);
        md.update(this.version);
        md.update(type);
        md.update(bFlag);
        byte[] digRespTmp = md.digest();
        md.update(passbytes);
        md.update(digRespTmp);
        byte[] digResp = md.digest();
        byte[] locale = CAMCryptoUtilities.findLocale().getBytes();
        EncodedCAMessage caRequest = null;
        if (this.version == 2) {
            caRequest = new EncodedCAMessage(locale, type, digResp, bFlag);
        } else if (this.version == 3 || this.version == 4) {
            caRequest = new EncodedCAMessage(locale, type, digResp, digestAlgorithm.getBytes(), bFlag, this.version);
        }
        byte[] b64array = caRequest.genCAMessage();
        if (b64array.length > 0) {
            caTraceLogger.logExit(new String(b64array));
        } else {
            caTraceLogger.logExit(false);
        }
        return b64array;
    }

    public boolean parseAddResponse(byte[] b64payload) throws CAMCryptoException {
        caTraceLogger.logEnter();
        byte[] payload = CryptoWrapper.decodeBase64(b64payload);
        byte reqVersion = payload[0];
        byte[] passbytes = CaCacheMessaging.getPassbytes();
        EncodedCAMessage caRequest = new EncodedCAMessage();
        caRequest.parseCAMessage(payload);
        byte respType = caRequest.getType();
        if (respType == 9) {
            byte[] error = caRequest.getError();
            CAMCryptoUtilities.throwPeerException(error);
        } else if (respType != 6) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_invalid_msg_type"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        byte[] digest = caRequest.getDigest();
        byte[] bFlag = caRequest.getAdditionalData();
        int iFlag = CryptoWrapper.toInt(bFlag, 0, 4);
        boolean result = iFlag == 1;
        Configuration config = Configuration.getInstance();
        String digestAlgorithm = null;
        if (reqVersion == 2) {
            digestAlgorithm = config.getSHAAlgorithm();
        } else if (reqVersion == 3 || reqVersion == 4) {
            digestAlgorithm = new String(caRequest.getDigestAlgorithm());
        }
        MessageDigest md = null;
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(digestAlgorithm, jceProvider);
            } else {
                md = MessageDigest.getInstance(digestAlgorithm);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_digest_alg_not_found"));
        }
        md.update(passbytes);
        md.update(reqVersion);
        md.update(respType);
        md.update(bFlag);
        byte[] tmpRespDigest = md.digest();
        md.update(passbytes);
        md.update(tmpRespDigest);
        byte[] macResp = md.digest();
        if (!MessageDigest.isEqual(macResp, digest)) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_digest_failure"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        caTraceLogger.logExit(result);
        return result;
    }

    public String createBibusWrapper(byte[] payload) throws CAMCryptoException {
        caTraceLogger.logEnter();
        String b64FreshnessReqBytes = new String(payload);
        String strXMLRequest = new StringBuffer().append(CACACHE_REQ_HEAD).append(b64FreshnessReqBytes).append(CACACHE_REQ_TAIL).toString();
        caTraceLogger.logExit(strXMLRequest);
        return strXMLRequest;
    }

    public byte[] sendRequest(String req) throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        PriorityUrlList urls = config.getPeers();
        Iterator<URL> thisUrl = urls.getIterator();
        boolean bFoundTarget = false;
        String response = null;
        CAMCryptoException cryptoException = null;
        while (!bFoundTarget && thisUrl.hasNext()) {
            URL url = thisUrl.next();
            PostMethod post = new PostMethod();
            post.setRequestBody(req);
            post.setPath(url.getFile());
            post.setRequestHeader("Content-type", "text/xml");
            post.setRequestHeader("SOAPAction", "\"http://www.ibm.com/xmlns/prod/cognos/contentManagerService/201301/\"");
            HttpClient hc = HttpClientInitializer.getInstance().createHttpClient(url);
            hc.setConnectionTimeout(30000);
            hc.setTimeout(30000);
            int resultCode = 0;
            try {
                try {
                    resultCode = hc.executeMethod((HttpMethod)post);
                }
                catch (ConnectException e) {
                    continue;
                }
                response = CAMCryptoUtilities.getResponseString(post);
                post.releaseConnection();
            }
            catch (Exception e) {
                if (cryptoException != null) continue;
                cryptoException = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_http_ret_code_error", new String[]{url.toString()}));
                continue;
            }
            if (resultCode < 200 || resultCode > 299) {
                if (cryptoException != null) continue;
                cryptoException = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_http_ret_code_error", new String[]{url.toString()}));
                continue;
            }
            urls.updateURLPriority(url);
            bFoundTarget = true;
        }
        if (!bFoundTarget && cryptoException != null) {
            caTraceLogger.logExit(cryptoException);
            throw cryptoException;
        }
        if (response == null) {
            caTraceLogger.logExit("Null Response");
            return null;
        }
        caTraceLogger.logExit(response);
        return response.getBytes();
    }

    public byte[] removeBibusWrapper(byte[] response) throws CAMCryptoException {
        caTraceLogger.logEnter();
        byte[] rawResp = null;
        try {
            String strResponse = new String(response);
            Document doc = DocumentHelper.parseText((String)strResponse);
            List nodeList = doc.selectNodes("/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='queryResponse']/*[local-name()='queryResult']/*[local-name()='item']/*[local-name()='cachedCACertificates']/*[local-name()='value']");
            Iterator it = nodeList.iterator();
            if (!it.hasNext()) {
                String faultstring = CAMCryptoUtilities.getBIBusFaultString(doc);
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_bibus_returned_error", new String[]{faultstring}));
                caTraceLogger.logExit(cce);
                throw cce;
            }
            Object obj = it.next();
            if (obj == null || !(obj instanceof Node) || it.hasNext()) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_bibus_parse_error"));
                caTraceLogger.logExit(cce);
                throw cce;
            }
            Node node = (Node)obj;
            String b64fresh = node.getText();
            rawResp = CryptoWrapper.decodeBase64(b64fresh.getBytes());
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_error_removing_bibus"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        if (rawResp == null) {
            caTraceLogger.logExit((String)null);
        } else {
            caTraceLogger.logExit(new String(rawResp));
        }
        return rawResp;
    }

    private String getTokenGenerationDigestAlgorithm() throws CAMCryptoException {
        String digestAlgorithm = null;
        Configuration config = Configuration.getInstance();
        if (this.version == 2) {
            digestAlgorithm = config.getSHAAlgorithm();
        } else if (this.version == 3 || this.version == 4) {
            digestAlgorithm = new String(config.getDigestAlgorithm());
        }
        return digestAlgorithm;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte byteVersion) throws CAMCryptoException {
        this.version = byteVersion;
    }
}

