/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.casync;

import com.cognos.accman.jcam.crypto.casync.CaCacheWrapperException;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.res.MessageSet;
import java.lang.reflect.Method;
import java.util.Vector;

public class CaCacheWrapper {
    private Method _addData;
    private Method _deleteData;
    private Method _getData;
    private Method _getAllData;
    private Method _getAllDataKeys;
    private Method _freshness;
    private Object _this;
    private static CaCacheWrapper singleton = null;

    private CaCacheWrapper() throws CaCacheWrapperException {
        try {
            Class<?> cmClass = Class.forName("com.cognos.cm.store.CMCADataStore");
            Class[] strParams = new Class[]{String.class};
            Class[] strByteArrParams = new Class[]{String.class, byte[].class};
            Class[] emptyParams = new Class[]{};
            Method get = cmClass.getMethod("get", emptyParams);
            this._this = get.invoke(null, new Object[0]);
            this._addData = cmClass.getMethod("addData", strByteArrParams);
            this._deleteData = cmClass.getMethod("deleteData", strParams);
            this._getData = cmClass.getMethod("getData", strParams);
            this._getAllData = cmClass.getMethod("getAllData", emptyParams);
            this._getAllDataKeys = cmClass.getMethod("getAllDataKeys", emptyParams);
            this._freshness = cmClass.getMethod("freshness", emptyParams);
        }
        catch (Exception e) {
            IPFTraceFunction.fatalException("CaCacheWrapper: error loading CMCADataStore class with reflection.Ensure the class is available and our classpath is set correctly.This probably indicates an environmental configuration problem.This may also indicate that CM has not started yet", e);
            throw new CaCacheWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_load_error"));
        }
        if (this._this == null || this._addData == null || this._deleteData == null || this._getData == null || this._getAllData == null || this._getAllDataKeys == null || this._freshness == null) {
            IPFTraceFunction.trace("loaded CMCADataStore class with reflection.But at least one method pointer is null. Is the version of CM installed matching the rest of the product? Has CM started?");
            throw new CaCacheWrapperException(MessageSet.getMessage("CAM_CRP_cm_store_wrapper_loaded_error"));
        }
    }

    public static synchronized CaCacheWrapper getInstance() throws CaCacheWrapperException {
        if (singleton == null) {
            singleton = new CaCacheWrapper();
        }
        return singleton;
    }

    public void addData(String key, byte[] cert) throws CaCacheWrapperException {
        try {
            this._addData.invoke(this._this, key, cert);
        }
        catch (Exception e) {
            String msg = "CaCacheWrapper:addData: error invoking CMCADataStore addData method.";
            IPFTraceFunction.fatalException(msg, e);
            throw new CaCacheWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_addData_error"));
        }
    }

    boolean deleteData(String key) throws CaCacheWrapperException {
        Boolean b = null;
        try {
            b = (Boolean)this._deleteData.invoke(this._this, key);
        }
        catch (Exception e) {
            IPFTraceFunction.fatalException("CaCacheWrapper:addData: error invoking CMCADataStore deleteData method", e);
            throw new CaCacheWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_deleteData_error"));
        }
        return b;
    }

    byte[] getData(String key) throws CaCacheWrapperException {
        try {
            byte[] ret = (byte[])this._getData.invoke(this._this, key);
            return ret;
        }
        catch (Exception e) {
            IPFTraceFunction.fatalException("CaCacheWrapper:addData: error invoking CMCADataStore getData method", e);
            throw new CaCacheWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_getData_error"));
        }
    }

    private Vector getAllData() throws CaCacheWrapperException {
        try {
            Vector ret = (Vector)this._getAllData.invoke(this._this, new Object[0]);
            return ret;
        }
        catch (Exception e) {
            IPFTraceFunction.fatalException("CaCacheWrapper:addData: error invoking CMCADataStore getAllData method", e);
            throw new CaCacheWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_getAllData_error"));
        }
    }

    public String[] getAllDataKeys() throws CaCacheWrapperException {
        try {
            String[] ret = (String[])this._getAllDataKeys.invoke(this._this, new Object[0]);
            return ret;
        }
        catch (Exception e) {
            IPFTraceFunction.fatalException("CaCacheWrapper:addData: error invoking CMCADataStore getAllDataKeys method", e);
            throw new CaCacheWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_getAllDataKeys_error"));
        }
    }

    public Integer freshness() throws CaCacheWrapperException {
        try {
            Integer ret = (Integer)this._freshness.invoke(this._this, new Object[0]);
            return ret;
        }
        catch (Exception e) {
            IPFTraceFunction.fatalException("CaCacheWrapper:addData: error invoking CMCADataStore freshness method", e);
            throw new CaCacheWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_freshness_error"));
        }
    }
}

