/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.casync;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.casync.CaCacheMessaging;
import com.cognos.accman.jcam.crypto.casync.CaCacheWrapper;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.IConfiguration;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.res.MessageSet;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class CaFreshnessHandler {
    private static final String INVALID_FRESHNESS_VALUE = "-1";
    static IPFTraceLogger caTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CA");
    private static CaFreshnessHandler singleton = null;
    private Properties defaults;
    private Properties current;
    private static String FRESHNESS_FILENAME;
    private CaCacheWrapper caCache = null;

    private CaFreshnessHandler() throws CAMCryptoException {
        caTraceLogger.logEnter();
        IConfiguration config = Configuration.getInstance();
        if (config == null) {
            config = Configuration.getInstanceWithDefaultConfig(false);
        }
        String tempFileLocation = config.getTempFileLocation();
        String tempFile = tempFileLocation + "/cam/freshness";
        FRESHNESS_FILENAME = CCLConfigurationFactory.getInstance().resolveEffectivePath(tempFile);
        this.defaults = new Properties();
        this.defaults.put("freshness.version", "1");
        this.defaults.put("freshness.value", INVALID_FRESHNESS_VALUE);
        this.current = new Properties();
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(FRESHNESS_FILENAME));){
            this.current.load(bis);
        }
        catch (Exception e) {
            this.current = this.defaults;
            this.writeFreshnessFile();
        }
        caTraceLogger.logExit(true);
    }

    public static synchronized CaFreshnessHandler getInstance() throws CAMCryptoException {
        caTraceLogger.logEnter();
        if (singleton == null) {
            singleton = new CaFreshnessHandler();
        }
        caTraceLogger.logExit(true);
        return singleton;
    }

    public Integer getCSFreshness() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        boolean bLocalCM = config.getWeAreCM() && !config.getWeAreTheConfigTool();
        Integer freshness = null;
        if (bLocalCM) {
            this.setupCaCache();
            if (this.caCache != null) {
                freshness = this.caCache.freshness();
            } else {
                caTraceLogger.trace("No cacache available. Error loading CM class via reflection.");
            }
        } else {
            freshness = this.transmitCAFreshnessRequest();
        }
        caTraceLogger.logExit(freshness.toString());
        return freshness;
    }

    private synchronized Integer getLocalFreshness() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Integer i = null;
        try {
            String fStr = this.current.getProperty("freshness.value");
            i = new Integer(fStr);
        }
        catch (NumberFormatException nfe) {
            caTraceLogger.fatalException("CaFreshnessHandler.getLocalFreshness: problem loading local freshness file. Reverting to defaults and resaving.", nfe);
            this.current = this.defaults;
            this.writeFreshnessFile();
            String fStr = this.current.getProperty("freshness.value");
            i = new Integer(fStr);
        }
        caTraceLogger.logExit(i.toString());
        return i;
    }

    public synchronized void updateLocalFreshness() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Integer csFreshness = this.getCSFreshness();
        String szFreshness = csFreshness.toString();
        this.current.setProperty("freshness.value", szFreshness);
        this.writeFreshnessFile();
        caTraceLogger.logExit(true);
    }

    public synchronized void invalidateLocalFreshness() throws CAMCryptoException {
        caTraceLogger.logEnter();
        this.current.setProperty("freshness.value", INVALID_FRESHNESS_VALUE);
        this.writeFreshnessFile();
        caTraceLogger.logExit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needSync() throws CAMCryptoException {
        caTraceLogger.logEnter();
        boolean bNeedSync = false;
        int remote = this.getCSFreshness();
        int local = this.getLocalFreshness();
        String log = "CaFreshnessHandler.needSync: remote=<" + remote + "> local=<" + local + ">";
        caTraceLogger.trace(log);
        if (local < remote) {
            bNeedSync = true;
        } else if (local > remote) {
            caTraceLogger.trace("Local freshness greater that CS freshness. Switching to defaults and resaving locally, return synch required.");
            CaFreshnessHandler caFreshnessHandler = this;
            synchronized (caFreshnessHandler) {
                this.current = this.defaults;
            }
            this.writeFreshnessFile();
            bNeedSync = true;
        }
        caTraceLogger.logExit(bNeedSync);
        return bNeedSync;
    }

    private Integer transmitCAFreshnessRequest() throws CAMCryptoException {
        caTraceLogger.logEnter();
        try {
            caTraceLogger.trace("Creating request.");
            CaCacheMessaging caCacheMessaging = new CaCacheMessaging();
            byte[] baFresh = caCacheMessaging.createFreshnessRequest();
            caTraceLogger.trace("Creating BIBus Wrapper.");
            String xmlMsg = caCacheMessaging.createBibusWrapper(baFresh);
            caTraceLogger.trace("Transmit request.");
            byte[] resp = caCacheMessaging.sendRequest(xmlMsg);
            caTraceLogger.trace("Removing BIBus Wrapper.");
            byte[] payload = caCacheMessaging.removeBibusWrapper(resp);
            caTraceLogger.trace("Parsing response.");
            Integer freshness = caCacheMessaging.parseFreshnessResponse(payload);
            caTraceLogger.logExit(freshness.toString());
            return freshness;
        }
        catch (CAMCryptoException e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_ca_freshness_request_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
    }

    private synchronized void setupCaCache() throws CAMCryptoException {
        caTraceLogger.logEnter();
        if (this.caCache == null) {
            this.caCache = CaCacheWrapper.getInstance();
        }
        caTraceLogger.logExit(true);
    }

    private synchronized void writeFreshnessFile() throws CAMCryptoException {
        caTraceLogger.logEnter();
        try {
            File fCam;
            File f = new File(FRESHNESS_FILENAME);
            if (!f.exists() && !(fCam = f.getParentFile()).exists()) {
                File fTemp = fCam.getParentFile();
                if (!fTemp.exists()) {
                    fTemp.mkdir();
                }
                fCam.mkdir();
            }
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_fresh_setupwrite_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        try {
            this.current.store(new FileOutputStream(FRESHNESS_FILENAME), "CA Cache Freshness");
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_fresh_write_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        caTraceLogger.logExit(true);
    }
}

