/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.casync;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.res.MessageSet;

public class EncodedCAMessage {
    public static final byte VERSION2 = 2;
    public static final byte VERSION3 = 3;
    public static final byte VERSION4 = 4;
    public static final byte CURRENT_VERSION = 4;
    public static final byte FRESHNESS_REQ = 1;
    public static final byte FRESHNESS_RESP = 2;
    public static final byte GET_CACACHE_REQ = 3;
    public static final byte GET_CACACHE_RESP = 4;
    public static final byte ADD_CACACHE_REQ = 5;
    public static final byte ADD_CACACHE_RESP = 6;
    public static final byte TYPE_LOCALE = 7;
    public static final byte ADDITIONAL_DATA = 8;
    public static final byte RESP_ERROR = 9;
    public static final byte GET_CACACHETEST_REQ = 10;
    public static final byte GET_CACACHETEST_RESP = 11;
    public static final byte DIGEST_ALGORITHM = 12;
    private byte version;
    private byte type;
    private byte[] locale;
    private byte[] digest;
    private byte[] digestAlgorithm;
    private byte[] additionalData;
    private byte[] error;

    public EncodedCAMessage(byte[] locale, byte type, byte[] digest, byte[] additionalData) throws CAMCryptoException {
        this.version = (byte)2;
        this.locale = locale;
        this.type = type;
        this.digest = digest;
        this.additionalData = additionalData;
        this.error = null;
    }

    public EncodedCAMessage(byte[] locale, byte type, byte[] digest, byte[] algorithm, byte[] additionalData, byte theVersion) throws CAMCryptoException {
        this.version = theVersion;
        this.locale = locale;
        this.type = type;
        this.digest = digest;
        this.digestAlgorithm = algorithm;
        this.additionalData = additionalData;
        this.error = null;
    }

    public EncodedCAMessage() {
        this.digest = null;
        this.digestAlgorithm = null;
        this.additionalData = null;
        this.error = null;
    }

    public byte[] getLocale() {
        return this.locale;
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public byte[] getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public byte[] getAdditionalData() {
        return this.additionalData;
    }

    public byte[] getError() {
        return this.error;
    }

    public byte[] genCAMessage() throws CAMCryptoException {
        if (this.version == 2) {
            return this.genCAMessage2();
        }
        return this.genCAMessage3();
    }

    private byte[] genCAMessage2() throws CAMCryptoException {
        if (this.locale == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_not_able_to_generate_ca_request_locale"));
        }
        if (this.type == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_not_able_to_generate_ca_request_type"));
        }
        if (this.digest == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_not_able_to_generate_ca_request_digest"));
        }
        int messageLength = this.locale.length + 1 + 1 + this.digest.length + 1 + 4;
        if (this.additionalData != null) {
            messageLength = messageLength + this.additionalData.length + 1 + 4;
        }
        byte[] caMessage = new byte[messageLength + 1];
        caMessage[0] = this.version;
        int pt = 1;
        caMessage[pt] = 7;
        caMessage[++pt] = (byte)this.locale.length;
        System.arraycopy(this.locale, 0, caMessage, ++pt, this.locale.length);
        caMessage[pt += this.locale.length] = this.type;
        byte[] byteDigestLength = CryptoWrapper.toByteArray(this.digest.length);
        System.arraycopy(byteDigestLength, 0, caMessage, ++pt, 4);
        System.arraycopy(this.digest, 0, caMessage, pt += 4, this.digest.length);
        pt += this.digest.length;
        if (this.additionalData != null) {
            caMessage[pt] = 8;
            byte[] byteDataLength = CryptoWrapper.toByteArray(this.additionalData.length);
            System.arraycopy(byteDataLength, 0, caMessage, ++pt, 4);
            System.arraycopy(this.additionalData, 0, caMessage, pt += 4, this.additionalData.length);
            pt += this.additionalData.length;
        }
        return CryptoWrapper.encodeBase64(caMessage);
    }

    private byte[] genCAMessage3() throws CAMCryptoException {
        if (this.locale == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_not_able_to_generate_ca_request_locale"));
        }
        if (this.type == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_not_able_to_generate_ca_request_type"));
        }
        if (this.digest == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_not_able_to_generate_ca_request_digest"));
        }
        if (this.digestAlgorithm == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_not_able_to_generate_ca_request_digest"));
        }
        int messageLength = this.locale.length + 1 + 1 + this.digest.length + 1 + 4 + this.digestAlgorithm.length + 1 + 4;
        if (this.additionalData != null) {
            messageLength = messageLength + this.additionalData.length + 1 + 4;
        }
        byte[] caMessage = new byte[messageLength + 1];
        caMessage[0] = this.version;
        int pt = 1;
        caMessage[pt] = 7;
        caMessage[++pt] = (byte)this.locale.length;
        System.arraycopy(this.locale, 0, caMessage, ++pt, this.locale.length);
        caMessage[pt += this.locale.length] = this.type;
        byte[] byteDigestLength = CryptoWrapper.toByteArray(this.digest.length);
        System.arraycopy(byteDigestLength, 0, caMessage, ++pt, 4);
        System.arraycopy(this.digest, 0, caMessage, pt += 4, this.digest.length);
        caMessage[pt += this.digest.length] = 12;
        byte[] byteDigestAlgorithmLength = CryptoWrapper.toByteArray(this.digestAlgorithm.length);
        System.arraycopy(byteDigestAlgorithmLength, 0, caMessage, ++pt, 4);
        System.arraycopy(this.digestAlgorithm, 0, caMessage, pt += 4, this.digestAlgorithm.length);
        pt += this.digestAlgorithm.length;
        if (this.additionalData != null) {
            caMessage[pt] = 8;
            byte[] byteDataLength = CryptoWrapper.toByteArray(this.additionalData.length);
            System.arraycopy(byteDataLength, 0, caMessage, ++pt, 4);
            System.arraycopy(this.additionalData, 0, caMessage, pt += 4, this.additionalData.length);
            pt += this.additionalData.length;
        }
        return CryptoWrapper.encodeBase64(caMessage);
    }

    public boolean parseCAMessage(byte[] caMessage) throws CAMCryptoException {
        IPFTraceFunction.trace("EncodedCAMessage.parseCAMessage starting");
        if (caMessage == null || caMessage.length == 0) {
            IPFTraceFunction.trace("Invalid message, ignoring");
            return false;
        }
        IPFTraceFunction.trace("Parameter caMessage has content  of length [" + caMessage.length + "] bytes");
        byte version = caMessage[0];
        if (version != 2 && version != 3 && version != 4) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cacache_invalid_msg_version"));
            throw cce;
        }
        byte type = 0;
        int length = 0;
        block7: for (int pt = 1; pt < caMessage.length; pt += length) {
            type = caMessage[pt];
            ++pt;
            switch (type) {
                case 7: {
                    length = caMessage[pt];
                    if (length > caMessage.length) {
                        IPFTraceFunction.trace("Invalid message locale, ignoring");
                        return false;
                    }
                    this.locale = new byte[length];
                    System.arraycopy(caMessage, ++pt, this.locale, 0, length);
                    continue block7;
                }
                case 12: {
                    byte[] byteDigestAlgorithmLength = new byte[4];
                    System.arraycopy(caMessage, pt, byteDigestAlgorithmLength, 0, 4);
                    length = CryptoWrapper.toInt(byteDigestAlgorithmLength, 0, 4);
                    if (length > caMessage.length) {
                        IPFTraceFunction.trace("Invalid digest algorithm data length, ignoring");
                        return false;
                    }
                    this.digestAlgorithm = new byte[length];
                    System.arraycopy(caMessage, pt += 4, this.digestAlgorithm, 0, length);
                    continue block7;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: {
                    byte[] byteDigestLength = new byte[4];
                    System.arraycopy(caMessage, pt, byteDigestLength, 0, 4);
                    length = CryptoWrapper.toInt(byteDigestLength, 0, 4);
                    if (length > caMessage.length) {
                        IPFTraceFunction.trace("Invalid message req/resp length, ignoring");
                        return false;
                    }
                    this.digest = new byte[length];
                    System.arraycopy(caMessage, pt += 4, this.digest, 0, length);
                    this.type = type;
                    continue block7;
                }
                case 8: {
                    byte[] byteDataLength = new byte[4];
                    System.arraycopy(caMessage, pt, byteDataLength, 0, 4);
                    length = CryptoWrapper.toInt(byteDataLength, 0, 4);
                    if (length > caMessage.length) {
                        IPFTraceFunction.trace("Invalid additional data length, ignoring");
                        return false;
                    }
                    this.additionalData = new byte[length];
                    System.arraycopy(caMessage, pt += 4, this.additionalData, 0, length);
                    continue block7;
                }
                case 9: {
                    length = caMessage.length - 2;
                    if (length > caMessage.length) {
                        IPFTraceFunction.trace("Invalid error response length, ignoring");
                        return false;
                    }
                    this.error = new byte[length];
                    System.arraycopy(caMessage, pt, this.error, 0, length);
                    this.type = type;
                    continue block7;
                }
                default: {
                    IPFTraceFunction.trace("Unknown message type, ignoring");
                    return false;
                }
            }
        }
        return true;
    }
}

