/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.gss;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.gss.CAM_GSSHelper;
import com.cognos.accman.jcam.crypto.gss.SSPITokenConverter;
import com.cognos.accman.res.MessageSet;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class CAM_GSSHelperImpl
implements CAM_GSSHelper {
    private final Subject originalSubject;
    private final Subject subject;
    private GSSContext context;
    private String initiatorPeer;
    private static final int INITIATOR = 1;
    private static final int ACCEPTOR = 2;
    private static final boolean EXTRA_LOGGING = false;
    private static final AtomicReference<FileWriter> extraLogFile = new AtomicReference();

    public CAM_GSSHelperImpl(Subject serverSubject) throws CAMCryptoException {
        if (serverSubject.getPrincipals().size() != 1) {
            throw new IllegalArgumentException("Subject does not have a single principal.");
        }
        this.subject = new Subject(false, serverSubject.getPrincipals(), serverSubject.getPublicCredentials(), serverSubject.getPrivateCredentials());
        this.originalSubject = new Subject(true, serverSubject.getPrincipals(), serverSubject.getPublicCredentials(), serverSubject.getPrivateCredentials());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logln(String line) {
        block5: {
            try {
                FileWriter fw = extraLogFile.get();
                if (fw == null) break block5;
                FileWriter fileWriter = fw;
                synchronized (fileWriter) {
                    fw.write(new Date().toString() + ": " + line + "\n");
                    fw.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logStackln(String prefix, Throwable e) {
        block5: {
            try {
                FileWriter fw = extraLogFile.get();
                if (fw == null) break block5;
                FileWriter fileWriter = fw;
                synchronized (fileWriter) {
                    fw.write(new Date().toString() + ": " + prefix + "\n");
                    PrintWriter pw = new PrintWriter(fw);
                    e.printStackTrace(pw);
                    pw.flush();
                    fw.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static GSSContext createContext(String forPrinc, String peer, int direction) throws CAMCryptoException {
        GSSContext gssContext;
        try {
            Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
            Oid krb5PrincipalNameType = new Oid("1.2.840.113554.1.2.2.1");
            GSSManager gssManager = GSSManager.getInstance();
            GSSName gssPrincName = gssManager.createName(forPrinc, krb5PrincipalNameType);
            GSSCredential cred = gssManager.createCredential(gssPrincName, Integer.MAX_VALUE, krb5Mechanism, direction);
            if (peer != null) {
                GSSName gssPeerName = gssManager.createName(forPrinc, krb5PrincipalNameType);
                gssContext = gssManager.createContext(gssPeerName, krb5Mechanism, cred, 0);
                gssContext.requestConf(true);
                gssContext.requestCredDeleg(true);
                gssContext.requestInteg(true);
                gssContext.requestMutualAuth(true);
                gssContext.requestReplayDet(true);
                gssContext.requestSequenceDet(true);
                gssContext.requestCredDeleg(true);
            } else {
                gssContext = gssManager.createContext(cred);
            }
        }
        catch (GSSException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_gss_context_create_failed", new String[]{forPrinc}));
        }
        return gssContext;
    }

    @Override
    public byte[] initSecContext(byte[] token) throws CAMCryptoException, IOException {
        return this.handshake(token, 1);
    }

    @Override
    public byte[] acceptSecContext(byte[] token) throws CAMCryptoException, IOException {
        byte[] outtoken;
        try {
            outtoken = this.handshake(token, 2);
        }
        catch (CAMCryptoException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        return outtoken;
    }

    private static String hexString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            String hexByte = Integer.toHexString(b & 0xFF);
            if (hexByte.length() == 1) {
                sb.append("0");
                sb.append(hexByte);
            } else if (hexByte.length() == 2) {
                sb.append(hexByte);
            } else {
                sb.append("??");
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public boolean isEstablished() {
        return this.context == null ? false : this.context.isEstablished();
    }

    @Override
    public Object getDelegatedSubject() throws CAMCryptoException {
        Subject delSubject = null;
        try {
            delSubject = Subject.doAs(this.subject, new PrivilegedExceptionAction<Subject>(){

                @Override
                public Subject run() throws Exception {
                    if (CAM_GSSHelperImpl.this.context == null) {
                        CAM_GSSHelperImpl.logln("getDelegatedSubject: context=null");
                    }
                    if (!CAM_GSSHelperImpl.this.context.isEstablished()) {
                        CAM_GSSHelperImpl.logln("getDelegatedSubject: context is not established");
                    }
                    if (!CAM_GSSHelperImpl.this.context.getCredDelegState()) {
                        CAM_GSSHelperImpl.logln("getDelegatedSubject: context.getCredDelegState() returned false");
                    }
                    if (CAM_GSSHelperImpl.this.context == null || !CAM_GSSHelperImpl.this.context.isEstablished() || !CAM_GSSHelperImpl.this.context.getCredDelegState()) {
                        return null;
                    }
                    Subject subject = CAM_GSSHelperImpl.this.getDelegatedSubject_Oracle();
                    if (subject != null) {
                        return subject;
                    }
                    return CAM_GSSHelperImpl.this.getDelegatedSubject_IBM();
                }
            });
        }
        catch (PrivilegedActionException e) {
            CAM_GSSHelperImpl.logStackln("getDelegatedSubject", e);
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_gss_no_delegated_credential"));
        }
        if (delSubject == null || delSubject.getPrivateCredentials().isEmpty()) {
            try {
                GSSCredential delegCreds = this.context.getDelegCred();
                return delegCreds;
            }
            catch (GSSException e) {
                CAM_GSSHelperImpl.logStackln("getDelegatedSubject... constrained delegation", e);
                return null;
            }
        }
        return delSubject;
    }

    private Subject getDelegatedSubject_Oracle() throws CAMCryptoException {
        GSSCredential delCredential;
        GSSName peerName;
        try {
            peerName = this.context.getDelegCred().getName();
            delCredential = this.context.getDelegCred();
        }
        catch (GSSException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_gss_no_delegated_credential"));
        }
        try {
            Class<?> gssUtilClass = Class.forName("com.sun.security.jgss.GSSUtil");
            Class[] argTypes = new Class[]{GSSName.class, GSSCredential.class};
            Method createSubjectMethod = gssUtilClass.getDeclaredMethod("createSubject", argTypes);
            Object[] args = new Object[]{peerName, delCredential};
            return (Subject)createSubjectMethod.invoke(null, args);
        }
        catch (ClassNotFoundException e) {
            CAM_GSSHelperImpl.logln("class not found 'com.sun.security.jgss.GSSUtil' must be IBM JRE");
        }
        catch (NoSuchMethodException e) {
            CAM_GSSHelperImpl.logStackln("getDelegatedSubject_Oracle", e);
        }
        catch (SecurityException e) {
            CAM_GSSHelperImpl.logStackln("getDelegatedSubject_Oracle", e);
        }
        catch (IllegalAccessException e) {
            CAM_GSSHelperImpl.logStackln("getDelegatedSubject_Oracle", e);
        }
        catch (IllegalArgumentException e) {
            CAM_GSSHelperImpl.logStackln("getDelegatedSubject_Oracle", e);
        }
        catch (InvocationTargetException e) {
            CAM_GSSHelperImpl.logStackln("getDelegatedSubject_Oracle", e);
        }
        return null;
    }

    private Subject getDelegatedSubject_IBM() throws CAMCryptoException {
        String peerName;
        HashSet<Object> newPrivCred = new HashSet<Object>(this.subject.getPrivateCredentials());
        HashSet<Object> newPubCred = new HashSet<Object>(this.subject.getPublicCredentials());
        HashSet<Principal> newPrincipals = new HashSet<Principal>(this.subject.getPrincipals());
        try {
            peerName = this.context.getDelegCred().getName().toString();
        }
        catch (GSSException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_gss_no_delegated_credential"));
        }
        newPrincipals.add(new KerberosPrincipal(peerName));
        newPrivCred.removeAll(this.originalSubject.getPrivateCredentials());
        newPubCred.removeAll(this.originalSubject.getPublicCredentials());
        newPrincipals.removeAll(this.originalSubject.getPrincipals());
        return new Subject(false, newPrincipals, newPubCred, newPrivCred);
    }

    private byte[] handshake(byte[] token, final int handshakeType) throws CAMCryptoException, IOException {
        if (token == null || token.length == 0) {
            return null;
        }
        final byte[] inToken = SSPITokenConverter.convertFrom(token);
        try {
            GSSContext gssContext;
            if (handshakeType == 1 && this.initiatorPeer == null) {
                throw new RuntimeException("remote SPN request not implemented yet...");
            }
            final String princName = this.originalSubject.getPrincipals().iterator().next().getName();
            if (this.context == null) {
                this.context = Subject.doAs(this.subject, new PrivilegedExceptionAction<GSSContext>(){

                    @Override
                    public GSSContext run() throws CAMCryptoException {
                        if (handshakeType == 2) {
                            return CAM_GSSHelperImpl.createContext(princName, null, 2);
                        }
                        return CAM_GSSHelperImpl.createContext(princName, CAM_GSSHelperImpl.this.initiatorPeer, 1);
                    }
                });
            }
            if ((gssContext = this.context) != null && gssContext.isEstablished()) {
                return null;
            }
            byte[] newToken = Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws CAMCryptoException {
                    try {
                        if (!gssContext.isInitiator() && inToken.length == 1 && inToken[0] == 0) {
                            return princName.getBytes();
                        }
                        if (gssContext.isInitiator()) {
                            throw new RuntimeException("remote SPN request not implemented yet...");
                        }
                        return gssContext.acceptSecContext(inToken, 0, inToken.length);
                    }
                    catch (GSSException e) {
                        throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_gss_establish_context_failure"));
                    }
                }
            });
            return SSPITokenConverter.convertTo(newToken);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof CAMCryptoException) {
                throw (CAMCryptoException)e.getException();
            }
            if (e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new RuntimeException(e);
        }
    }
}

