/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.gss;

import com.cognos.accman.jcam.crypto.gss.SSPIMessage;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import java.io.IOException;

public class SSPITokenConverter {
    static byte[] convertFrom(byte[] token) throws IOException {
        if (token == null) {
            return null;
        }
        byte[] binaryToken = CryptoWrapper.decodeBase64(token);
        SSPIMessage msg = new SSPIMessage();
        if (binaryToken[0] == 1 && binaryToken.length > 5) {
            if (binaryToken.length <= 5) {
                throw new RuntimeException("Corrupted token. length=" + binaryToken.length);
            }
            int actualLenght = 0;
            for (int i = 0; i < 4; ++i) {
                actualLenght |= (binaryToken[i + 1] & 0xFF) << i * 8;
            }
            int consumed = msg.FromBlob(binaryToken, 5);
            assert (consumed == actualLenght);
        } else if (binaryToken[0] == 2 && binaryToken.length > 1) {
            int consumed = msg.FromBlob(binaryToken, 1);
            assert (consumed == binaryToken.length - 1);
        } else {
            throw new RuntimeException("invalid token: version=" + binaryToken[0] + ", length=" + binaryToken.length);
        }
        assert (msg.getSubMessageCount() == 1);
        byte[] inData = msg.getSubMessage(0);
        return inData;
    }

    static byte[] convertTo(byte[] token) throws IOException {
        if (token == null) {
            return null;
        }
        SSPIMessage msg = new SSPIMessage();
        msg.addSubMessage(token);
        byte[] binaryToken = msg.ToBlob();
        return CryptoWrapper.encodeBase64(binaryToken);
    }
}

