/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.jni;

import com.cognos.accman.jcam.crypto.jni.CryptoByteBuffer;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;

public final class WinCryptoByteBuffer
extends CryptoByteBuffer {
    @Override
    public byte[] getByteBuffer2(int param) {
        byte[] result = null;
        String computerSidStr = WinCryptoByteBuffer.getSID();
        byte[] computerSidBytes = WinCryptoByteBuffer.convertSidToBytes(computerSidStr);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            result = md.digest(computerSidBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("getByteBuffer2: Cannot find MD5 message digest");
        }
        return result;
    }

    @Override
    public byte[] getByteBuffer3(int param) {
        byte[] result = null;
        String theSid = WinCryptoByteBuffer.getSID();
        byte[] computerSidBytes = WinCryptoByteBuffer.convertSidToBytes(theSid);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA256");
            result = md.digest(computerSidBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("getByteBuffer3: Cannot find SHA-256 message digest");
        }
        return Arrays.copyOfRange(result, 0, 16);
    }

    private static String getSID() {
        String theSid = WinCryptoByteBuffer.getAdminUserSID();
        if (theSid == null) {
            List<String> command = Arrays.asList("wmic", "computersystem", "get", "domainRole", "/value");
            BufferedReader bufReader = CryptoByteBuffer.executeSystemCommand(command);
            try {
                String aLine;
                while ((aLine = bufReader.readLine()) != null) {
                    String strippedLine = aLine.replaceAll("\\s", "");
                    if (!strippedLine.startsWith("DomainRole=")) continue;
                    int index = -1;
                    index = strippedLine.indexOf("=");
                    if (index == -1) continue;
                    int domainRole = Integer.parseInt(strippedLine.substring(index + 1));
                    if (domainRole == 4 || domainRole == 5) {
                        theSid = WinCryptoByteBuffer.getLocalGroupSID();
                        continue;
                    }
                    throw new RuntimeException("getSID: System is not a DC but could not find local admin account");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("getSID: IO exception when parsing command output");
            }
        }
        return theSid;
    }

    private static String getLocalGroupSID() {
        String groupSid = null;
        List<String> command = Arrays.asList("wmic", "group", "where", "(LocalAccount='TRUE')", "get", "sid");
        BufferedReader bufReader = CryptoByteBuffer.executeSystemCommand(command);
        try {
            String aLine;
            while ((aLine = bufReader.readLine()) != null) {
                String strippedLine = aLine.replaceAll("\\s", "");
                if (!strippedLine.startsWith("S-1-5-21")) continue;
                groupSid = strippedLine;
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("getLocalGroupSID: IO exception when parsing command output");
        }
        return groupSid;
    }

    private static String getAdminUserSID() {
        String adminUserSid = null;
        List<String> command = Arrays.asList("wmic", "useraccount", "where", "(LocalAccount='TRUE')", "get", "sid");
        BufferedReader bufReader = CryptoByteBuffer.executeSystemCommand(command);
        try {
            String aLine;
            while ((aLine = bufReader.readLine()) != null) {
                String strippedLine = aLine.replaceAll("\\s", "");
                if (!strippedLine.startsWith("S-1-5-21-") || !strippedLine.endsWith("-500")) continue;
                adminUserSid = strippedLine;
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("getAdminUserSID: IO exception when parsing command output");
        }
        return adminUserSid;
    }

    private static byte[] convertSidToBytes(String theSid) {
        byte[] result = new byte[20];
        String[] sidComponents = theSid.split("-");
        if (sidComponents.length == 8) {
            WinCryptoByteBuffer.convertLongToBytes(result, 0, 21L);
            for (int i = 1; i < 4; ++i) {
                long aSidComponent = Long.parseLong(sidComponents[i + 3].replaceAll("\\s", ""));
                WinCryptoByteBuffer.convertLongToBytes(result, i, aSidComponent);
            }
        } else {
            throw new RuntimeException("convertSidToBytes: Incorrect components in SID");
        }
        WinCryptoByteBuffer.convertLongToBytes(result, 4, 500L);
        return result;
    }

    private static void convertLongToBytes(byte[] bytes, int index, long sidComponent) {
        bytes[index * 4 + 3] = (byte)(sidComponent >> 24);
        bytes[index * 4 + 2] = (byte)(sidComponent >> 16);
        bytes[index * 4 + 1] = (byte)(sidComponent >> 8);
        bytes[index * 4] = (byte)sidComponent;
    }
}

