/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.HttpClientInitializer;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.PriorityUrlList;
import com.cognos.accman.res.MessageSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class ActiveCMFinder {
    private static final String CM_REQUEST = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\">\n<SOAP-ENV:Header>\n<bus:biBusHeader xsi:type=\"bus:biBusHeader\">\n<CAM xsi:nil=\"true\"/>\n<CAMProtect>\n<trustedValue>FAMD</trustedValue>\n<serviceId>CAMconfig</serviceId> \n</CAMProtect>\n</bus:biBusHeader>\n</SOAP-ENV:Header>\n<SOAP-ENV:Body>\n<cm:getActiveContentManager /></SOAP-ENV:Body>\n</SOAP-ENV:Envelope>\n";

    public static URL tryToFindActiveCM(PriorityUrlList cmURLs) throws CAMCryptoException {
        URL url = null;
        boolean bFound = false;
        if (cmURLs == null) {
            return null;
        }
        Iterator<URL> thisUrl = cmURLs.getIterator();
        while (thisUrl.hasNext()) {
            url = thisUrl.next();
            String response = null;
            PostMethod post = new PostMethod();
            post.setRequestBody(CM_REQUEST);
            post.setPath(url.getFile());
            post.setRequestHeader("Content-type", "text/xml");
            post.setRequestHeader("SOAPAction", "\"http://www.ibm.com/xmlns/prod/cognos/contentManagerService/201404/\"");
            HttpClient hc = HttpClientInitializer.getInstance().createHttpClient(url);
            hc.setConnectionTimeout(30000);
            hc.setTimeout(30000);
            int resultCode = 0;
            try {
                Document doc;
                try {
                    resultCode = hc.executeMethod((HttpMethod)post);
                }
                catch (Exception e) {
                    continue;
                }
                response = CAMCryptoUtilities.getResponseString(post);
                post.releaseConnection();
                if (resultCode < 200 || resultCode > 299) {
                    CAMCryptoException cryptoException = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_req_http_ret_code_error", new String[]{String.valueOf(resultCode)}));
                    IPFAuditFunction.trace("Could not get active CM from '" + url + "' due to exception: " + cryptoException);
                    continue;
                }
                try {
                    doc = DocumentHelper.parseText((String)response);
                }
                catch (Exception e) {
                    CAMCryptoException cryptoException = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_remote_cm_urls_req_parse_error"));
                    IPFAuditFunction.trace("Could not get active CM from '" + url + "' due to exception: " + cryptoException);
                    continue;
                }
                List nodeList = doc.selectNodes("/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='getActiveContentManagerResponse']/*[local-name()='result']");
                Iterator it = nodeList.iterator();
                if (!it.hasNext()) {
                    CAMCryptoException cryptoException = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_remote_cm_urls_req_parse_error"));
                    IPFAuditFunction.trace("Could not get active CM from '" + url + "' due to exception: " + cryptoException);
                    continue;
                }
                Object obj = it.next();
                if (obj == null || !(obj instanceof Node)) {
                    CAMCryptoException cryptoException = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_remote_cm_urls_req_parse_error"));
                    IPFAuditFunction.trace("Could not get active CM from '" + url + "' due to exception: " + cryptoException);
                    continue;
                }
                cmURLs.updateURLPriority(url);
                Node node = (Node)obj;
                String urlResponse = node.getText();
                try {
                    url = new URL(urlResponse);
                }
                catch (MalformedURLException e) {
                    IPFAuditFunction.trace("Could not get active CM from '" + url + "' due to exception: " + e);
                    continue;
                }
                bFound = true;
                break;
            }
            catch (Exception e) {
                CAMCryptoException cryptoException = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_req_cm_urls_http_error", new String[]{url.toString()}));
                IPFAuditFunction.trace("Could not get active CM from '" + url + "' due to exception: " + cryptoException);
            }
        }
        if (bFound) {
            return url;
        }
        return null;
    }
}

