/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMCryptoServerException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IJVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.res.MessageSet;
import com.cognos.cclcfgapi.CCLConfigurationUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.apache.commons.httpclient.methods.PostMethod;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.X500NameTokenizer;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CAMCryptoUtilities {
    private static final String INSTALLID_PREFIX = "INSTALLID_";
    private static Queue<MessageDigest> mdQueue = new ConcurrentLinkedQueue<MessageDigest>();
    private static final int altNameType_Email = 1;
    private static final int altNameType_DNS = 2;
    private static final int altNameType_IP = 7;
    private static HashMap macMap = new HashMap();
    static Map cskDigestMap = Collections.synchronizedMap(new WeakHashMap());

    public static void copyKeystore(KeyStore origin, KeyStore dest, String decPassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException, CertificateException, IOException {
        dest.load(null, null);
        Enumeration<String> aliases = origin.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            KeyStore.SecretKeyEntry theKeyEntry = (KeyStore.SecretKeyEntry)origin.getEntry(alias, new KeyStore.PasswordProtection(decPassword.toCharArray()));
            dest.setEntry(alias, theKeyEntry, new KeyStore.PasswordProtection(decPassword.toCharArray()));
        }
    }

    public static Element getChildElementByName(org.w3c.dom.Node node, String name) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element thisElem;
            if (children.item(i).getNodeType() != 1 || !name.equals((thisElem = (Element)children.item(i)).getLocalName())) continue;
            return thisElem;
        }
        return null;
    }

    public static String getElementText(Element element) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            org.w3c.dom.Node thisNode = children.item(i);
            if (thisNode.getNodeType() != 3) continue;
            return thisNode.getNodeValue();
        }
        return null;
    }

    public static Document getDocumentFromToken(byte[] token) throws CAMCryptoException {
        Document doc = null;
        try {
            doc = CAMCryptoUtilities.parseXml(new ByteArrayInputStream(token));
        }
        catch (DocumentException de) {
            throw new CAMCryptoException(de, MessageSet.getMessage("CAM_CRP_could_not_parse_xml", new String[]{"<token>"}));
        }
        return doc;
    }

    public static String getChildNodeValue(Document d, String path) {
        return d.valueOf(path);
    }

    public static String reverseDN(String dn) {
        StringBuffer reversedDN = new StringBuffer();
        X500NameTokenizer tokenizer = new X500NameTokenizer(dn);
        while (tokenizer.hasMoreTokens()) {
            String nextDNpart = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                reversedDN.insert(0, "," + nextDNpart);
                continue;
            }
            reversedDN.insert(0, nextDNpart);
        }
        return reversedDN.toString();
    }

    public static String getNormalizedDN(String dn) {
        StringBuffer normalizedDN = new StringBuffer();
        X500NameTokenizer st = new X500NameTokenizer(dn);
        while (st.hasMoreTokens()) {
            String attr = st.nextToken().trim();
            int i = attr.indexOf(61);
            if (i == -1) {
                throw new IllegalArgumentException("Badly formatted directory string");
            }
            String attrName = attr.substring(0, i).toUpperCase();
            String attrValue = attr.substring(i + 1);
            if (attrName.equals("E")) {
                attrName = "EMAILADDRESS";
            }
            normalizedDN.append(attrName);
            normalizedDN.append('=');
            normalizedDN.append(attrValue);
            if (!st.hasMoreTokens()) continue;
            normalizedDN.append(',');
        }
        return normalizedDN.toString();
    }

    public static String getNormalizedIssuerDN(X509Certificate cert) {
        String issuerDN = cert.getIssuerDN().toString();
        if (!(cert.getIssuerDN() instanceof X509Name)) {
            issuerDN = CAMCryptoUtilities.reverseDN(issuerDN);
        }
        return CAMCryptoUtilities.getNormalizedDN(issuerDN);
    }

    public static X500Name getIssuerDNAsX500Name(X509Certificate cert) throws CertificateException, NoSuchProviderException, CAMCryptoException {
        X509Certificate bcCert;
        boolean isBCCert = cert instanceof X509CertificateObject;
        if (isBCCert) {
            bcCert = cert;
        } else {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream bais = new ByteArrayInputStream(cert.getEncoded());
            bcCert = (X509Certificate)cf.generateCertificate(bais);
        }
        X500Name issueDN = X500Name.getInstance((Object)bcCert.getIssuerDN());
        return issueDN;
    }

    public static MessageDigest getMessageDigest(String alg) throws CAMCryptoException {
        MessageDigest md = null;
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                md = MessageDigest.getInstance(alg, jceProvider);
            } else {
                md = MessageDigest.getInstance(alg);
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_DSServiceAccessSession_alg_not_found"));
        }
        return md;
    }

    public static void resetCSKDigestMap() throws CAMCryptoException {
        cskDigestMap.clear();
    }

    public static byte[] digestCSK(SecretKey csk) throws CAMCryptoException {
        byte[] cskDigest = (byte[])cskDigestMap.get(csk);
        if (cskDigest != null) {
            return cskDigest;
        }
        MessageDigest md = CAMCryptoUtilities.getDigestFromQueue();
        md.reset();
        md.update(csk.getEncoded());
        cskDigest = md.digest();
        cskDigestMap.put(csk, cskDigest);
        CAMCryptoUtilities.returnDigestToQueue(md);
        return cskDigest;
    }

    public static int getCSKDigestLength() throws CAMCryptoException {
        MessageDigest md = CAMCryptoUtilities.getDigestFromQueue();
        return md.getDigestLength();
    }

    private static MessageDigest getDigestFromQueue() throws CAMCryptoException {
        MessageDigest md = mdQueue.poll();
        if (md == null) {
            try {
                md = MessageDigest.getInstance(Configuration.getInstance().getCSKDigestAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                md = null;
                throw new CAMCryptoException(e, "Could not find the common symmetric key digest algorithm.");
            }
        }
        return md;
    }

    private static void returnDigestToQueue(MessageDigest md) {
        mdQueue.offer(md);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mac getMacGivenCSKDigest(byte[] cskDigest, String hmacAlg) throws CAMCryptoException {
        Mac mac;
        try {
            String digestStr = new String(cskDigest) + hmacAlg;
            HashMap hashMap = macMap;
            synchronized (hashMap) {
                mac = (Mac)macMap.get(digestStr);
                if (mac == null) {
                    String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                    mac = Mac.getInstance(hmacAlg, jceProvider);
                    SecretKey csk = KeyStoreReader.getCSKGivenCSKDigest(cskDigest);
                    mac.init(csk);
                    macMap.put(digestStr, mac);
                }
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_mac_obj"));
        }
        return mac;
    }

    public static int getAsymmetricKeyBits(PublicKey key) {
        int bitLen;
        if (key instanceof RSAPublicKey) {
            bitLen = ((RSAPublicKey)key).getModulus().bitLength();
        } else if (key instanceof DSAPublicKey) {
            bitLen = ((DSAPublicKey)key).getY().bitLength();
            bitLen = (int)Math.floor(((double)bitLen + 256.0) / 512.0) * 512;
        } else if (key instanceof ECPublicKey) {
            bitLen = ((ECPublicKey)key).getParams().getCurve().getField().getFieldSize();
        } else {
            throw new InvalidParameterException("Expected asymmetric public key, got '" + key.getAlgorithm() + "' key instead");
        }
        return bitLen;
    }

    public static Collection getCertificatesFromFile(String fileName) throws CAMCryptoException {
        FileInputStream fis = null;
        ByteArrayInputStream bais = null;
        try {
            fileName = CCLConfigurationUtils.resolveEffectivePath((String)fileName);
            fis = new FileInputStream(fileName);
            int sz = fis.available();
            byte[] byteInput = new byte[sz + 1];
            fis.read(byteInput, 0, sz);
            if (byteInput[sz - 1] != 10) {
                byteInput[sz] = 10;
            }
            bais = new ByteArrayInputStream(byteInput);
        }
        catch (FileNotFoundException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cert_tool_find_file", new String[]{fileName}));
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cert_tool_read_file", new String[]{fileName}));
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_store_third_party_enc_cert"));
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        try {
            String pemStart = "-----BEGIN ";
            byte[] startchars = new byte["-----BEGIN ".length()];
            bais.read(startchars);
            bais.reset();
            CertificateFactory certFactory = null;
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceprovider = JVMEnvironment.getInstance().getJCEProvider();
                certFactory = CertificateFactory.getInstance("X.509", jceprovider);
            } else {
                certFactory = CertificateFactory.getInstance("X.509");
            }
            Collection<Object> c = new ArrayList();
            Vector pemBlocks = new Vector();
            if (Arrays.equals(startchars, "-----BEGIN ".getBytes())) {
                pemBlocks = CAMCryptoUtilities.getPEMBlocks(bais);
                if (pemBlocks.size() > 1) {
                    for (int i = 0; i < pemBlocks.size(); ++i) {
                        bais = CAMCryptoUtilities.getDERCertificates(new StringBuffer((String)pemBlocks.get(i)));
                        Collection<? extends Certificate> c1 = certFactory.generateCertificates(bais);
                        for (X509Certificate x509Certificate : c1) {
                            c.add(x509Certificate);
                        }
                    }
                    return c;
                }
                String pemString = (String)pemBlocks.get(0);
                bais = CAMCryptoUtilities.getDERCertificates(new StringBuffer(pemString));
            }
            c = certFactory.generateCertificates(bais);
            return c;
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cert_tool_decode_file", new String[]{fileName}));
        }
    }

    private static Vector getPEMBlocks(ByteArrayInputStream pemCerts) throws IOException {
        String line;
        Vector<String> pemVector = new Vector<String>();
        StringBuffer pemBuf = new StringBuffer();
        String startLine1 = "-----BEGINCERTIFICATE-----";
        String startLine2 = "-----BEGINX509CERTIFICATE-----";
        String startLine3 = "-----BEGINPKCS7-----";
        String endLine1 = "-----ENDCERTIFICATE-----";
        String endLine2 = "-----ENDX509CERTIFICATE-----";
        String endLine3 = "-----ENDPKCS7-----";
        boolean sz = false;
        while ((line = CAMCryptoUtilities.readLine(pemCerts)) != null) {
            if (line.startsWith(startLine1) || line.startsWith(startLine2) || line.startsWith(startLine3)) continue;
            if (line.startsWith(endLine1) || line.startsWith(endLine2) || line.startsWith(endLine3)) {
                pemVector.add(pemBuf.toString());
                pemBuf.setLength(0);
                continue;
            }
            pemBuf.append(line);
        }
        return pemVector;
    }

    private static ByteArrayInputStream getDERCertificates(StringBuffer pemBuf) throws IOException {
        if (pemBuf.length() != 0) {
            byte[] pemBytes = CryptoWrapper.decodeBase64(pemBuf.toString().getBytes());
            ByteArrayInputStream derCerts = new ByteArrayInputStream(pemBytes);
            return derCerts;
        }
        return null;
    }

    private static String readLine(ByteArrayInputStream in) throws IOException {
        int c;
        StringBuffer l = new StringBuffer();
        while ((c = in.read()) != 10 && c >= 0) {
            if (c == 13 || c == 32 || c == 9) continue;
            l.append((char)c);
        }
        if (c < 0) {
            return null;
        }
        return l.toString();
    }

    public static byte[] buildServerError(String locale, byte version, byte errorFlag, CAMCryptoServerException camCryptoServerException) {
        byte[] exceptionBytes = camCryptoServerException.toString(locale).getBytes();
        String s = new String(exceptionBytes);
        int respLen = exceptionBytes.length;
        byte[] barray = new byte[respLen + 2];
        barray[0] = version;
        barray[1] = errorFlag;
        System.arraycopy(exceptionBytes, 0, barray, 2, respLen);
        return CryptoWrapper.encodeBase64(barray);
    }

    public static void throwPeerException(byte[] respBytes) throws CAMCryptoException {
        String messageString = new String(respBytes);
        CAMCryptoException peerException = new CAMCryptoException(" ''" + messageString + "'' ");
        throw new CAMCryptoException(peerException, MessageSet.getMessage("CAM_CRP_error_returned_from_peer"));
    }

    public static void throwServerException(byte[] respBytes) throws CAMCryptoException {
        String messageString = new String(respBytes);
        CAMCryptoException peerException = new CAMCryptoException(" ''" + messageString + "'' ");
        throw new CAMCryptoServerException(peerException, "CAM_CRP_error_returned_from_peer");
    }

    public static String findLocale() {
        Configuration config = Configuration.getInstance();
        String serverLocale = null;
        if (config != null) {
            serverLocale = config.getServerLocale();
        }
        if (serverLocale != null) {
            return serverLocale;
        }
        Locale jvmLocale = Locale.getDefault();
        return jvmLocale.toString();
    }

    public static Locale getLocaleObject(String locale) {
        Locale oLocale;
        String language = null;
        String country = null;
        StringTokenizer tokens = new StringTokenizer(locale, "_");
        try {
            language = tokens.nextToken();
            try {
                country = tokens.nextToken();
                oLocale = new Locale(language, country);
            }
            catch (NoSuchElementException e) {
                oLocale = new Locale(language, "");
            }
        }
        catch (NoSuchElementException e) {
            oLocale = null;
        }
        return oLocale;
    }

    public static boolean isCACertificate(X509Certificate x509Cert) {
        return x509Cert.getBasicConstraints() != -1;
    }

    public static boolean isRootCACertificate(X509Certificate x509Cert) {
        if (CAMCryptoUtilities.isCACertificate(x509Cert)) {
            return x509Cert.getIssuerDN().equals(x509Cert.getSubjectDN());
        }
        return false;
    }

    public static boolean isCertExpired(X509Certificate x509Cert) throws CAMCryptoException {
        try {
            x509Cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            return true;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isCertAllowedInCS(X509Certificate x509Cert, IPFTraceLogger traceLogger) throws CAMCryptoException {
        boolean retval = false;
        traceLogger.logEnter();
        if (!CAMCryptoUtilities.isCACertificate(x509Cert)) {
            traceLogger.trace("skipping server cert: " + x509Cert.getSubjectDN().getName());
        } else if (!CAMCryptoUtilities.isCertAllowedInKeystore(x509Cert, traceLogger)) {
            traceLogger.trace("skipping ca cert: " + x509Cert.getSubjectDN().getName());
        } else {
            retval = true;
        }
        traceLogger.logExit(retval);
        return retval;
    }

    public static boolean isCertAllowedInKeystore(X509Certificate x509Cert, IPFTraceLogger traceLogger) throws CAMCryptoException {
        IJVMEnvironment jvmEnv = JVMEnvironment.getInstance();
        boolean retval = false;
        traceLogger.logEnter();
        if (CAMCryptoUtilities.isCertExpired(x509Cert)) {
            traceLogger.trace("skipping expired ca cert: " + x509Cert.getSubjectDN().getName() + " - not after: " + x509Cert.getNotAfter().toString());
        } else if (!jvmEnv.isDisableNIST131a() && !CAMCryptoUtilities.isNISTSP800_131aCertificate(x509Cert)) {
            traceLogger.trace("skipping non-NIST ca cert: " + x509Cert.getSubjectDN().getName());
        } else {
            retval = true;
        }
        traceLogger.logExit(retval);
        return retval;
    }

    public static boolean isNISTSP800_131aCertificate(X509Certificate x509Cert) {
        if (CAMCryptoUtilities.isRootCACertificate(x509Cert)) {
            return true;
        }
        String sigAlgName = x509Cert.getSigAlgName();
        if (sigAlgName.indexOf("SHA1with") != -1) {
            return false;
        }
        if (sigAlgName.indexOf("MD5with") != -1) {
            return false;
        }
        PublicKey pubKey = x509Cert.getPublicKey();
        if (pubKey instanceof DSAPublicKey) {
            DSAPublicKey dsaPk = (DSAPublicKey)x509Cert.getPublicKey();
            DSAParams params = dsaPk.getParams();
            if (params != null) {
                return params.getP().intValue() >= 2048 && params.getQ().intValue() >= 224;
            }
        } else {
            if (pubKey instanceof ECPublicKey) {
                ECPublicKey pk = (ECPublicKey)x509Cert.getPublicKey();
                ECParameterSpec spec = pk.getParams();
                int keyLen = 0;
                if (spec != null) {
                    keyLen = spec.getOrder().bitLength();
                }
                return keyLen >= 224;
            }
            if (pubKey instanceof RSAPublicKey) {
                RSAPublicKey rsaPk = (RSAPublicKey)x509Cert.getPublicKey();
                int keyLen = rsaPk.getModulus().bitLength();
                return keyLen >= 2048;
            }
        }
        return false;
    }

    public static synchronized String extractMsgString(String camMessage) {
        return camMessage.substring(camMessage.indexOf(" ") + 1);
    }

    public static synchronized String getBIBusFaultCode(Document doc) {
        String faultcode = null;
        List nodeList = doc.selectNodes("/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='Fault']/*[local-name()='faultcode']");
        Iterator err = nodeList.iterator();
        if (err.hasNext()) {
            Object faultcodeObj = err.next();
            Node faultcodeNode = (Node)faultcodeObj;
            faultcode = faultcodeNode.getText();
        }
        return faultcode;
    }

    public static synchronized String getBIBusFaultString(Document doc) {
        String faultstring = null;
        List nodeList = doc.selectNodes("/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='Fault']/*[local-name()='faultstring']");
        Iterator err = nodeList.iterator();
        if (err.hasNext()) {
            Object faultstringObj = err.next();
            Node faultstringNode = (Node)faultstringObj;
            faultstring = faultstringNode.getText();
        }
        return faultstring;
    }

    public static synchronized String stack2string(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return sw.toString();
        }
        catch (Exception e2) {
            return "bad stack2string";
        }
    }

    public static Document parseXml(InputStream is) throws DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(is);
    }

    public static byte[] getTokenField(byte[] token, int pos) {
        int sizeFieldLength = 4;
        byte[] lengthFieldBytes = new byte[4];
        System.arraycopy(token, pos, lengthFieldBytes, 0, 4);
        int fieldLength = CryptoWrapper.toInt(lengthFieldBytes);
        if (fieldLength > token.length - pos - 4) {
            throw new IllegalArgumentException("field length lager than buffer");
        }
        byte[] fieldData = new byte[fieldLength];
        System.arraycopy(token, pos + 4, fieldData, 0, fieldLength);
        return fieldData;
    }

    public static int addTokenField(byte[] token, int pos, byte[] dataField) {
        int sizeFieldLength = 4;
        int ret = pos;
        int fieldDataLength = dataField.length;
        byte[] sizeByte = CryptoWrapper.toByteArray(fieldDataLength);
        System.arraycopy(sizeByte, 0, token, ret, 4);
        System.arraycopy(dataField, 0, token, ret += 4, fieldDataLength);
        return (ret += fieldDataLength) - pos;
    }

    public static String getResponseString(PostMethod post) throws IOException {
        int charsRead;
        BufferedReader reader = new BufferedReader(new InputStreamReader(post.getResponseBodyAsStream()));
        StringBuilder result = new StringBuilder();
        char[] buffer = new char[4096];
        while ((charsRead = reader.read(buffer)) != -1) {
            result.append(buffer, 0, charsRead);
        }
        String response = result.toString();
        if (reader != null) {
            reader.close();
        }
        return response;
    }

    public static String getCAMInstallationIdentifier(String location) throws CAMCryptoException {
        String[] files;
        int filteredFiles;
        String installid = null;
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(CAMCryptoUtilities.INSTALLID_PREFIX);
            }
        };
        boolean hostidExists = false;
        File certsDir = new File(location);
        if (!certsDir.exists()) {
            certsDir.mkdir();
        }
        if ((filteredFiles = (files = certsDir.list(filter)).length) > 0) {
            hostidExists = true;
        }
        if (hostidExists) {
            String hostidFileName;
            installid = hostidFileName = files[0];
        } else {
            UUID uuid = UUID.randomUUID();
            installid = INSTALLID_PREFIX + uuid.toString();
            File hostidFile = new File(location + File.separator + installid);
            try {
                boolean bl = hostidFile.createNewFile();
            }
            catch (IOException e) {
                throw new CAMCryptoException(e);
            }
        }
        return installid;
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkWildcardMatch(String san, String fqdn) {
        if (san == null || fqdn == null) {
            return false;
        }
        String domain = san.substring(1);
        if (!fqdn.endsWith(domain)) {
            return false;
        }
        String hostname = fqdn.substring(0, fqdn.length() - domain.length());
        return hostname.indexOf(46) == -1;
    }

    public static boolean isCertificateConfigurationChanged(X509Certificate encryptionCertificate) throws CAMCryptoException {
        ArrayList<String> dnsNames = new ArrayList<String>();
        ArrayList<String> ipAddrs = new ArrayList<String>();
        ArrayList<String> emailAddrs = new ArrayList<String>();
        Collection<List<?>> alternativeNameCollection = null;
        try {
            alternativeNameCollection = encryptionCertificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            throw new CAMCryptoException(cpe, MessageSet.getMessage("CAM_CRP_invalid_cert_req"));
        }
        if (alternativeNameCollection != null) {
            for (List<?> alternativeName : alternativeNameCollection) {
                Integer altNameType = (Integer)alternativeName.get(0);
                String san = (String)alternativeName.get(1);
                if (altNameType == 1) {
                    emailAddrs.add(san);
                    continue;
                }
                if (altNameType == 2) {
                    dnsNames.add(san);
                    continue;
                }
                if (altNameType != 7) continue;
                ipAddrs.add(san);
            }
        }
        Configuration config = Configuration.getInstance();
        String config_emailAddrs = config.getSanEmailAddrs();
        String config_dnsNames = config.getSanDnsNames();
        String config_ipAddrs = config.getSanIPAddrs();
        boolean sanChanged = !CAMCryptoUtilities.isSame(emailAddrs, config_emailAddrs) || !CAMCryptoUtilities.isSame(dnsNames, config_dnsNames) || !CAMCryptoUtilities.isSame(ipAddrs, config_ipAddrs);
        String serverDN = null;
        String certDN = encryptionCertificate.getSubjectDN().getName().replaceAll("\\s+", "");
        serverDN = config.getServerDN().replaceAll("\\s+", "");
        boolean dnChanged = !certDN.equalsIgnoreCase(serverDN);
        PublicKey publicKey = encryptionCertificate.getPublicKey();
        String encryptionAlgorighm = publicKey.getAlgorithm();
        String configuredEncncryptionAlgorithm = config.getEncryptionKeyPairAlgorithm();
        boolean algorithmChanged = !encryptionAlgorighm.equalsIgnoreCase(configuredEncncryptionAlgorithm);
        boolean bENCkeyBitsChanged = CAMCryptoUtilities.getAsymmetricKeyBits(publicKey) != config.getEncryptionKeyPairSize();
        return sanChanged || dnChanged || algorithmChanged || bENCkeyBitsChanged;
    }

    private static boolean isSame(List<String> certAttrList, String caConfiguration) {
        if (certAttrList.size() == 0 && caConfiguration.length() == 0) {
            return true;
        }
        if (certAttrList.size() == 0 && caConfiguration.length() != 0 || certAttrList.size() != 0 && caConfiguration.length() == 0) {
            return false;
        }
        Collections.sort(certAttrList);
        String[] configuredAttrs = caConfiguration.split(" ");
        List<Object> configAttrList = new ArrayList();
        configAttrList = Arrays.asList(configuredAttrs);
        Collections.sort(configAttrList);
        boolean isEqual = certAttrList.equals(configAttrList);
        return isEqual;
    }
}

