/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.casync.CaFreshnessHandler;
import com.cognos.accman.jcam.crypto.jni.JNIFileLock;
import com.cognos.accman.jcam.crypto.jni.JNISystemProperties;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CAMPublicKey;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreWriter;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.x500.X500Name;

public class CAMKeyStore {
    public static final String camCryptoKey = "encryption";
    public static final String ca = "ca";
    public static long timeStamp = -1L;
    KeyStore _ks;
    char[] _password;
    String _keyStoreFile;
    String _format;
    String _provider;
    boolean _loaded;
    JNIFileLock _fileLock;
    File _lockFile;
    HashMap<CAMPublicKey, Certificate[]> certChainIssuerMap;
    static IPFTraceLogger keystoreTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement");

    public CAMKeyStore(String filename, String password, String format, String provider) {
        keystoreTraceLogger.logEnter();
        keystoreTraceLogger.trace("filename = " + filename);
        keystoreTraceLogger.trace("format = " + format);
        keystoreTraceLogger.trace("provider = " + provider);
        this._keyStoreFile = filename;
        this._password = password.toCharArray();
        this._format = format;
        this._provider = provider;
        this._ks = null;
        this._fileLock = null;
        this._lockFile = new File(this._keyStoreFile + ".lock");
        this._loaded = false;
        this.certChainIssuerMap = new HashMap();
        keystoreTraceLogger.logExit(true);
    }

    public synchronized Vector<X509Certificate> getAllCACertsWithPrivateKeys() throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        Vector<X509Certificate> certs = new Vector<X509Certificate>();
        try {
            Enumeration<String> aliases = this._ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this._ks.isKeyEntry(alias)) continue;
                X509Certificate cert = (X509Certificate)this._ks.getCertificate(alias);
                if (cert.getBasicConstraints() != -1) {
                    keystoreTraceLogger.trace("getAllCACertsWithPrivateKeys: [is ca] " + cert.getSubjectDN().getName());
                    certs.add(cert);
                    continue;
                }
                keystoreTraceLogger.trace("getAllCACertsWithPrivateKeys: [not ca]" + cert.getSubjectDN().getName());
            }
        }
        catch (KeyStoreException e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        keystoreTraceLogger.logExit(Integer.toString(certs.size()));
        return certs;
    }

    public synchronized boolean addTrustedCert(Certificate cert) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            X509Certificate x509Cert = (X509Certificate)cert;
            String certIssuer = CAMCryptoUtilities.getNormalizedIssuerDN(x509Cert);
            String certSerial = x509Cert.getSerialNumber().toString();
            byte[] certSig = x509Cert.getSignature();
            Certificate[] knownLocalCerts = this.getAllCertificates();
            List<Certificate> localCerts = Arrays.asList(knownLocalCerts);
            Vector<Certificate> localCertsVector = new Vector<Certificate>(localCerts);
            Enumeration<Certificate> e = localCertsVector.elements();
            while (e.hasMoreElements()) {
                Certificate o = e.nextElement();
                X509Certificate c = (X509Certificate)o;
                byte[] localCertSig = c.getSignature();
                boolean bEqual = Arrays.equals(localCertSig, certSig);
                if (!bEqual) continue;
                keystoreTraceLogger.logExit(true);
                return false;
            }
            String alias = certIssuer + ";" + certSerial;
            if (!this._ks.containsAlias(alias)) {
                this._ks.setCertificateEntry(alias, cert);
            } else {
                X509Certificate existingCert = (X509Certificate)this._ks.getCertificate(alias);
                if (existingCert != null && !existingCert.equals(cert)) {
                    boolean done = false;
                    int count = 1;
                    while (!done) {
                        alias = certIssuer + ";" + certSerial + ";" + count;
                        if (!this._ks.containsAlias(alias)) {
                            this._ks.setCertificateEntry(alias, cert);
                            done = true;
                            continue;
                        }
                        ++count;
                    }
                }
            }
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        keystoreTraceLogger.logExit(true);
        return true;
    }

    synchronized void expireKeyPair(String alias) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            if (alias != camCryptoKey) {
                Certificate[] existingCertChain = this.getCertificateChain(alias);
                this.storeCertificateBackup(existingCertChain[0]);
            }
            this._ks.deleteEntry(alias);
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        keystoreTraceLogger.logExit(true);
    }

    public synchronized Certificate[] getAllCertificates() throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            Vector<Certificate> certs = new Vector<Certificate>();
            Enumeration<String> e = this._ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate cert = this._ks.getCertificate(alias);
                if (cert == null) continue;
                certs.add(cert);
            }
            Certificate[] certsArr = new Certificate[certs.size()];
            certs.toArray(certsArr);
            keystoreTraceLogger.logExit(true);
            return certsArr;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
    }

    public synchronized Certificate getCertificate(String alias) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            Certificate cert = this._ks.getCertificate(alias);
            if (cert != null) {
                keystoreTraceLogger.logExit(true);
            } else {
                keystoreTraceLogger.logExit();
            }
            return cert;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
    }

    synchronized Certificate[] getCertificateChain(String alias) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            return this._ks.getCertificateChain(alias);
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
    }

    synchronized Certificate[] getIssuerCertificateChain(Certificate cert) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        CAMPublicKey certCAMPublicKey = new CAMPublicKey(cert.getPublicKey().getEncoded());
        if (this.certChainIssuerMap.containsKey(certCAMPublicKey)) {
            Certificate[] certChain = this.certChainIssuerMap.get(certCAMPublicKey);
            keystoreTraceLogger.logExit(true);
            return certChain;
        }
        Vector<Certificate> certchainvector = new Vector<Certificate>();
        Certificate currentcert = cert;
        try {
            boolean issuer_found;
            boolean selfSignedCert = false;
            block4: do {
                issuer_found = false;
                Enumeration<String> ksEntries = this._ks.aliases();
                while (ksEntries.hasMoreElements()) {
                    String alias = ksEntries.nextElement();
                    Certificate storecert = this._ks.getCertificate(alias);
                    try {
                        currentcert.verify(storecert.getPublicKey());
                        if (storecert.equals(currentcert)) continue block4;
                        certchainvector.add(storecert);
                        currentcert = storecert;
                        issuer_found = true;
                        X509Certificate x509Cert = (X509Certificate)currentcert;
                        if (!x509Cert.getIssuerDN().equals(x509Cert.getSubjectDN())) continue block4;
                        selfSignedCert = true;
                        continue block4;
                    }
                    catch (Exception exception) {
                    }
                }
            } while (issuer_found && !selfSignedCert);
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        if (certchainvector.size() == 0) {
            this.certChainIssuerMap.put(certCAMPublicKey, null);
            keystoreTraceLogger.logExit();
            return null;
        }
        Certificate[] certchain = new Certificate[certchainvector.size()];
        certchainvector.toArray(certchain);
        this.certChainIssuerMap.put(certCAMPublicKey, certchain);
        keystoreTraceLogger.logExit(true);
        return certchain;
    }

    synchronized KeyStore getKeyStore() {
        return this._ks;
    }

    synchronized PrivateKey getPrivateKey(String alias) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        PrivateKey key = null;
        try {
            key = (PrivateKey)this._ks.getKey(alias, this._password);
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        if (key != null) {
            keystoreTraceLogger.logExit(true);
        } else {
            keystoreTraceLogger.logExit();
        }
        return key;
    }

    synchronized PrivateKey getPrivateKey(X500Name issuerDN, BigInteger serialNumber) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            PrivateKey currentPrivKey = this.getPrivateKey(camCryptoKey);
            X509Certificate encCert = (X509Certificate)this.getCertificate(camCryptoKey);
            X500Name currentPrivKeyCertIssuer = CAMCryptoUtilities.getIssuerDNAsX500Name(encCert);
            BigInteger currentPrivKeyCertSerial = encCert.getSerialNumber();
            if (issuerDN.equals((Object)currentPrivKeyCertIssuer) && serialNumber.equals(currentPrivKeyCertSerial)) {
                if (currentPrivKey != null) {
                    keystoreTraceLogger.logExit(true);
                } else {
                    keystoreTraceLogger.logExit();
                }
                return currentPrivKey;
            }
            String normalizedIssuerDN = CAMCryptoUtilities.getNormalizedIssuerDN(encCert);
            String alias = normalizedIssuerDN + ";" + serialNumber.toString();
            PrivateKey key = (PrivateKey)this._ks.getKey(alias, this._password);
            if (key != null) {
                keystoreTraceLogger.logExit(true);
            } else {
                keystoreTraceLogger.logExit();
            }
            return key;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
    }

    synchronized X509Certificate[] getX509CertificateChain(String alias) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            Certificate[] certs = this.getCertificateChain(alias);
            X509Certificate[] x509certs = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                x509certs[i] = (X509Certificate)certs[i];
            }
            keystoreTraceLogger.logExit(true);
            return x509certs;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
    }

    public synchronized void loadKeyStore() throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        if (this._loaded) {
            keystoreTraceLogger.logExit(true);
            return;
        }
        this.certChainIssuerMap.clear();
        FileInputStream ksStream = null;
        try {
            ksStream = new FileInputStream(this._keyStoreFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            char[] pwd_backup = (char[])this._password.clone();
            this._ks = KeyStore.getInstance(this._format, this._provider);
            this._ks.load(ksStream, this._password);
            this.cleanupExpiredCertificates();
            this._password = pwd_backup;
            this._loaded = true;
            timeStamp = System.currentTimeMillis();
        }
        catch (Exception e) {
            this._ks = null;
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        finally {
            if (ksStream != null) {
                try {
                    ksStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        keystoreTraceLogger.logExit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        keystoreTraceLogger.logEnter();
        File parentDir = this._lockFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        try {
            this._lockFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IPFTraceFunction.trace("LockFile attempt");
        StringBuffer sb = new StringBuffer("");
        JNIFileLock newFL = JNISystemProperties.lockFile((String)this._lockFile.getAbsolutePath(), (StringBuffer)sb);
        if (sb.length() > 0) {
            IPFTraceFunction.trace(sb.toString());
        }
        Class<JNIFileLock> clazz = JNIFileLock.class;
        synchronized (JNIFileLock.class) {
            this._fileLock = newFL;
            // ** MonitorExit[var4_5] (shouldn't be in output)
            keystoreTraceLogger.logExit(true);
            return;
        }
    }

    synchronized void reEncryptKeys(String oldPassword) throws CAMCryptoException {
        Enumeration<String> ksEntries;
        keystoreTraceLogger.logEnter();
        char[] oldPass = oldPassword.toCharArray();
        try {
            ksEntries = this._ks.aliases();
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        while (ksEntries.hasMoreElements()) {
            String alias = ksEntries.nextElement();
            try {
                if (!this._ks.isKeyEntry(alias)) continue;
                Key key = this._ks.getKey(alias, oldPass);
                Certificate[] chain = this._ks.getCertificateChain(alias);
                this._ks.setKeyEntry(alias, key, this._password, chain);
            }
            catch (Exception e) {
                CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
                keystoreTraceLogger.logExit(cce);
                throw cce;
            }
        }
        keystoreTraceLogger.logExit(true);
    }

    private synchronized void cleanupExpiredCertificates() throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        boolean updated = false;
        try {
            Enumeration<String> e = this._ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate cert = (X509Certificate)this._ks.getCertificate(alias);
                if (CAMCryptoUtilities.isCertAllowedInKeystore(cert, keystoreTraceLogger)) continue;
                this._ks.deleteEntry(alias);
                updated = true;
            }
            if (updated) {
                CaFreshnessHandler.getInstance().invalidateLocalFreshness();
            }
            keystoreTraceLogger.logExit();
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_invalid_ca_cert_from_keystore"));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
    }

    public synchronized Certificate[] removeNonNIST131aCertificates() throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            Vector<Certificate> certs = new Vector<Certificate>();
            this.getAllCertificates();
            Enumeration<String> e = this._ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate cert = this._ks.getCertificate(alias);
                if (CAMCryptoUtilities.isNISTSP800_131aCertificate((X509Certificate)cert)) continue;
                this._ks.deleteEntry(alias);
                certs.add(cert);
            }
            Certificate[] certsArr = new Certificate[certs.size()];
            certs.toArray(certsArr);
            keystoreTraceLogger.logExit(true);
            return certsArr;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
    }

    synchronized void rolloverCert(String alias, Certificate[] certChain, PrivateKey key) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        this.expireKeyPair(alias);
        try {
            this._ks.setKeyEntry(alias, key, this._password, certChain);
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        keystoreTraceLogger.logExit(true);
    }

    synchronized void sanitizeCerts() throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            if (this._ks.size() < 48) {
                return;
            }
        }
        catch (KeyStoreException kse) {
            CAMCryptoException cce = new CAMCryptoException(kse, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        if (this.saveBackupKeyStore()) {
            keystoreTraceLogger.logExit(true);
            return;
        }
        try {
            Enumeration<String> e = this._ks.aliases();
            Hashtable<PublicKey, X509Certificate> map = new Hashtable<PublicKey, X509Certificate>();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate cert = (X509Certificate)this._ks.getCertificate(alias);
                if (cert == null) continue;
                PublicKey pk = cert.getPublicKey();
                if (map.get(pk) == null) {
                    map.put(pk, cert);
                    continue;
                }
                if (this._ks.isKeyEntry(alias)) continue;
                this._ks.deleteEntry(alias);
            }
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        keystoreTraceLogger.logExit(true);
    }

    synchronized boolean saveBackupKeyStore() throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            File fileObj = new File(this._keyStoreFile + ".bkup");
            if (!fileObj.exists()) {
                String parent = fileObj.getParent();
                if (parent != null) {
                    new File(parent).mkdirs();
                }
                FileOutputStream ksStream = new FileOutputStream(this._keyStoreFile + ".bkup");
                this._ks.store(ksStream, this._password);
                KeyStoreWriter.chtagKeyStoreBinaryOnzOS(fileObj);
                keystoreTraceLogger.logExit(false);
                return false;
            }
            keystoreTraceLogger.logExit(true);
            return true;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{this._keyStoreFile + ".bkup"}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
    }

    public synchronized void saveKeyStore() throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            File fileObj = new File(this._keyStoreFile);
            String parent = fileObj.getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            FileOutputStream ksStream = new FileOutputStream(this._keyStoreFile);
            this.certChainIssuerMap.clear();
            this._ks.store(ksStream, this._password);
            KeyStoreWriter.chtagKeyStoreBinaryOnzOS(fileObj);
            this.copyKeyStoreToJKS();
            timeStamp = System.currentTimeMillis();
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        keystoreTraceLogger.logExit(true);
    }

    private void copyKeyStoreToJKS() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore jksKeyStore = KeyStore.getInstance("JKS");
        jksKeyStore.load(null, null);
        Enumeration<String> e = this._ks.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (this._ks.isKeyEntry(alias)) {
                Key privKey = this._ks.getKey(alias, this._password);
                Certificate[] chain = this._ks.getCertificateChain(alias);
                jksKeyStore.setKeyEntry(alias, privKey, this._password, chain);
                continue;
            }
            Certificate cert = this._ks.getCertificate(alias);
            jksKeyStore.setCertificateEntry(alias, cert);
        }
        try (FileOutputStream jksStream = new FileOutputStream(this._keyStoreFile + ".jks");){
            jksKeyStore.store(jksStream, this._password);
        }
    }

    synchronized void setCaCert(Certificate caCert) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            String CAKeyPairAlias = ca;
            if (this._ks.containsAlias(ca)) {
                this.storeCertificateBackup(caCert);
            } else {
                this._ks.setCertificateEntry(ca, caCert);
            }
        }
        catch (CAMCryptoException e) {
            keystoreTraceLogger.logExit(e);
            throw e;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        keystoreTraceLogger.logExit(true);
    }

    public synchronized void setCert(String alias, Certificate[] certChain, PrivateKey key) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            if (this._ks.containsAlias(alias)) {
                this._ks.deleteEntry(alias);
            }
            this._ks.setKeyEntry(alias, key, this._password, certChain);
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        keystoreTraceLogger.logExit(true);
    }

    synchronized void setThirdPartyCert(String alias, Certificate[] certChain) throws CAMCryptoException {
        keystoreTraceLogger.logEnter();
        try {
            X509Certificate cert = (X509Certificate)this.getCertificate(alias);
            PrivateKey key = this.getPrivateKey(alias);
            if (!cert.getIssuerDN().equals(cert.getSubjectDN())) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_could_not_store_third_party_cert"));
            }
            this._ks.deleteEntry(alias);
            this._ks.setKeyEntry(alias, key, this._password, certChain);
        }
        catch (CAMCryptoException e) {
            keystoreTraceLogger.logExit(e);
            throw e;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{this._keyStoreFile}));
            keystoreTraceLogger.logExit(cce);
            throw cce;
        }
        keystoreTraceLogger.logExit(true);
    }

    private void storeCertificateBackup(Certificate certificate) throws CAMCryptoException, CertificateException, NoSuchProviderException, CertificateEncodingException, KeyStoreException {
        ByteArrayInputStream bais;
        CertificateFactory certFactory = null;
        certFactory = JVMEnvironment.getInstance().isFIPSEnabled() ? CertificateFactory.getInstance(certificate.getType(), JVMEnvironment.getInstance().getJCEProvider()) : CertificateFactory.getInstance(certificate.getType(), "BC");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(bais = new ByteArrayInputStream(certificate.getEncoded()));
        if (CAMCryptoUtilities.isCertExpired(cert)) {
            return;
        }
        String certIssuer = CAMCryptoUtilities.getNormalizedIssuerDN(cert);
        String certSerial = cert.getSerialNumber().toString();
        String backupAlias = CAMCryptoUtilities.getNormalizedIssuerDN(cert) + ";" + cert.getSerialNumber();
        if (!this._ks.containsAlias(backupAlias)) {
            this._ks.setCertificateEntry(backupAlias, cert);
        } else {
            X509Certificate existingCert = (X509Certificate)this._ks.getCertificate(backupAlias);
            if (existingCert != null && !existingCert.equals(cert)) {
                boolean done = false;
                int count = 1;
                while (!done) {
                    String alias = certIssuer + ";" + certSerial + ";" + count;
                    if (!this._ks.containsAlias(alias)) {
                        this._ks.setCertificateEntry(alias, cert);
                        done = true;
                        continue;
                    }
                    existingCert = (X509Certificate)this._ks.getCertificate(alias);
                    if (existingCert != null && existingCert.equals(cert)) break;
                    ++count;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        keystoreTraceLogger.logEnter();
        Class<JNIFileLock> clazz = JNIFileLock.class;
        synchronized (JNIFileLock.class) {
            JNISystemProperties.unlockFile((JNIFileLock)this._fileLock);
            this._fileLock = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            keystoreTraceLogger.logExit(true);
            return;
        }
    }

    public synchronized void updateParameters(String filename, String password, String format, String provider) {
        keystoreTraceLogger.logEnter();
        keystoreTraceLogger.trace("filename = " + filename);
        keystoreTraceLogger.trace("format = " + format);
        keystoreTraceLogger.trace("provider = " + provider);
        this._keyStoreFile = filename;
        this._password = password.toCharArray();
        this._format = format;
        this._provider = provider;
        this._lockFile = new File(this._keyStoreFile + ".lock");
        this._loaded = false;
        this.certChainIssuerMap.clear();
        keystoreTraceLogger.logExit(true);
    }
}

