/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CAMKeyStore;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.KeyStoreAccess;
import com.cognos.accman.jcam.crypto.misc.KeyStoreManager;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.res.MessageSet;
import com.cognos.crconfig.ICnfgFeedback;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

public class CAMX509TrustManager14
extends X509ExtendedTrustManager {
    private TrustManagerFactory trustManagerFactory;
    private X509ExtendedTrustManager pkixTrustManager;
    static IPFTraceLogger sslTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.SSL");
    static final Integer altNameType_DNS = 2;
    static final Integer altNameType_IP = 7;
    long pkixTruststoreTimeStamp = -1L;

    public CAMX509TrustManager14(KeyStore trustStore) throws CAMCryptoException {
        try {
            this.trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "Not able to create TrustManagerFactory instance";
            sslTraceLogger.fatalException(msg);
            throw new CAMCryptoException(e, msg);
        }
        this.initializeTrustManager(trustStore);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.pkixTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        String certName = this.getCertificateNameAndIssuer(x509Certificates);
        sslTraceLogger.trace("Start checkClientTrusted(x509Certificates, authType): " + certName);
        this.pkixTrustManager.checkClientTrusted(x509Certificates, authType);
        sslTraceLogger.trace("checkClientTrusted(x509Certificates, authType) verified " + certName);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine sslEngine) throws CertificateException {
        String certName = this.getCertificateNameAndIssuer(x509Certificates);
        sslTraceLogger.trace("Start checkClientTrusted(x509Certificates, authType, sslEngine): " + certName);
        this.pkixTrustManager.checkClientTrusted(x509Certificates, authType, sslEngine);
        sslTraceLogger.trace("checkClientTrusted(x509Certificates, authType, sslEngine) verified" + certName);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
        String certName = this.getCertificateNameAndIssuer(x509Certificates);
        sslTraceLogger.trace("Start checkClientTrusted(x509Certificates, authType, socket): " + certName);
        this.pkixTrustManager.checkClientTrusted(x509Certificates, authType, socket);
        sslTraceLogger.trace("checkClientTrusted(x509Certificates, authType, socket) verified " + certName);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        String certName = this.getCertificateNameAndIssuer(x509Certificates);
        sslTraceLogger.trace("Start checkServerTrusted(x509Certificates, authType): " + certName);
        try {
            this.pkixTrustManager.checkServerTrusted(x509Certificates, authType);
        }
        catch (CertificateException ce1) {
            CertificateException certiticateException = ce1;
            if (CAMKeyStore.timeStamp > this.pkixTruststoreTimeStamp) {
                try {
                    this.updatePKIXTrustManagerUsingUpdatedTrustStore();
                    this.pkixTrustManager.checkServerTrusted(x509Certificates, authType);
                    sslTraceLogger.trace("checkServerTrusted(x509Certificates, authType): " + certName + " is verified after updating trust store");
                    return;
                }
                catch (CertificateException ce2) {
                    certiticateException = ce2;
                }
            }
            this.camSSLCheck(x509Certificates, certiticateException);
        }
        sslTraceLogger.trace("checkServerTrusted(x509Certificates, authType) verified " + certName);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine sslEngine) throws CertificateException {
        String certName = this.getCertificateNameAndIssuer(x509Certificates);
        sslTraceLogger.trace("Start checkServerTrusted(x509Certificates, authType, sslEngine): " + certName);
        this.checkServerTrusted(x509Certificates, authType);
        SSLSession sslSession = sslEngine.getSession();
        String hostname = this.getHostnameFromSSLSession(sslSession);
        this.verifyCertificateHostname(x509Certificates, hostname, null, null);
        sslTraceLogger.trace("checkServerTrusted(x509Certificates, authType, sslEngine) verified " + certName);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
        String certName = this.getCertificateNameAndIssuer(x509Certificates);
        sslTraceLogger.trace("Start checkServerTrusted(x509Certificates, authType, socket): " + certName);
        this.checkServerTrusted(x509Certificates, authType);
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession sslSession = sslSocket.getHandshakeSession();
            String hostname = this.getHostnameFromSSLSession(sslSession);
            String fqdn = sslSocket.getInetAddress().getCanonicalHostName();
            String ipAddress = sslSocket.getInetAddress().getHostAddress();
            this.verifyCertificateHostname(x509Certificates, hostname, fqdn, ipAddress);
        } else {
            sslTraceLogger.trace("Inout prarmeter Socket is not SSLSocket");
        }
        sslTraceLogger.trace("checkServerTrusted(x509Certificates, authType, socket) verified " + certName);
    }

    private synchronized void initializeTrustManager(KeyStore trustStore) throws CAMCryptoException {
        sslTraceLogger.trace("Start initializeTrustManager");
        try {
            this.trustManagerFactory.init(trustStore);
        }
        catch (KeyStoreException e) {
            String msg = "Failed initializing TrustManagerFactory with Exception: " + e.getMessage();
            sslTraceLogger.fatalException(msg);
            throw new CAMCryptoException(e, msg);
        }
        TrustManager[] trustManagers = this.trustManagerFactory.getTrustManagers();
        int numTrustManagers = trustManagers.length;
        sslTraceLogger.trace("Number of TrustManagers = " + numTrustManagers);
        if (trustManagers != null && numTrustManagers > 0) {
            for (int i = 0; i < numTrustManagers; ++i) {
                TrustManager trustManager = trustManagers[i];
                if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
                this.pkixTrustManager = (X509ExtendedTrustManager)trustManager;
                sslTraceLogger.trace("Loaded X509EntendedTrustManager (" + i + ")");
                break;
            }
        }
        if (this.pkixTrustManager == null) {
            String msg = "Not able to find and set X509ExtendedTrustManager from TrustManagerFactory";
            sslTraceLogger.fatalException(msg);
            throw new CAMCryptoException(msg);
        }
        KeyStoreManager ksm = KeyStoreManager.getInstance();
        this.pkixTruststoreTimeStamp = CAMKeyStore.timeStamp;
        sslTraceLogger.trace("Completed initializeTrustManager");
    }

    private String getHostnameFromSSLSession(SSLSession sslSession) throws CertificateException {
        if (sslSession == null) {
            String msg = "Not able to validate SSL hostname. INVALID SSL session";
            sslTraceLogger.fatalException(msg);
            throw new CertificateException(msg);
        }
        return sslSession.getPeerHost();
    }

    private void updatePKIXTrustManagerUsingUpdatedTrustStore() throws CertificateException {
        sslTraceLogger.trace("Start updating TrustManager with new TurstStore");
        try {
            KeyStore trustStore;
            Configuration config = Configuration.getInstance();
            if (!config.getUsingThirdPartyCA() && (trustStore = KeyStoreAccess.getCAKeyStoreForSSLTrustManager()) != null) {
                sslTraceLogger.trace("initialize TurstManager with new TrustStore");
                this.initializeTrustManager(trustStore);
                sslTraceLogger.trace("Completed initializing TurstManager with updated TrustStore");
            }
        }
        catch (CAMCryptoException cce) {
            String msg = "Failed updating TrustManager. CAMCryptoException: " + cce.getMessage();
            sslTraceLogger.trace(msg);
            throw new CertificateException(msg);
        }
        sslTraceLogger.trace("Completed updating TurstStore");
    }

    private void camSSLCheck(X509Certificate[] x509Certificates, CertificateException e) throws CertificateException {
        sslTraceLogger.trace("camSSLCheck on CertificateException = " + e.getMessage());
        if (x509Certificates.length == 1 && this.checkAndVerifySelfSignedCertificate(x509Certificates[0])) {
            sslTraceLogger.trace("camSSLCheck: Self-signed certificate is verified trusted.");
            return;
        }
        sslTraceLogger.trace("camSSLCheck: Prompt and ask user");
        this.promptAndCheckUserResponse(x509Certificates, e);
        sslTraceLogger.trace("camSSLCheck: SSL certificate is accepted by user");
        sslTraceLogger.trace("Complated camSSLCheck");
    }

    private boolean checkAndVerifySelfSignedCertificate(X509Certificate x509Certificate) throws CertificateException {
        sslTraceLogger.trace("Start verifySelfSignedCertificate");
        boolean ret = false;
        if (CAMCryptoUtilities.isSelfSigned(x509Certificate)) {
            try {
                KeyStoreReader.verifySelfSignedClientCertificateIsTrusted(x509Certificate);
                ret = true;
            }
            catch (CAMCryptoException cce) {
                String msg = "Self signed certificate " + x509Certificate.getSubjectDN().getName() + " is not trusted. CAMCryptoException: " + cce.getMessage();
                sslTraceLogger.trace(msg);
            }
        }
        sslTraceLogger.trace("Completed verifySelfSignedCertificate returning " + ret);
        return ret;
    }

    private void promptAndCheckUserResponse(X509Certificate[] x509Certificates, CertificateException e) throws CertificateException {
        X509Certificate endCert = x509Certificates[0];
        String msg = "An SSL trust check of the server certificate with subject DN '" + endCert.getSubjectDN() + "' and issuer DN '" + endCert.getIssuerDN() + "' failed.  SSL connections made to this server will continue " + "to fail until trust of the issuer's certificate has been established.";
        sslTraceLogger.trace(msg);
        Configuration config = Configuration.getInstance();
        ICnfgFeedback feedback = config.getConfigFeedback();
        if (feedback == null) {
            throw e;
        }
        String name = endCert.getSubjectDN().getName();
        String issuer = endCert.getIssuerDN().getName();
        String beforeDate = endCert.getNotBefore().toString();
        String afterDate = endCert.getNotAfter().toString();
        String validPeriodwithCode = MessageSet.getMessage("CAM_CRP_cert_valid_period", new String[]{beforeDate, afterDate});
        int firstSpc = validPeriodwithCode.indexOf(32);
        String validPeriod = validPeriodwithCode.substring(firstSpc + 1);
        String questionWithCode = MessageSet.getMessage("CAM_CRP_cert_valid_question");
        firstSpc = questionWithCode.indexOf(32);
        String question = questionWithCode.substring(firstSpc + 1);
        String defaultAnswer = "1";
        String sslDefault = System.getProperty("CamCryptoAcceptSSLCertDefaultAnswer");
        if (sslDefault != null && 0 == sslDefault.compareToIgnoreCase("Yes")) {
            defaultAnswer = "0";
        }
        String captionWithCode = MessageSet.getMessage("CAM_CRP_cert_caption");
        firstSpc = captionWithCode.indexOf(32);
        String caption = captionWithCode.substring(firstSpc + 1);
        String source_errorWithCode = MessageSet.getMessage("CAM_CRP_cert_source");
        firstSpc = source_errorWithCode.indexOf(32);
        String source_error = source_errorWithCode.substring(firstSpc + 1);
        String cert_nameWithCode = MessageSet.getMessage("CAM_CRP_cert_details", new String[]{name, issuer});
        firstSpc = cert_nameWithCode.indexOf(32);
        String cert_name = cert_nameWithCode.substring(firstSpc + 1);
        String szCnfgMsg = "<prompt name=\"CryptoCertficateVerification\"><caption>" + caption + "</caption>" + "<type>warning</type>" + "<paragraph>" + source_error + "</paragraph>" + "<paragraph>" + cert_name + " " + validPeriod + "</paragraph>" + "<confirmation>" + question + "</confirmation>" + "<default>" + defaultAnswer + "</default>" + "</prompt>";
        String response = feedback.prompt(szCnfgMsg);
        if (response.compareToIgnoreCase("0") != 0) {
            sslTraceLogger.trace("User does not accept certificate " + this.getCertificateNameAndIssuer(x509Certificates));
            throw new CertificateException(e.toString());
        }
        sslTraceLogger.trace("SSL certificate " + this.getCertificateNameAndIssuer(x509Certificates) + " is accepted by user");
    }

    private String getCertificateNameAndIssuer(X509Certificate[] x509Certificates) throws CertificateException {
        int certChainLength = x509Certificates.length;
        if (certChainLength > 1) {
            X509Certificate endCert = x509Certificates[0];
            X509Certificate issuerCert = x509Certificates[1];
            return "'" + endCert.getSubjectDN().getName() + "' issued by '" + issuerCert.getSubjectDN().getName() + "'";
        }
        if (certChainLength == 1) {
            X509Certificate endCert = x509Certificates[0];
            return "'" + endCert.getSubjectDN().getName() + "'";
        }
        throw new CertificateException("Invalid chertificate chain");
    }

    private void verifyCertificateHostname(X509Certificate[] x509Certificates, String hostname, String fqdn, String ipAddress) throws CertificateException {
        String certName = this.getCertificateNameAndIssuer(x509Certificates);
        sslTraceLogger.trace("Start verifyCertificateHostname: " + certName);
        Configuration config = Configuration.getInstance();
        boolean enableSSSHostnameVerification = config.getEnableSSLHostnameVerification();
        if (!enableSSSHostnameVerification) {
            sslTraceLogger.trace("SSL hostname verification is not enabled");
            return;
        }
        X509Certificate sslServerCertificate = x509Certificates[0];
        Collection<List<?>> alternativeNameCollection = sslServerCertificate.getSubjectAlternativeNames();
        if (alternativeNameCollection != null) {
            if (this.verifySubjectAlternativeNames(alternativeNameCollection, hostname, fqdn, ipAddress)) {
                String msg = "Verifed Subject Alternative Name = '" + alternativeNameCollection.toString() + "' of SSL certificate: " + certName;
                sslTraceLogger.trace(msg);
                return;
            }
            String msg = "The peer hostname '" + hostname + "' and FQDN '" + fqdn + "' and IP address'" + ipAddress + "' does not match  " + "Subject Alternative Name = '" + alternativeNameCollection.toString() + "' of SSL certificate: " + certName;
            sslTraceLogger.fatalException(msg);
            throw new CertificateException(msg);
        }
        String certSubjectDN = sslServerCertificate.getSubjectDN().getName();
        String serverCommonName = this.getServerCommonName(certSubjectDN);
        if (this.verifyServerCommonName(serverCommonName, hostname, fqdn, ipAddress)) {
            String msg = "Verified Server Common Name '" + serverCommonName + "' of SSL certificate: " + certName;
            sslTraceLogger.trace(msg);
            return;
        }
        String msg = "Subject Alternative Name of SSL certificate " + certName + " is empty. " + "And the peer hostname '" + hostname + "' and FQDN '" + fqdn + "' and IP address '" + ipAddress + "' does not match " + "configured Server Common Name '" + serverCommonName;
        sslTraceLogger.fatalException(msg);
        throw new CertificateException(msg);
    }

    protected boolean verifySubjectAlternativeNames(Collection<List<?>> alternativeNameCollection, String hostname, String fqdn, String ipAddress) throws CertificateException {
        sslTraceLogger.trace("Start verifySubjectAlternativeNames");
        for (List<?> alternativeName : alternativeNameCollection) {
            Integer altNameType = (Integer)alternativeName.get(0);
            String san = (String)alternativeName.get(1);
            if (altNameType.equals(altNameType_IP)) {
                if (ipAddress == null || !san.equalsIgnoreCase(ipAddress)) continue;
                String msg = "Verified peer ip address '" + ipAddress + "' matches Subject Alternative Name.'";
                sslTraceLogger.trace(msg);
                return true;
            }
            if (!altNameType.equals(altNameType_DNS)) continue;
            if (fqdn != null && san.equalsIgnoreCase(fqdn)) {
                String msg = "Verified peer FQDN '" + fqdn + "' matches Subject Alternative Name.'";
                sslTraceLogger.trace(msg);
                return true;
            }
            if (hostname != null && san.equalsIgnoreCase(hostname)) {
                String msg = "Verified peer hostname '" + hostname + "' matches Subject Alternative Name.'";
                sslTraceLogger.trace(msg);
                return true;
            }
            if (!san.startsWith("*")) continue;
            if (CAMCryptoUtilities.checkWildcardMatch(san, hostname)) {
                String msg = "Verified '" + hostname + "' matches Subject Alternative Name '" + san + "'.";
                sslTraceLogger.trace(msg);
                return true;
            }
            if (!CAMCryptoUtilities.checkWildcardMatch(san, fqdn)) continue;
            String msg = "Verified '" + fqdn + "' matches Subject Alternative Name '" + san + "'.";
            sslTraceLogger.trace(msg);
            return true;
        }
        sslTraceLogger.trace("Failed verifying Subject Alternative Name");
        return false;
    }

    protected String getServerCommonName(String certSubjectDN) {
        StringTokenizer st = new StringTokenizer(certSubjectDN.replaceAll("\\s+", "").toLowerCase(), ",");
        while (st.hasMoreElements()) {
            String token = (String)st.nextElement();
            if (!token.startsWith("cn=")) continue;
            return token.substring(3);
        }
        return null;
    }

    protected boolean verifyServerCommonName(String serverCommonName, String peerHostname, String fqdn, String ipAddress) {
        sslTraceLogger.trace("Start verifyServerCommonName: " + serverCommonName);
        if (serverCommonName == null || serverCommonName.length() == 0) {
            return false;
        }
        if (serverCommonName.startsWith("*")) {
            if (CAMCryptoUtilities.checkWildcardMatch(serverCommonName, fqdn) || CAMCryptoUtilities.checkWildcardMatch(serverCommonName, peerHostname)) {
                return true;
            }
        } else {
            if (serverCommonName.compareToIgnoreCase(peerHostname) == 0) {
                String msg = "Verified peer hostname '" + peerHostname + "' matches configured Server Common Name '" + serverCommonName + "'.";
                sslTraceLogger.trace(msg);
                return true;
            }
            if (serverCommonName.compareToIgnoreCase(fqdn) == 0) {
                String msg = "Verified peer FQDN '" + fqdn + "' matches configured Server Common Name '" + serverCommonName + "'.";
                sslTraceLogger.trace(msg);
                return true;
            }
            if (serverCommonName.compareToIgnoreCase(ipAddress) == 0) {
                String msg = "Verified peer IP address '" + ipAddress + "' matches configured Server Common Name '" + serverCommonName + "'.";
                sslTraceLogger.trace(msg);
                return true;
            }
        }
        sslTraceLogger.trace("Server Common Name is null. peer hostname = " + peerHostname + ", fqdn = " + fqdn + ", ipAddress = " + ipAddress);
        return false;
    }
}

