/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.misc.CMStoreWrapperException;
import com.cognos.accman.res.MessageSet;
import java.lang.reflect.Method;

public class CMStoreWrapper {
    private Method _getData;
    private Method _setData;
    private Method _addData;
    private Method _getAllDataKeys;
    private Object _this;
    private static CMStoreWrapper singleton = null;

    private CMStoreWrapper() throws CMStoreWrapperException {
        try {
            Class<?> cmClass = Class.forName("com.cognos.cm.store.CMCryptoDataStore");
            Class[] strParams = new Class[]{String.class};
            Class[] strByteArrParams = new Class[]{String.class, byte[].class};
            Class[] emptyParams = new Class[]{};
            Method get = cmClass.getMethod("get", emptyParams);
            this._this = get.invoke(null, new Object[0]);
            this._getData = cmClass.getMethod("getData", strParams);
            this._setData = cmClass.getMethod("setData", strByteArrParams);
            this._addData = cmClass.getMethod("addData", strByteArrParams);
            this._getAllDataKeys = cmClass.getMethod("getAllDataKeys", emptyParams);
        }
        catch (Exception e) {
            throw new CMStoreWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_error"));
        }
        if (this._this == null || this._getData == null || this._setData == null || this._addData == null || this._getAllDataKeys == null) {
            throw new CMStoreWrapperException(MessageSet.getMessage("CAM_CRP_cm_store_wrapper_error"));
        }
    }

    static synchronized CMStoreWrapper get() throws CMStoreWrapperException {
        if (singleton == null) {
            singleton = new CMStoreWrapper();
        }
        return singleton;
    }

    byte[] getData(String key) throws CMStoreWrapperException {
        byte[] ret = null;
        try {
            ret = (byte[])this._getData.invoke(this._this, key);
        }
        catch (Exception e) {
            throw new CMStoreWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_error"));
        }
        return ret;
    }

    void setData(String key, byte[] data) throws CMStoreWrapperException {
        try {
            this._setData.invoke(this._this, key, data);
        }
        catch (Exception e) {
            throw new CMStoreWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_error"));
        }
    }

    void addData(String key, byte[] data) throws CMStoreWrapperException {
        try {
            this._addData.invoke(this._this, key, data);
        }
        catch (Exception e) {
            throw new CMStoreWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_error"));
        }
    }

    String[] getAllDataKeys() throws CMStoreWrapperException {
        try {
            String[] ret = (String[])this._getAllDataKeys.invoke(this._this, new Object[0]);
            return ret;
        }
        catch (Exception e) {
            throw new CMStoreWrapperException(e, MessageSet.getMessage("CAM_CRP_cm_store_wrapper_error"));
        }
    }
}

