/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import javax.crypto.SecretKey;

public class CSKDigest {
    private static CSKDigest instance;
    private byte[] currentCSKDigest;
    private boolean cskUpdateRequired = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CSKDigest getInstance() {
        if (instance != null) return instance;
        Class<CSKDigest> clazz = CSKDigest.class;
        synchronized (CSKDigest.class) {
            if (instance != null) return instance;
            instance = new CSKDigest();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CSKDigest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCurrentCSKDigest() throws CAMCryptoException {
        if (this.cskUpdateRequired) {
            CSKDigest cSKDigest = this;
            synchronized (cSKDigest) {
                if (this.cskUpdateRequired) {
                    this.updateCurrentCSKDigest();
                    this.cskUpdateRequired = false;
                }
            }
        }
        return this.currentCSKDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCSKUpdateRequired() {
        CSKDigest cSKDigest = this;
        synchronized (cSKDigest) {
            this.cskUpdateRequired = true;
        }
    }

    private void updateCurrentCSKDigest() throws CAMCryptoException {
        SecretKey currentCSK = KeyStoreReader.getCSKWithoutExpiryCheck();
        this.currentCSKDigest = CAMCryptoUtilities.digestCSK(currentCSK);
    }
}

